package org.openqa.selenium.devtools.v139.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a prefetch attempt is updated.
 */
public class PrefetchStatusUpdated {

    private final org.openqa.selenium.devtools.v139.preload.model.PreloadingAttemptKey key;

    private final org.openqa.selenium.devtools.v139.preload.model.PreloadPipelineId pipelineId;

    private final org.openqa.selenium.devtools.v139.page.model.FrameId initiatingFrameId;

    private final java.lang.String prefetchUrl;

    private final org.openqa.selenium.devtools.v139.preload.model.PreloadingStatus status;

    private final org.openqa.selenium.devtools.v139.preload.model.PrefetchStatus prefetchStatus;

    private final org.openqa.selenium.devtools.v139.network.model.RequestId requestId;

    public PrefetchStatusUpdated(org.openqa.selenium.devtools.v139.preload.model.PreloadingAttemptKey key, org.openqa.selenium.devtools.v139.preload.model.PreloadPipelineId pipelineId, org.openqa.selenium.devtools.v139.page.model.FrameId initiatingFrameId, java.lang.String prefetchUrl, org.openqa.selenium.devtools.v139.preload.model.PreloadingStatus status, org.openqa.selenium.devtools.v139.preload.model.PrefetchStatus prefetchStatus, org.openqa.selenium.devtools.v139.network.model.RequestId requestId) {
        this.key = java.util.Objects.requireNonNull(key, "key is required");
        this.pipelineId = java.util.Objects.requireNonNull(pipelineId, "pipelineId is required");
        this.initiatingFrameId = java.util.Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prefetchUrl = java.util.Objects.requireNonNull(prefetchUrl, "prefetchUrl is required");
        this.status = java.util.Objects.requireNonNull(status, "status is required");
        this.prefetchStatus = java.util.Objects.requireNonNull(prefetchStatus, "prefetchStatus is required");
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
    }

    public org.openqa.selenium.devtools.v139.preload.model.PreloadingAttemptKey getKey() {
        return key;
    }

    public org.openqa.selenium.devtools.v139.preload.model.PreloadPipelineId getPipelineId() {
        return pipelineId;
    }

    /**
     * The frame id of the frame initiating prefetch.
     */
    public org.openqa.selenium.devtools.v139.page.model.FrameId getInitiatingFrameId() {
        return initiatingFrameId;
    }

    public java.lang.String getPrefetchUrl() {
        return prefetchUrl;
    }

    public org.openqa.selenium.devtools.v139.preload.model.PreloadingStatus getStatus() {
        return status;
    }

    public org.openqa.selenium.devtools.v139.preload.model.PrefetchStatus getPrefetchStatus() {
        return prefetchStatus;
    }

    public org.openqa.selenium.devtools.v139.network.model.RequestId getRequestId() {
        return requestId;
    }

    private static PrefetchStatusUpdated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v139.preload.model.PreloadingAttemptKey key = null;
        org.openqa.selenium.devtools.v139.preload.model.PreloadPipelineId pipelineId = null;
        org.openqa.selenium.devtools.v139.page.model.FrameId initiatingFrameId = null;
        java.lang.String prefetchUrl = null;
        org.openqa.selenium.devtools.v139.preload.model.PreloadingStatus status = null;
        org.openqa.selenium.devtools.v139.preload.model.PrefetchStatus prefetchStatus = null;
        org.openqa.selenium.devtools.v139.network.model.RequestId requestId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "key":
                    key = input.read(org.openqa.selenium.devtools.v139.preload.model.PreloadingAttemptKey.class);
                    break;
                case "pipelineId":
                    pipelineId = input.read(org.openqa.selenium.devtools.v139.preload.model.PreloadPipelineId.class);
                    break;
                case "initiatingFrameId":
                    initiatingFrameId = input.read(org.openqa.selenium.devtools.v139.page.model.FrameId.class);
                    break;
                case "prefetchUrl":
                    prefetchUrl = input.nextString();
                    break;
                case "status":
                    status = input.read(org.openqa.selenium.devtools.v139.preload.model.PreloadingStatus.class);
                    break;
                case "prefetchStatus":
                    prefetchStatus = input.read(org.openqa.selenium.devtools.v139.preload.model.PrefetchStatus.class);
                    break;
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v139.network.model.RequestId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PrefetchStatusUpdated(key, pipelineId, initiatingFrameId, prefetchUrl, status, prefetchStatus, requestId);
    }
}
