package org.openqa.selenium.devtools.v139.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Represents a dictionary object passed in as privateAggregationConfig to
 * run or selectURL.
 */
public class SharedStoragePrivateAggregationConfig {

    private final java.util.Optional<java.lang.String> aggregationCoordinatorOrigin;

    private final java.util.Optional<java.lang.String> contextId;

    private final java.lang.Integer filteringIdMaxBytes;

    private final java.util.Optional<java.lang.Integer> maxContributions;

    public SharedStoragePrivateAggregationConfig(java.util.Optional<java.lang.String> aggregationCoordinatorOrigin, java.util.Optional<java.lang.String> contextId, java.lang.Integer filteringIdMaxBytes, java.util.Optional<java.lang.Integer> maxContributions) {
        this.aggregationCoordinatorOrigin = aggregationCoordinatorOrigin;
        this.contextId = contextId;
        this.filteringIdMaxBytes = java.util.Objects.requireNonNull(filteringIdMaxBytes, "filteringIdMaxBytes is required");
        this.maxContributions = maxContributions;
    }

    /**
     * The chosen aggregation service deployment.
     */
    public java.util.Optional<java.lang.String> getAggregationCoordinatorOrigin() {
        return aggregationCoordinatorOrigin;
    }

    /**
     * The context ID provided.
     */
    public java.util.Optional<java.lang.String> getContextId() {
        return contextId;
    }

    /**
     * Configures the maximum size allowed for filtering IDs.
     */
    public java.lang.Integer getFilteringIdMaxBytes() {
        return filteringIdMaxBytes;
    }

    /**
     * The limit on the number of contributions in the final report.
     */
    public java.util.Optional<java.lang.Integer> getMaxContributions() {
        return maxContributions;
    }

    private static SharedStoragePrivateAggregationConfig fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> aggregationCoordinatorOrigin = java.util.Optional.empty();
        java.util.Optional<java.lang.String> contextId = java.util.Optional.empty();
        java.lang.Integer filteringIdMaxBytes = 0;
        java.util.Optional<java.lang.Integer> maxContributions = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "aggregationCoordinatorOrigin":
                    aggregationCoordinatorOrigin = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "contextId":
                    contextId = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "filteringIdMaxBytes":
                    filteringIdMaxBytes = input.nextNumber().intValue();
                    break;
                case "maxContributions":
                    maxContributions = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedStoragePrivateAggregationConfig(aggregationCoordinatorOrigin, contextId, filteringIdMaxBytes, maxContributions);
    }
}
