package org.openqa.selenium.devtools.v140.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload) has been
 * closed.
 */
public class JavascriptDialogClosed {

    private final org.openqa.selenium.devtools.v140.page.model.FrameId frameId;

    private final java.lang.Boolean result;

    private final java.lang.String userInput;

    public JavascriptDialogClosed(org.openqa.selenium.devtools.v140.page.model.FrameId frameId, java.lang.Boolean result, java.lang.String userInput) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.result = java.util.Objects.requireNonNull(result, "result is required");
        this.userInput = java.util.Objects.requireNonNull(userInput, "userInput is required");
    }

    /**
     * Frame id.
     */
    @Beta()
    public org.openqa.selenium.devtools.v140.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * Whether dialog was confirmed.
     */
    public java.lang.Boolean getResult() {
        return result;
    }

    /**
     * User input in case of prompt.
     */
    public java.lang.String getUserInput() {
        return userInput;
    }

    private static JavascriptDialogClosed fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v140.page.model.FrameId frameId = null;
        java.lang.Boolean result = false;
        java.lang.String userInput = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v140.page.model.FrameId.class);
                    break;
                case "result":
                    result = input.nextBoolean();
                    break;
                case "userInput":
                    userInput = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new JavascriptDialogClosed(frameId, result, userInput);
    }
}
