package org.openqa.selenium.devtools.v141.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class UnencodedDigestIssueDetails {

    private final org.openqa.selenium.devtools.v141.audits.model.UnencodedDigestError error;

    private final org.openqa.selenium.devtools.v141.audits.model.AffectedRequest request;

    public UnencodedDigestIssueDetails(org.openqa.selenium.devtools.v141.audits.model.UnencodedDigestError error, org.openqa.selenium.devtools.v141.audits.model.AffectedRequest request) {
        this.error = java.util.Objects.requireNonNull(error, "error is required");
        this.request = java.util.Objects.requireNonNull(request, "request is required");
    }

    public org.openqa.selenium.devtools.v141.audits.model.UnencodedDigestError getError() {
        return error;
    }

    public org.openqa.selenium.devtools.v141.audits.model.AffectedRequest getRequest() {
        return request;
    }

    private static UnencodedDigestIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v141.audits.model.UnencodedDigestError error = null;
        org.openqa.selenium.devtools.v141.audits.model.AffectedRequest request = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "error":
                    error = input.read(org.openqa.selenium.devtools.v141.audits.model.UnencodedDigestError.class);
                    break;
                case "request":
                    request = input.read(org.openqa.selenium.devtools.v141.audits.model.AffectedRequest.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new UnencodedDigestIssueDetails(error, request);
    }
}
