package org.openqa.selenium.devtools.v141.browser.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when download makes progress. Last call has |done| == true.
 */
@org.openqa.selenium.Beta()
public class DownloadProgress {

    public enum State {

        INPROGRESS("inProgress"), COMPLETED("completed"), CANCELED("canceled");

        private String value;

        State(String value) {
            this.value = value;
        }

        public static State fromString(String s) {
            return java.util.Arrays.stream(State.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within State "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static State fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final java.lang.String guid;

    private final java.lang.Number totalBytes;

    private final java.lang.Number receivedBytes;

    private final State state;

    private final java.util.Optional<java.lang.String> filePath;

    public DownloadProgress(java.lang.String guid, java.lang.Number totalBytes, java.lang.Number receivedBytes, State state, java.util.Optional<java.lang.String> filePath) {
        this.guid = java.util.Objects.requireNonNull(guid, "guid is required");
        this.totalBytes = java.util.Objects.requireNonNull(totalBytes, "totalBytes is required");
        this.receivedBytes = java.util.Objects.requireNonNull(receivedBytes, "receivedBytes is required");
        this.state = java.util.Objects.requireNonNull(state, "state is required");
        this.filePath = filePath;
    }

    /**
     * Global unique identifier of the download.
     */
    public java.lang.String getGuid() {
        return guid;
    }

    /**
     * Total expected bytes to download.
     */
    public java.lang.Number getTotalBytes() {
        return totalBytes;
    }

    /**
     * Total bytes received.
     */
    public java.lang.Number getReceivedBytes() {
        return receivedBytes;
    }

    /**
     * Download status.
     */
    public State getState() {
        return state;
    }

    /**
     * If download is "completed", provides the path of the downloaded file.
     * Depending on the platform, it is not guaranteed to be set, nor the file
     * is guaranteed to exist.
     */
    @Beta()
    public java.util.Optional<java.lang.String> getFilePath() {
        return filePath;
    }

    private static DownloadProgress fromJson(JsonInput input) {
        java.lang.String guid = null;
        java.lang.Number totalBytes = 0;
        java.lang.Number receivedBytes = 0;
        State state = null;
        java.util.Optional<java.lang.String> filePath = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "guid":
                    guid = input.nextString();
                    break;
                case "totalBytes":
                    totalBytes = input.nextNumber();
                    break;
                case "receivedBytes":
                    receivedBytes = input.nextNumber();
                    break;
                case "state":
                    state = State.fromString(input.nextString());
                    break;
                case "filePath":
                    filePath = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DownloadProgress(guid, totalBytes, receivedBytes, state, filePath);
    }
}
