package org.openqa.selenium.devtools.v141.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Screen information similar to the one returned by window.getScreenDetails() method,
 * see https://w3c.github.io/window-management/#screendetailed.
 */
@org.openqa.selenium.Beta()
public class ScreenInfo {

    private final java.lang.Integer left;

    private final java.lang.Integer top;

    private final java.lang.Integer width;

    private final java.lang.Integer height;

    private final java.lang.Integer availLeft;

    private final java.lang.Integer availTop;

    private final java.lang.Integer availWidth;

    private final java.lang.Integer availHeight;

    private final java.lang.Number devicePixelRatio;

    private final org.openqa.selenium.devtools.v141.emulation.model.ScreenOrientation orientation;

    private final java.lang.Integer colorDepth;

    private final java.lang.Boolean isExtended;

    private final java.lang.Boolean isInternal;

    private final java.lang.Boolean isPrimary;

    private final java.lang.String label;

    private final org.openqa.selenium.devtools.v141.emulation.model.ScreenId id;

    public ScreenInfo(java.lang.Integer left, java.lang.Integer top, java.lang.Integer width, java.lang.Integer height, java.lang.Integer availLeft, java.lang.Integer availTop, java.lang.Integer availWidth, java.lang.Integer availHeight, java.lang.Number devicePixelRatio, org.openqa.selenium.devtools.v141.emulation.model.ScreenOrientation orientation, java.lang.Integer colorDepth, java.lang.Boolean isExtended, java.lang.Boolean isInternal, java.lang.Boolean isPrimary, java.lang.String label, org.openqa.selenium.devtools.v141.emulation.model.ScreenId id) {
        this.left = java.util.Objects.requireNonNull(left, "left is required");
        this.top = java.util.Objects.requireNonNull(top, "top is required");
        this.width = java.util.Objects.requireNonNull(width, "width is required");
        this.height = java.util.Objects.requireNonNull(height, "height is required");
        this.availLeft = java.util.Objects.requireNonNull(availLeft, "availLeft is required");
        this.availTop = java.util.Objects.requireNonNull(availTop, "availTop is required");
        this.availWidth = java.util.Objects.requireNonNull(availWidth, "availWidth is required");
        this.availHeight = java.util.Objects.requireNonNull(availHeight, "availHeight is required");
        this.devicePixelRatio = java.util.Objects.requireNonNull(devicePixelRatio, "devicePixelRatio is required");
        this.orientation = java.util.Objects.requireNonNull(orientation, "orientation is required");
        this.colorDepth = java.util.Objects.requireNonNull(colorDepth, "colorDepth is required");
        this.isExtended = java.util.Objects.requireNonNull(isExtended, "isExtended is required");
        this.isInternal = java.util.Objects.requireNonNull(isInternal, "isInternal is required");
        this.isPrimary = java.util.Objects.requireNonNull(isPrimary, "isPrimary is required");
        this.label = java.util.Objects.requireNonNull(label, "label is required");
        this.id = java.util.Objects.requireNonNull(id, "id is required");
    }

    /**
     * Offset of the left edge of the screen.
     */
    public java.lang.Integer getLeft() {
        return left;
    }

    /**
     * Offset of the top edge of the screen.
     */
    public java.lang.Integer getTop() {
        return top;
    }

    /**
     * Width of the screen.
     */
    public java.lang.Integer getWidth() {
        return width;
    }

    /**
     * Height of the screen.
     */
    public java.lang.Integer getHeight() {
        return height;
    }

    /**
     * Offset of the left edge of the available screen area.
     */
    public java.lang.Integer getAvailLeft() {
        return availLeft;
    }

    /**
     * Offset of the top edge of the available screen area.
     */
    public java.lang.Integer getAvailTop() {
        return availTop;
    }

    /**
     * Width of the available screen area.
     */
    public java.lang.Integer getAvailWidth() {
        return availWidth;
    }

    /**
     * Height of the available screen area.
     */
    public java.lang.Integer getAvailHeight() {
        return availHeight;
    }

    /**
     * Specifies the screen's device pixel ratio.
     */
    public java.lang.Number getDevicePixelRatio() {
        return devicePixelRatio;
    }

    /**
     * Specifies the screen's orientation.
     */
    public org.openqa.selenium.devtools.v141.emulation.model.ScreenOrientation getOrientation() {
        return orientation;
    }

    /**
     * Specifies the screen's color depth in bits.
     */
    public java.lang.Integer getColorDepth() {
        return colorDepth;
    }

    /**
     * Indicates whether the device has multiple screens.
     */
    public java.lang.Boolean getIsExtended() {
        return isExtended;
    }

    /**
     * Indicates whether the screen is internal to the device or external, attached to the device.
     */
    public java.lang.Boolean getIsInternal() {
        return isInternal;
    }

    /**
     * Indicates whether the screen is set as the the operating system primary screen.
     */
    public java.lang.Boolean getIsPrimary() {
        return isPrimary;
    }

    /**
     * Specifies the descriptive label for the screen.
     */
    public java.lang.String getLabel() {
        return label;
    }

    /**
     * Specifies the unique identifier of the screen.
     */
    public org.openqa.selenium.devtools.v141.emulation.model.ScreenId getId() {
        return id;
    }

    private static ScreenInfo fromJson(JsonInput input) {
        java.lang.Integer left = 0;
        java.lang.Integer top = 0;
        java.lang.Integer width = 0;
        java.lang.Integer height = 0;
        java.lang.Integer availLeft = 0;
        java.lang.Integer availTop = 0;
        java.lang.Integer availWidth = 0;
        java.lang.Integer availHeight = 0;
        java.lang.Number devicePixelRatio = 0;
        org.openqa.selenium.devtools.v141.emulation.model.ScreenOrientation orientation = null;
        java.lang.Integer colorDepth = 0;
        java.lang.Boolean isExtended = false;
        java.lang.Boolean isInternal = false;
        java.lang.Boolean isPrimary = false;
        java.lang.String label = null;
        org.openqa.selenium.devtools.v141.emulation.model.ScreenId id = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "left":
                    left = input.nextNumber().intValue();
                    break;
                case "top":
                    top = input.nextNumber().intValue();
                    break;
                case "width":
                    width = input.nextNumber().intValue();
                    break;
                case "height":
                    height = input.nextNumber().intValue();
                    break;
                case "availLeft":
                    availLeft = input.nextNumber().intValue();
                    break;
                case "availTop":
                    availTop = input.nextNumber().intValue();
                    break;
                case "availWidth":
                    availWidth = input.nextNumber().intValue();
                    break;
                case "availHeight":
                    availHeight = input.nextNumber().intValue();
                    break;
                case "devicePixelRatio":
                    devicePixelRatio = input.nextNumber();
                    break;
                case "orientation":
                    orientation = input.read(org.openqa.selenium.devtools.v141.emulation.model.ScreenOrientation.class);
                    break;
                case "colorDepth":
                    colorDepth = input.nextNumber().intValue();
                    break;
                case "isExtended":
                    isExtended = input.nextBoolean();
                    break;
                case "isInternal":
                    isInternal = input.nextBoolean();
                    break;
                case "isPrimary":
                    isPrimary = input.nextBoolean();
                    break;
                case "label":
                    label = input.nextString();
                    break;
                case "id":
                    id = input.read(org.openqa.selenium.devtools.v141.emulation.model.ScreenId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ScreenInfo(left, top, width, height, availLeft, availTop, availWidth, availHeight, devicePixelRatio, orientation, colorDepth, isExtended, isInternal, isPrimary, label, id);
    }
}
