/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.VisibleForTesting;
import graphql.execution.EngineRunningObserver;
import graphql.execution.ExecutionId;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

@Internal
public class EngineRunningState {
    private final @Nullable EngineRunningObserver engineRunningObserver;
    private final @Nullable GraphQLContext graphQLContext;
    private volatile @Nullable ExecutionId executionId;
    private final AtomicInteger isRunning = new AtomicInteger(0);

    @VisibleForTesting
    public EngineRunningState() {
        this.engineRunningObserver = null;
        this.graphQLContext = null;
        this.executionId = null;
    }

    public EngineRunningState(ExecutionInput executionInput) {
        EngineRunningObserver engineRunningObserver = (EngineRunningObserver)executionInput.getGraphQLContext().get("__ENGINE_RUNNING_OBSERVER");
        if (engineRunningObserver != null) {
            this.engineRunningObserver = engineRunningObserver;
            this.graphQLContext = executionInput.getGraphQLContext();
            this.executionId = executionInput.getExecutionId();
        } else {
            this.engineRunningObserver = null;
            this.graphQLContext = null;
            this.executionId = null;
        }
    }

    public <U, T> CompletableFuture<U> handle(CompletableFuture<T> src, BiFunction<? super T, Throwable, ? extends U> fn) {
        if (this.engineRunningObserver == null) {
            return src.handle(fn);
        }
        src = this.observeCompletableFutureStart(src);
        CompletionStage result = src.handle((t2, throwable) -> {
            if (throwable != null) {
                throwable = throwable.getCause();
            }
            return fn.apply((Object)t2, (Throwable)throwable);
        });
        this.observerCompletableFutureEnd(src);
        return result;
    }

    public <T> CompletableFuture<T> whenComplete(CompletableFuture<T> src, BiConsumer<? super T, ? super Throwable> fn) {
        if (this.engineRunningObserver == null) {
            return src.whenComplete(fn);
        }
        src = this.observeCompletableFutureStart(src);
        CompletionStage result = src.whenComplete((t2, throwable) -> {
            if (throwable != null) {
                throwable = throwable.getCause();
            }
            fn.accept((Object)t2, (Throwable)throwable);
        });
        this.observerCompletableFutureEnd(src);
        return result;
    }

    public <U, T> CompletableFuture<U> compose(CompletableFuture<T> src, Function<? super T, ? extends CompletionStage<U>> fn) {
        if (this.engineRunningObserver == null) {
            return src.thenCompose(fn);
        }
        CompletableFuture result = new CompletableFuture();
        src = this.observeCompletableFutureStart(src);
        src.whenComplete((u, t2) -> {
            CompletableFuture<Object> innerCF;
            try {
                innerCF = ((CompletionStage)fn.apply(u)).toCompletableFuture();
            }
            catch (Throwable e) {
                innerCF = CompletableFuture.failedFuture(e);
            }
            innerCF.whenComplete((u1, t1) -> this.run(() -> {
                if (t1 != null) {
                    result.completeExceptionally((Throwable)t1);
                } else {
                    result.complete(u1);
                }
            }));
        });
        this.observerCompletableFutureEnd(src);
        return result;
    }

    private <T> CompletableFuture<T> observeCompletableFutureStart(CompletableFuture<T> future) {
        if (this.engineRunningObserver == null) {
            return future;
        }
        future = future.thenApply(Function.identity());
        this.incrementRunningWhenCompleted((CompletableFuture<?>)future);
        return future;
    }

    private void observerCompletableFutureEnd(CompletableFuture<?> future) {
        if (this.engineRunningObserver == null) {
            return;
        }
        this.decrementRunningWhenCompleted(future);
    }

    private void incrementRunningWhenCompleted(CompletableFuture<?> cf) {
        cf.whenComplete((result, throwable) -> this.incrementRunning());
    }

    private void decrementRunningWhenCompleted(CompletableFuture<?> cf) {
        cf.whenComplete((result, throwable) -> this.decrementRunning());
    }

    private void decrementRunning() {
        if (this.engineRunningObserver == null) {
            return;
        }
        Assert.assertTrue(this.isRunning.get() > 0);
        if (this.isRunning.decrementAndGet() == 0) {
            this.changeOfState(EngineRunningObserver.RunningState.NOT_RUNNING);
        }
    }

    private void incrementRunning() {
        if (this.engineRunningObserver == null) {
            return;
        }
        Assert.assertTrue(this.isRunning.get() >= 0);
        if (this.isRunning.incrementAndGet() == 1) {
            this.changeOfState(EngineRunningObserver.RunningState.RUNNING);
        }
    }

    public void updateExecutionId(ExecutionId executionId) {
        if (this.engineRunningObserver == null) {
            return;
        }
        this.executionId = executionId;
    }

    private void changeOfState(EngineRunningObserver.RunningState runningState) {
        this.engineRunningObserver.runningStateChanged(this.executionId, this.graphQLContext, runningState);
    }

    private void run(Runnable runnable) {
        if (this.engineRunningObserver == null) {
            runnable.run();
            return;
        }
        this.incrementRunning();
        try {
            runnable.run();
        }
        finally {
            this.decrementRunning();
        }
    }

    public <T> T call(Supplier<T> supplier) {
        if (this.engineRunningObserver == null) {
            return supplier.get();
        }
        this.incrementRunning();
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            this.decrementRunning();
        }
    }
}

