/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Internal;
import graphql.execution.directives.QueryAppliedDirective;
import graphql.language.VariableDefinition;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.NormalizedInputValue;
import graphql.normalized.ValueToVariableValueCompiler;
import graphql.normalized.VariablePredicate;
import graphql.normalized.VariableValueWithDefinition;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

@Internal
public class VariableAccumulator {
    private final List<VariableValueWithDefinition> valueWithDefinitions;
    private final @Nullable VariablePredicate variablePredicate;

    public VariableAccumulator(@Nullable VariablePredicate variablePredicate) {
        this.variablePredicate = variablePredicate;
        this.valueWithDefinitions = new ArrayList<VariableValueWithDefinition>();
    }

    public boolean shouldMakeVariable(ExecutableNormalizedField executableNormalizedField, QueryAppliedDirective queryAppliedDirective, String argName, NormalizedInputValue normalizedInputValue) {
        if (queryAppliedDirective != null) {
            return this.variablePredicate != null && this.variablePredicate.shouldMakeVariable(executableNormalizedField, queryAppliedDirective, argName, normalizedInputValue);
        }
        return this.variablePredicate != null && this.variablePredicate.shouldMakeVariable(executableNormalizedField, argName, normalizedInputValue);
    }

    public VariableValueWithDefinition accumulateVariable(NormalizedInputValue normalizedInputValue) {
        VariableValueWithDefinition variableWithDefinition = ValueToVariableValueCompiler.normalizedInputValueToVariable(normalizedInputValue, this.getAccumulatedSize());
        this.valueWithDefinitions.add(variableWithDefinition);
        return variableWithDefinition;
    }

    public int getAccumulatedSize() {
        return this.valueWithDefinitions.size();
    }

    public List<VariableDefinition> getVariableDefinitions() {
        return this.valueWithDefinitions.stream().map(VariableValueWithDefinition::getDefinition).collect(Collectors.toList());
    }

    public Map<String, Object> getVariablesMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.valueWithDefinitions.forEach(variableWithDefinition -> {
            String name = variableWithDefinition.getDefinition().getName();
            map.put(name, variableWithDefinition.getValue());
        });
        return map;
    }
}

