/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized.nf;

import graphql.Assert;
import graphql.ExperimentalApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.InlineFragment;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.normalized.nf.NormalizedField;
import graphql.normalized.nf.NormalizedOperation;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ExperimentalApi
public class NormalizedOperationToAstCompiler {
    public static CompilerResult compileToDocument(GraphQLSchema graphQLSchema, GraphQLObjectType rootType, List<NormalizedField> rootFields, @Nullable String operationName, OperationDefinition.Operation operationKind) {
        return NormalizedOperationToAstCompiler.compileToDocumentImpl(graphQLSchema, rootType, rootFields, operationName, operationKind);
    }

    public static CompilerResult compileToDocument(GraphQLSchema graphQLSchema, GraphQLObjectType rootType, NormalizedField singleRootField, @Nullable String operationName, OperationDefinition.Operation operationKind) {
        return NormalizedOperationToAstCompiler.compileToDocumentImpl(graphQLSchema, rootType, ImmutableList.of(singleRootField), operationName, operationKind);
    }

    public static CompilerResult compileToDocument(GraphQLSchema schema, NormalizedOperation normalizedOperation) {
        GraphQLObjectType operationType = NormalizedOperationToAstCompiler.getOperationType(schema, normalizedOperation.getOperation());
        return NormalizedOperationToAstCompiler.compileToDocumentImpl(schema, operationType, normalizedOperation.getRootFields(), normalizedOperation.getOperationName(), normalizedOperation.getOperation());
    }

    private static CompilerResult compileToDocumentImpl(GraphQLSchema schema, GraphQLObjectType rootType, List<NormalizedField> rootFields, @Nullable String operationName, OperationDefinition.Operation operationKind) {
        List<Selection<?>> selections = NormalizedOperationToAstCompiler.subSelectionsForNormalizedFields(schema, rootType.getName(), rootFields);
        SelectionSet selectionSet = new SelectionSet(selections);
        OperationDefinition.Builder definitionBuilder = OperationDefinition.newOperationDefinition().name(operationName).operation(operationKind).selectionSet(selectionSet);
        return new CompilerResult(Document.newDocument().definition(definitionBuilder.build()).build(), null);
    }

    private static List<Selection<?>> subSelectionsForNormalizedFields(GraphQLSchema schema, @NonNull String parentOutputType, List<NormalizedField> normalizedFields) {
        ImmutableList.Builder selections = ImmutableList.builder();
        LinkedHashMap<String, List> fieldsByTypeCondition = new LinkedHashMap<String, List>();
        for (NormalizedField nf : normalizedFields) {
            if (nf.isConditional(schema)) {
                NormalizedOperationToAstCompiler.selectionForNormalizedField(schema, nf).forEach((objectTypeName, field) -> fieldsByTypeCondition.computeIfAbsent((String)objectTypeName, ignored -> new ArrayList()).add(field));
                continue;
            }
            selections.add(NormalizedOperationToAstCompiler.selectionForNormalizedField(schema, parentOutputType, nf));
        }
        fieldsByTypeCondition.forEach((objectTypeName, fields) -> {
            TypeName typeName = TypeName.newTypeName(objectTypeName).build();
            InlineFragment inlineFragment = InlineFragment.newInlineFragment().typeCondition(typeName).selectionSet(NormalizedOperationToAstCompiler.selectionSet(fields)).build();
            selections.add(inlineFragment);
        });
        return selections.build();
    }

    private static Map<String, Field> selectionForNormalizedField(GraphQLSchema schema, NormalizedField normalizedField) {
        LinkedHashMap<String, Field> groupedFields = new LinkedHashMap<String, Field>();
        for (String objectTypeName : normalizedField.getObjectTypeNames()) {
            groupedFields.put(objectTypeName, NormalizedOperationToAstCompiler.selectionForNormalizedField(schema, objectTypeName, normalizedField));
        }
        return groupedFields;
    }

    private static Field selectionForNormalizedField(GraphQLSchema schema, String objectTypeName, NormalizedField normalizedField) {
        List<Selection<?>> subSelections;
        if (normalizedField.getChildren().isEmpty()) {
            subSelections = ImmutableKit.emptyList();
        } else {
            GraphQLFieldDefinition fieldDef = NormalizedOperationToAstCompiler.getFieldDefinition(schema, objectTypeName, normalizedField);
            GraphQLUnmodifiedType fieldOutputType = GraphQLTypeUtil.unwrapAll(fieldDef.getType());
            subSelections = NormalizedOperationToAstCompiler.subSelectionsForNormalizedFields(schema, fieldOutputType.getName(), normalizedField.getChildren());
        }
        SelectionSet selectionSet = NormalizedOperationToAstCompiler.selectionSetOrNullIfEmpty(subSelections);
        ImmutableList<Argument> arguments = normalizedField.getAstArguments();
        List<Directive> directives = normalizedField.getAstDirectives();
        Field.Builder builder = ((Field.Builder)Field.newField().name(normalizedField.getFieldName()).alias(normalizedField.getAlias()).selectionSet(selectionSet).directives((List)directives)).arguments(arguments);
        return builder.build();
    }

    private static @Nullable SelectionSet selectionSetOrNullIfEmpty(List<Selection<?>> selections) {
        return selections.isEmpty() ? null : SelectionSet.newSelectionSet().selections(selections).build();
    }

    private static SelectionSet selectionSet(List<Field> fields) {
        return SelectionSet.newSelectionSet().selections(fields).build();
    }

    private static @NonNull GraphQLFieldDefinition getFieldDefinition(GraphQLSchema schema, String parentType, NormalizedField nf) {
        return Introspection.getFieldDef(schema, (GraphQLCompositeType)schema.getType(parentType), nf.getName());
    }

    private static GraphQLObjectType getOperationType(@NonNull GraphQLSchema schema, @NonNull OperationDefinition.Operation operationKind) {
        switch (operationKind) {
            case QUERY: {
                return schema.getQueryType();
            }
            case MUTATION: {
                return schema.getMutationType();
            }
            case SUBSCRIPTION: {
                return schema.getSubscriptionType();
            }
        }
        return (GraphQLObjectType)Assert.assertShouldNeverHappen("Unknown operation kind " + String.valueOf((Object)operationKind), new Object[0]);
    }

    public static class CompilerResult {
        private final Document document;
        private final Map<String, Object> variables;

        public CompilerResult(Document document, Map<String, Object> variables) {
            this.document = document;
            this.variables = variables;
        }

        public Document getDocument() {
            return this.document;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }
    }
}

