/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigInteger;
import java.util.Locale;
import java.util.UUID;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public class GraphqlIDCoercing
implements Coercing<Object, Object> {
    private String convertImpl(Object input) {
        if (input instanceof String) {
            return (String)input;
        }
        if (input instanceof Integer) {
            return String.valueOf(input);
        }
        if (input instanceof Long) {
            return String.valueOf(input);
        }
        if (input instanceof UUID) {
            return String.valueOf(input);
        }
        if (input instanceof BigInteger) {
            return String.valueOf(input);
        }
        return String.valueOf(input);
    }

    private @NonNull String serializeImpl(Object input, @NonNull Locale locale) {
        String result = String.valueOf(input);
        if (result == null) {
            throw new CoercingSerializeException("Expected type 'ID' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        return result;
    }

    private @NonNull String parseValueImpl(Object input, @NonNull Locale locale) {
        String result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "ID.notId", CoercingUtil.typeName(input)));
        }
        return result;
    }

    private String parseLiteralImpl(Object input, @NonNull Locale locale) {
        if (input instanceof StringValue) {
            return ((StringValue)input).getValue();
        }
        if (input instanceof IntValue) {
            return ((IntValue)input).getValue().toString();
        }
        throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "ID.unexpectedAstType", CoercingUtil.typeName(input)));
    }

    private @NonNull StringValue valueToLiteralImpl(Object input, @NonNull Locale locale) {
        String result = this.convertImpl(input);
        if (result == null) {
            Assert.assertShouldNeverHappen(CoercingUtil.i18nMsg(locale, "ID.notId", CoercingUtil.typeName(input)), new Object[0]);
        }
        return StringValue.newStringValue(result).build();
    }

    @Override
    @Deprecated
    public String serialize(@NonNull Object dataFetcherResult) {
        return this.serializeImpl(dataFetcherResult, Locale.getDefault());
    }

    @Override
    public @Nullable Object serialize(@NonNull Object dataFetcherResult, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) throws CoercingSerializeException {
        return this.serializeImpl(dataFetcherResult, locale);
    }

    @Override
    @Deprecated
    public String parseValue(@NonNull Object input) {
        return this.parseValueImpl(input, Locale.getDefault());
    }

    @Override
    public Object parseValue(@NonNull Object input, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) throws CoercingParseValueException {
        return this.parseValueImpl(input, locale);
    }

    @Override
    @Deprecated
    public String parseLiteral(@NonNull Object input) {
        return this.parseLiteralImpl(input, Locale.getDefault());
    }

    @Override
    public @Nullable Object parseLiteral(@NonNull Value<?> input, @NonNull CoercedVariables variables, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) throws CoercingParseLiteralException {
        return this.parseLiteralImpl(input, locale);
    }

    @Override
    @Deprecated
    public Value valueToLiteral(@NonNull Object input) {
        return this.valueToLiteralImpl(input, Locale.getDefault());
    }

    @Override
    public @NonNull Value<?> valueToLiteral(@NonNull Object input, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) {
        return this.valueToLiteralImpl(input, locale);
    }
}

