/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.normalized.ExecutableNormalizedField;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.SelectedField;
import graphql.util.FpKit;
import graphql.util.LockKit;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public class DataFetchingFieldSelectionSetImpl
implements DataFetchingFieldSelectionSet {
    private static final String SEP = "/";
    private static final boolean UNIXY = "/".equals(File.separator);
    private static final DataFetchingFieldSelectionSet NOOP = new DataFetchingFieldSelectionSet(){

        @Override
        public boolean contains(String fieldGlobPattern) {
            return false;
        }

        @Override
        public boolean containsAnyOf(String fieldGlobPattern, String ... fieldGlobPatterns) {
            return false;
        }

        @Override
        public boolean containsAllOf(String fieldGlobPattern, String ... fieldGlobPatterns) {
            return false;
        }

        @Override
        public List<SelectedField> getFields() {
            return ImmutableKit.emptyList();
        }

        @Override
        public List<SelectedField> getImmediateFields() {
            return ImmutableKit.emptyList();
        }

        @Override
        public List<SelectedField> getFields(String fieldGlobPattern, String ... fieldGlobPatterns) {
            return ImmutableKit.emptyList();
        }

        @Override
        public Map<String, List<SelectedField>> getFieldsGroupedByResultKey() {
            return ImmutableKit.emptyMap();
        }

        @Override
        public Map<String, List<SelectedField>> getFieldsGroupedByResultKey(String fieldGlobPattern, String ... fieldGlobPatterns) {
            return ImmutableKit.emptyMap();
        }
    };
    private final Supplier<ExecutableNormalizedField> normalizedFieldSupplier;
    private final LockKit.ReentrantLock lock = new LockKit.ReentrantLock();
    private volatile boolean computedValues;
    private volatile boolean computedImmediateValues;
    private Map<String, List<SelectedField>> normalisedSelectionSetFields;
    private List<SelectedField> immediateFields;
    private Set<String> flattenedFieldsForGlobSearching;
    private final GraphQLSchema schema;

    public static DataFetchingFieldSelectionSet newCollector(GraphQLSchema schema, GraphQLOutputType fieldType, Supplier<ExecutableNormalizedField> normalizedFieldSupplier) {
        if (!GraphQLTypeUtil.isLeaf(fieldType)) {
            return new DataFetchingFieldSelectionSetImpl(normalizedFieldSupplier, schema);
        }
        return NOOP;
    }

    private DataFetchingFieldSelectionSetImpl(Supplier<ExecutableNormalizedField> normalizedFieldSupplier, GraphQLSchema schema) {
        this.schema = schema;
        this.normalizedFieldSupplier = normalizedFieldSupplier;
    }

    @Override
    public boolean contains(String fieldGlobPattern) {
        if (fieldGlobPattern == null || fieldGlobPattern.isEmpty()) {
            return false;
        }
        this.computeValuesLazily(false);
        fieldGlobPattern = this.removeLeadingSlash(fieldGlobPattern);
        PathMatcher globMatcher = DataFetchingFieldSelectionSetImpl.globMatcher(fieldGlobPattern);
        for (String flattenedField : this.flattenedFieldsForGlobSearching) {
            Path path = Paths.get(flattenedField = this.osAppropriate(flattenedField), new String[0]);
            if (!globMatcher.matches(path)) continue;
            return true;
        }
        return false;
    }

    private String osAppropriate(String flattenedField) {
        if (UNIXY) {
            return flattenedField;
        }
        return flattenedField.replace(SEP, "\\");
    }

    @Override
    public boolean containsAnyOf(String fieldGlobPattern, String ... fieldGlobPatterns) {
        Assert.assertNotNull(fieldGlobPattern);
        Assert.assertNotNull(fieldGlobPatterns);
        for (String globPattern : this.mkIterable(fieldGlobPattern, fieldGlobPatterns)) {
            if (!this.contains(globPattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAllOf(String fieldGlobPattern, String ... fieldGlobPatterns) {
        Assert.assertNotNull(fieldGlobPattern);
        Assert.assertNotNull(fieldGlobPatterns);
        for (String globPattern : this.mkIterable(fieldGlobPattern, fieldGlobPatterns)) {
            if (this.contains(globPattern)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<SelectedField> getFields(String fieldGlobPattern, String ... fieldGlobPatterns) {
        if (fieldGlobPattern == null || fieldGlobPattern.isEmpty()) {
            return ImmutableKit.emptyList();
        }
        this.computeValuesLazily(false);
        ArrayList<String> targetNames = new ArrayList<String>();
        for (String flattenedField : this.flattenedFieldsForGlobSearching) {
            for (String globPattern : this.mkIterable(fieldGlobPattern, fieldGlobPatterns)) {
                Path path;
                PathMatcher globMatcher = DataFetchingFieldSelectionSetImpl.globMatcher(globPattern);
                if (!globMatcher.matches(path = Paths.get(flattenedField, new String[0]))) continue;
                targetNames.add(flattenedField);
            }
        }
        return this.toSetSemanticsList(targetNames.stream().flatMap(name -> ((List)this.normalisedSelectionSetFields.getOrDefault(name, ImmutableKit.emptyList())).stream()));
    }

    @Override
    public List<SelectedField> getFields() {
        this.computeValuesLazily(false);
        return this.toSetSemanticsList(this.normalisedSelectionSetFields.values().stream().flatMap(Collection::stream));
    }

    private List<SelectedField> toSetSemanticsList(Stream<SelectedField> stream) {
        return ImmutableList.copyOf(stream.collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public List<SelectedField> getImmediateFields() {
        this.computeValuesLazily(true);
        return this.immediateFields;
    }

    @Override
    public Map<String, List<SelectedField>> getFieldsGroupedByResultKey() {
        return this.getFields().stream().collect(Collectors.groupingBy(SelectedField::getResultKey));
    }

    @Override
    public Map<String, List<SelectedField>> getFieldsGroupedByResultKey(String fieldGlobPattern, String ... fieldGlobPatterns) {
        return this.getFields(fieldGlobPattern, fieldGlobPatterns).stream().collect(Collectors.groupingBy(SelectedField::getResultKey));
    }

    private void computeValuesLazily(boolean immediate) {
        if (this.computedValues) {
            return;
        }
        if (immediate && this.computedImmediateValues) {
            return;
        }
        ExecutableNormalizedField currentNormalisedField = this.normalizedFieldSupplier.get();
        this.lock.runLocked(() -> {
            if (this.computedValues) {
                return;
            }
            if (this.computedImmediateValues && immediate) {
                return;
            }
            this.flattenedFieldsForGlobSearching = new LinkedHashSet<String>();
            this.normalisedSelectionSetFields = new LinkedHashMap<String, List<SelectedField>>();
            ImmutableList.Builder<SelectedField> immediateFieldsBuilder = ImmutableList.builder();
            this.traverseSubSelectedFields(currentNormalisedField, immediateFieldsBuilder, "", "", true, immediate);
            this.immediateFields = immediateFieldsBuilder.build();
            this.computedImmediateValues = true;
            this.computedValues = !immediate;
        });
    }

    private void traverseSubSelectedFields(ExecutableNormalizedField currentNormalisedField, ImmutableList.Builder<SelectedField> immediateFieldsBuilder, String qualifiedFieldPrefix, String simpleFieldPrefix, boolean firstLevel, boolean immediate) {
        List<ExecutableNormalizedField> children = currentNormalisedField.getChildren();
        for (ExecutableNormalizedField normalizedSubSelectedField : children) {
            String typeQualifiedName = DataFetchingFieldSelectionSetImpl.mkTypeQualifiedName(normalizedSubSelectedField);
            String simpleName = normalizedSubSelectedField.getName();
            String globQualifiedName = DataFetchingFieldSelectionSetImpl.mkFieldGlobName(qualifiedFieldPrefix, typeQualifiedName);
            String globSimpleName = DataFetchingFieldSelectionSetImpl.mkFieldGlobName(simpleFieldPrefix, simpleName);
            this.flattenedFieldsForGlobSearching.add(globQualifiedName);
            this.flattenedFieldsForGlobSearching.add(globSimpleName);
            SelectedFieldImpl selectedField = new SelectedFieldImpl(globSimpleName, globQualifiedName, normalizedSubSelectedField, this.schema);
            if (firstLevel) {
                immediateFieldsBuilder.add((Object)selectedField);
            }
            this.normalisedSelectionSetFields.computeIfAbsent(globQualifiedName, FpKit.newList()).add(selectedField);
            this.normalisedSelectionSetFields.computeIfAbsent(globSimpleName, FpKit.newList()).add(selectedField);
            if (!normalizedSubSelectedField.hasChildren() || immediate) continue;
            this.traverseSubSelectedFields(normalizedSubSelectedField, immediateFieldsBuilder, globQualifiedName, globSimpleName, false, false);
        }
    }

    private String removeLeadingSlash(String fieldGlobPattern) {
        if (fieldGlobPattern.startsWith(SEP)) {
            fieldGlobPattern = fieldGlobPattern.substring(1);
        }
        return fieldGlobPattern;
    }

    private static String mkTypeQualifiedName(ExecutableNormalizedField executableNormalizedField) {
        return executableNormalizedField.objectTypeNamesToString() + "." + executableNormalizedField.getName();
    }

    private static String mkFieldGlobName(String fieldPrefix, String fieldName) {
        return (String)(!fieldPrefix.isEmpty() ? fieldPrefix + SEP : "") + fieldName;
    }

    private static PathMatcher globMatcher(String fieldGlobPattern) {
        return FileSystems.getDefault().getPathMatcher("glob:" + fieldGlobPattern);
    }

    private List<String> mkIterable(String fieldGlobPattern, String[] fieldGlobPatterns) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(fieldGlobPattern);
        Collections.addAll(l, fieldGlobPatterns);
        return l;
    }

    public String toString() {
        if (!this.computedValues) {
            return "notComputed";
        }
        return String.join((CharSequence)"\n", this.flattenedFieldsForGlobSearching);
    }

    private static class SelectedFieldImpl
    implements SelectedField {
        private final String qualifiedName;
        private final String fullyQualifiedName;
        private final DataFetchingFieldSelectionSet selectionSet;
        private final ExecutableNormalizedField executableNormalizedField;
        private final GraphQLSchema schema;

        private SelectedFieldImpl(String simpleQualifiedName, String fullyQualifiedName, ExecutableNormalizedField executableNormalizedField, GraphQLSchema schema) {
            this.schema = schema;
            this.qualifiedName = simpleQualifiedName;
            this.fullyQualifiedName = fullyQualifiedName;
            this.executableNormalizedField = executableNormalizedField;
            this.selectionSet = new DataFetchingFieldSelectionSetImpl(() -> executableNormalizedField, schema);
        }

        private SelectedField mkParent(ExecutableNormalizedField executableNormalizedField) {
            String parentSimpleQualifiedName = this.beforeLastSlash(this.qualifiedName);
            String parentFullyQualifiedName = this.beforeLastSlash(this.fullyQualifiedName);
            return executableNormalizedField.getParent() == null ? null : new SelectedFieldImpl(parentSimpleQualifiedName, parentFullyQualifiedName, executableNormalizedField.getParent(), this.schema);
        }

        private String beforeLastSlash(String name) {
            int index = name.lastIndexOf(DataFetchingFieldSelectionSetImpl.SEP);
            if (index > 0) {
                return name.substring(0, index);
            }
            return "";
        }

        @Override
        public String getName() {
            return this.executableNormalizedField.getName();
        }

        @Override
        public String getQualifiedName() {
            return this.qualifiedName;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @Override
        public List<GraphQLFieldDefinition> getFieldDefinitions() {
            return this.executableNormalizedField.getFieldDefinitions(this.schema);
        }

        @Override
        public GraphQLOutputType getType() {
            return this.executableNormalizedField.getType(this.schema);
        }

        @Override
        public List<GraphQLObjectType> getObjectTypes() {
            return this.schema.getTypes(this.executableNormalizedField.getObjectTypeNames());
        }

        @Override
        public List<String> getObjectTypeNames() {
            return ImmutableList.copyOf(this.executableNormalizedField.getObjectTypeNames());
        }

        @Override
        public Map<String, Object> getArguments() {
            return this.executableNormalizedField.getResolvedArguments();
        }

        @Override
        public int getLevel() {
            return this.executableNormalizedField.getLevel();
        }

        @Override
        public boolean isConditional() {
            return this.executableNormalizedField.isConditional(this.schema);
        }

        @Override
        public String getAlias() {
            return this.executableNormalizedField.getAlias();
        }

        @Override
        public String getResultKey() {
            return this.executableNormalizedField.getResultKey();
        }

        @Override
        public SelectedField getParentField() {
            return this.mkParent(this.executableNormalizedField);
        }

        @Override
        public DataFetchingFieldSelectionSet getSelectionSet() {
            return this.selectionSet;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SelectedFieldImpl that = (SelectedFieldImpl)o;
            return this.executableNormalizedField.equals(that.executableNormalizedField);
        }

        public int hashCode() {
            return Objects.hash(this.executableNormalizedField);
        }

        public String toString() {
            return this.getFullyQualifiedName();
        }
    }
}

