/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.validation.AbstractRule;
import graphql.validation.DocumentVisitor;
import graphql.validation.LanguageTraversal;
import graphql.validation.ValidationContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Internal
public class RulesVisitor
implements DocumentVisitor {
    private final ValidationContext validationContext;
    private final List<AbstractRule> allRules;
    private List<AbstractRule> currentRules;
    private final Set<String> visitedFragmentSpreads = new HashSet<String>();
    private final List<AbstractRule> fragmentSpreadVisitRules;
    private final List<AbstractRule> nonFragmentSpreadRules;
    private boolean operationScope = false;
    private int fragmentSpreadVisitDepth = 0;

    public RulesVisitor(ValidationContext validationContext, List<AbstractRule> rules) {
        this.validationContext = validationContext;
        this.allRules = rules;
        this.currentRules = this.allRules;
        this.nonFragmentSpreadRules = this.filterRulesVisitingFragmentSpreads(this.allRules, false);
        this.fragmentSpreadVisitRules = this.filterRulesVisitingFragmentSpreads(this.allRules, true);
    }

    private List<AbstractRule> filterRulesVisitingFragmentSpreads(List<AbstractRule> rules, boolean isVisitFragmentSpreads) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AbstractRule rule : rules) {
            if (rule.isVisitFragmentSpreads() != isVisitFragmentSpreads) continue;
            builder.add(rule);
        }
        return builder.build();
    }

    @Override
    public void enter(Node node, List<Node> ancestors) {
        this.validationContext.getTraversalContext().enter(node, ancestors);
        if (node instanceof Document) {
            this.checkDocument((Document)node);
        } else if (node instanceof Argument) {
            this.checkArgument((Argument)node);
        } else if (node instanceof TypeName) {
            this.checkTypeName((TypeName)node);
        } else if (node instanceof VariableDefinition) {
            this.checkVariableDefinition((VariableDefinition)node);
        } else if (node instanceof Field) {
            this.checkField((Field)node);
        } else if (node instanceof InlineFragment) {
            this.checkInlineFragment((InlineFragment)node);
        } else if (node instanceof Directive) {
            this.checkDirective((Directive)node, ancestors);
        } else if (node instanceof FragmentSpread) {
            this.checkFragmentSpread((FragmentSpread)node, ancestors);
        } else if (node instanceof FragmentDefinition) {
            this.checkFragmentDefinition((FragmentDefinition)node);
        } else if (node instanceof OperationDefinition) {
            this.checkOperationDefinition((OperationDefinition)node);
        } else if (node instanceof VariableReference) {
            this.checkVariable((VariableReference)node);
        } else if (node instanceof SelectionSet) {
            this.checkSelectionSet((SelectionSet)node);
        } else if (node instanceof ObjectValue) {
            this.checkObjectValue((ObjectValue)node);
        }
    }

    private void checkDocument(Document node) {
        this.currentRules.forEach(r -> r.checkDocument(node));
    }

    private void checkArgument(Argument node) {
        this.currentRules.forEach(r -> r.checkArgument(node));
    }

    private void checkTypeName(TypeName node) {
        this.currentRules.forEach(r -> r.checkTypeName(node));
    }

    private void checkVariableDefinition(VariableDefinition node) {
        this.currentRules.forEach(r -> r.checkVariableDefinition(node));
    }

    private void checkField(Field node) {
        this.currentRules.forEach(r -> r.checkField(node));
    }

    private void checkInlineFragment(InlineFragment node) {
        this.currentRules.forEach(r -> r.checkInlineFragment(node));
    }

    private void checkDirective(Directive node, List<Node> ancestors) {
        this.currentRules.forEach(r -> r.checkDirective(node, ancestors));
    }

    private void checkFragmentSpread(FragmentSpread node, List<Node> ancestors) {
        FragmentDefinition fragment;
        this.currentRules.forEach(r -> r.checkFragmentSpread(node));
        if (this.operationScope && (fragment = this.validationContext.getFragment(node.getName())) != null && !this.visitedFragmentSpreads.contains(node.getName())) {
            this.visitedFragmentSpreads.add(node.getName());
            List<AbstractRule> prevRules = this.currentRules;
            this.currentRules = this.fragmentSpreadVisitRules;
            ++this.fragmentSpreadVisitDepth;
            new LanguageTraversal(ancestors).traverse(fragment, this);
            --this.fragmentSpreadVisitDepth;
            this.currentRules = prevRules;
        }
    }

    private void checkFragmentDefinition(FragmentDefinition node) {
        if (this.fragmentSpreadVisitDepth == 0) {
            this.currentRules = this.nonFragmentSpreadRules;
        }
        this.currentRules.forEach(r -> r.checkFragmentDefinition(node));
    }

    private void checkOperationDefinition(OperationDefinition node) {
        this.operationScope = true;
        this.currentRules.forEach(r -> r.checkOperationDefinition(node));
    }

    private void checkSelectionSet(SelectionSet node) {
        this.currentRules.forEach(r -> r.checkSelectionSet(node));
    }

    private void checkVariable(VariableReference node) {
        this.currentRules.forEach(r -> r.checkVariable(node));
    }

    private void checkObjectValue(ObjectValue node) {
        this.currentRules.forEach(r -> r.checkObjectValue(node));
    }

    @Override
    public void leave(Node node, List<Node> ancestors) {
        this.validationContext.getTraversalContext().leave(node, ancestors);
        if (node instanceof Document) {
            this.documentFinished((Document)node);
        } else if (node instanceof OperationDefinition) {
            this.leaveOperationDefinition((OperationDefinition)node);
        } else if (node instanceof SelectionSet) {
            this.leaveSelectionSet((SelectionSet)node);
        } else if (node instanceof FragmentDefinition) {
            this.leaveFragmentDefinition((FragmentDefinition)node);
        }
    }

    private void leaveSelectionSet(SelectionSet node) {
        this.currentRules.forEach(r -> r.leaveSelectionSet(node));
    }

    private void leaveOperationDefinition(OperationDefinition node) {
        this.visitedFragmentSpreads.clear();
        this.operationScope = false;
        this.currentRules.forEach(r -> r.leaveOperationDefinition(node));
    }

    private void documentFinished(Document node) {
        this.currentRules.forEach(r -> r.documentFinished(node));
    }

    private void leaveFragmentDefinition(FragmentDefinition node) {
        if (this.fragmentSpreadVisitDepth == 0) {
            this.currentRules = this.allRules;
        }
    }
}

