/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.NullValue;
import graphql.language.Value;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;

@Internal
public class VariablesTypesMatcher {
    public boolean doesVariableTypesMatch(GraphQLType varType, Value<?> varDefaultValue, GraphQLType locationType, Value<?> locationDefaultValue) {
        if (GraphQLTypeUtil.isNonNull(locationType) && !GraphQLTypeUtil.isNonNull(varType)) {
            boolean hasLocationDefaultValue;
            boolean hasNonNullVariableDefaultValue = varDefaultValue != null && !(varDefaultValue instanceof NullValue);
            boolean bl = hasLocationDefaultValue = locationDefaultValue != null;
            if (!hasNonNullVariableDefaultValue && !hasLocationDefaultValue) {
                return false;
            }
            GraphQLType nullableLocationType = GraphQLTypeUtil.unwrapNonNull(locationType);
            return this.checkType(varType, nullableLocationType);
        }
        return this.checkType(varType, locationType);
    }

    public GraphQLType effectiveType(GraphQLType variableType, Value<?> defaultValue) {
        if (defaultValue == null || defaultValue instanceof NullValue) {
            return variableType;
        }
        if (GraphQLTypeUtil.isNonNull(variableType)) {
            return variableType;
        }
        return GraphQLNonNull.nonNull(variableType);
    }

    private boolean checkType(GraphQLType actualType, GraphQLType expectedType) {
        if (GraphQLTypeUtil.isNonNull(expectedType)) {
            if (GraphQLTypeUtil.isNonNull(actualType)) {
                return this.checkType(GraphQLTypeUtil.unwrapOne(actualType), GraphQLTypeUtil.unwrapOne(expectedType));
            }
            return false;
        }
        if (GraphQLTypeUtil.isNonNull(actualType)) {
            return this.checkType(GraphQLTypeUtil.unwrapOne(actualType), expectedType);
        }
        if (GraphQLTypeUtil.isList(actualType) && GraphQLTypeUtil.isList(expectedType)) {
            return this.checkType(GraphQLTypeUtil.unwrapOne(actualType), GraphQLTypeUtil.unwrapOne(expectedType));
        }
        return actualType == expectedType;
    }
}

