/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.module;

import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.storage.DeleteCookiesParameters;
import org.openqa.selenium.bidi.storage.GetCookiesParameters;
import org.openqa.selenium.bidi.storage.GetCookiesResult;
import org.openqa.selenium.bidi.storage.PartitionKey;
import org.openqa.selenium.bidi.storage.SetCookieParameters;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;

public class Storage {
    private static final Json JSON = new Json();
    private final BiDi bidi;
    private final Function<JsonInput, GetCookiesResult> getCookiesResultMapper = jsonInput -> (GetCookiesResult)jsonInput.read((Type)((Object)GetCookiesResult.class));
    private final Function<JsonInput, PartitionKey> partitionKeyResultMapper = jsonInput -> {
        Map response = (Map)jsonInput.read((Type)((Object)Map.class));
        try (StringReader reader = new StringReader(JSON.toJson(response.get("partitionKey")));){
            JsonInput input = JSON.newInput(reader);
            try {
                PartitionKey partitionKey = (PartitionKey)input.read((Type)((Object)PartitionKey.class));
                if (input != null) {
                    input.close();
                }
                return partitionKey;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    };

    public Storage(WebDriver driver) {
        Require.nonNull("WebDriver", driver);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)((Object)driver)).getBiDi();
    }

    public GetCookiesResult getCookies(GetCookiesParameters params) {
        return this.bidi.send(new Command<GetCookiesResult>("storage.getCookies", params.toMap(), this.getCookiesResultMapper));
    }

    public PartitionKey setCookie(SetCookieParameters params) {
        return this.bidi.send(new Command<PartitionKey>("storage.setCookie", params.toMap(), this.partitionKeyResultMapper));
    }

    public PartitionKey deleteCookies(DeleteCookiesParameters params) {
        return this.bidi.send(new Command<PartitionKey>("storage.deleteCookies", params.toMap(), this.partitionKeyResultMapper));
    }
}

