/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.proto;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zeromq.ZFrame;
import zmq.util.Utils;
import zmq.util.Wire;
import zmq.util.function.BiFunction;

public final class ZNeedle {
    private final ByteBuffer needle;

    public ZNeedle(ZFrame frame) {
        this(frame.getData());
    }

    private ZNeedle(byte[] data) {
        this.needle = ByteBuffer.wrap(data);
    }

    private void checkAvailable(int size) {
        Utils.checkArgument(this.needle.position() + size <= this.needle.limit(), () -> "Unable to handle " + size + " bytes");
    }

    private void forward(int size) {
        this.needle.position(this.needle.position() + size);
    }

    private <T> T get(BiFunction<ByteBuffer, Integer, T> getter, int size) {
        T value = getter.apply(this.needle, this.needle.position());
        this.forward(size);
        return value;
    }

    public void putNumber1(int value) {
        this.checkAvailable(1);
        this.needle.put((byte)(value & 0xFF));
    }

    public int getNumber1() {
        this.checkAvailable(1);
        int value = this.needle.get(this.needle.position()) & 0xFF;
        this.forward(1);
        return value;
    }

    public void putNumber2(int value) {
        this.checkAvailable(2);
        Wire.putUInt16(this.needle, value);
    }

    public int getNumber2() {
        this.checkAvailable(2);
        return this.get(Wire::getUInt16, 2);
    }

    public void putNumber4(int value) {
        this.checkAvailable(4);
        Wire.putUInt32(this.needle, value);
    }

    public int getNumber4() {
        this.checkAvailable(4);
        return this.get(Wire::getUInt32, 4);
    }

    public void putNumber8(long value) {
        this.checkAvailable(8);
        Wire.putUInt64(this.needle, value);
    }

    public long getNumber8() {
        this.checkAvailable(8);
        return this.get(Wire::getUInt64, 8);
    }

    public void putBlock(byte[] value, int size) {
        this.needle.put(value, 0, size);
    }

    public byte[] getBlock(int size) {
        this.checkAvailable(size);
        byte[] value = new byte[size];
        this.needle.get(value);
        return value;
    }

    public void putShortString(String value) {
        this.checkAvailable(value.length() + 1);
        Wire.putShortString(this.needle, value);
    }

    public String getShortString() {
        String value = Wire.getShortString(this.needle, this.needle.position());
        this.forward(value.length() + 1);
        return value;
    }

    public void putLongString(String value) {
        this.checkAvailable(value.length() + 4);
        Wire.putLongString(this.needle, value);
    }

    public String getLongString() {
        String value = Wire.getLongString(this.needle, this.needle.position());
        this.forward(value.length() + 4);
        return value;
    }

    public void putString(String value) {
        if (value.length() > 255) {
            this.putLongString(value);
        } else {
            this.putShortString(value);
        }
    }

    public String getString() {
        return this.getShortString();
    }

    public void putList(Collection<String> elements) {
        if (elements == null) {
            this.putNumber1(0);
        } else {
            Utils.checkArgument(elements.size() < 256, "Collection has to be smaller than 256 elements");
            this.putNumber1(elements.size());
            for (String string : elements) {
                this.putString(string);
            }
        }
    }

    public List<String> getList() {
        int size = this.getNumber1();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int idx = 0; idx < size; ++idx) {
            list.add(this.getString());
        }
        return list;
    }

    public void putMap(Map<String, String> map) {
        if (map == null) {
            this.putNumber1(0);
        } else {
            Utils.checkArgument(map.size() < 256, "Map has to be smaller than 256 elements");
            this.putNumber1(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey().contains("=")) {
                    throw new IllegalArgumentException("Keys cannot contain '=' sign. " + entry);
                }
                if (entry.getValue().contains("=")) {
                    throw new IllegalArgumentException("Values cannot contain '=' sign. " + entry);
                }
                String val = entry.getKey() + "=" + entry.getValue();
                this.putString(val);
            }
        }
    }

    public Map<String, String> getMap() {
        int size = this.getNumber1();
        HashMap<String, String> map = new HashMap<String, String>(size);
        for (int idx = 0; idx < size; ++idx) {
            String[] kv = this.getString().split("=");
            assert (kv.length == 2);
            map.put(kv[0], kv[1]);
        }
        return map;
    }

    public String toString() {
        return "ZNeedle [position=" + this.needle.position() + ", ceiling=" + this.needle.limit() + "]";
    }
}

