/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import org.apache.commons.io.FileSystem;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

class FileSystemTest {
    FileSystemTest() {
    }

    @Test
    void testGetBlockSize() {
        Assertions.assertTrue((FileSystem.getCurrent().getBlockSize() >= 0 ? 1 : 0) != 0);
    }

    @Test
    void testGetCurrent() {
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertEquals((Object)FileSystem.WINDOWS, (Object)FileSystem.getCurrent());
        }
        if (SystemUtils.IS_OS_LINUX) {
            Assertions.assertEquals((Object)FileSystem.LINUX, (Object)FileSystem.getCurrent());
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            Assertions.assertEquals((Object)FileSystem.MAC_OSX, (Object)FileSystem.getCurrent());
        }
    }

    @Test
    void testGetIllegalFileNameChars() {
        FileSystem current = FileSystem.getCurrent();
        Assertions.assertNotSame((Object)current.getIllegalFileNameChars(), (Object)current.getIllegalFileNameChars());
    }

    @Test
    void testIsLegalName() {
        for (FileSystem fs : FileSystem.values()) {
            Assertions.assertFalse((boolean)fs.isLegalFileName((CharSequence)""), (String)fs.name());
            Assertions.assertFalse((boolean)fs.isLegalFileName(null), (String)fs.name());
            Assertions.assertFalse((boolean)fs.isLegalFileName((CharSequence)"\u0000"), (String)fs.name());
            Assertions.assertTrue((boolean)fs.isLegalFileName((CharSequence)"0"), (String)fs.name());
            for (String candidate : fs.getReservedFileNames()) {
                Assertions.assertFalse((boolean)fs.isLegalFileName((CharSequence)candidate), (String)candidate);
            }
        }
    }

    @Test
    void testIsReservedFileName() {
        for (FileSystem fs : FileSystem.values()) {
            for (String candidate : fs.getReservedFileNames()) {
                Assertions.assertTrue((boolean)fs.isReservedFileName((CharSequence)candidate));
            }
        }
    }

    @Test
    @EnabledOnOs(value={OS.WINDOWS})
    void testIsReservedFileNameOnWindows() {
        FileSystem fs = FileSystem.WINDOWS;
        for (String candidate : fs.getReservedFileNames()) {
            Assertions.assertTrue((boolean)fs.isReservedFileName((CharSequence)candidate));
            Assertions.assertTrue((boolean)fs.isReservedFileName((CharSequence)(candidate + ".txt")), (String)candidate);
        }
    }

    @Test
    void testReplacementWithNUL() {
        for (FileSystem fs : FileSystem.values()) {
            try {
                fs.toLegalFileName("Test", '\u0000');
            }
            catch (IllegalArgumentException iae) {
                Assertions.assertTrue((boolean)iae.getMessage().startsWith("The replacement character '\\0'"), (String)iae.getMessage());
            }
        }
    }

    @Test
    void testSorted() {
        for (FileSystem fs : FileSystem.values()) {
            char[] chars = fs.getIllegalFileNameChars();
            for (int i = 0; i < chars.length - 1; ++i) {
                Assertions.assertTrue((chars[i] < chars[i + 1] ? 1 : 0) != 0, (String)fs.name());
            }
        }
    }

    @Test
    void testSupportsDriveLetter() {
        Assertions.assertTrue((boolean)FileSystem.WINDOWS.supportsDriveLetter());
        Assertions.assertFalse((boolean)FileSystem.GENERIC.supportsDriveLetter());
        Assertions.assertFalse((boolean)FileSystem.LINUX.supportsDriveLetter());
        Assertions.assertFalse((boolean)FileSystem.MAC_OSX.supportsDriveLetter());
    }

    @Test
    void testToLegalFileNameWindows() {
        char i;
        FileSystem fs = FileSystem.WINDOWS;
        int replacement = 45;
        for (char i2 = '\u0000'; i2 < ' '; i2 = (char)(i2 + '\u0001')) {
            Assertions.assertEquals((char)'-', (char)fs.toLegalFileName(String.valueOf(i2), '-').charAt(0));
        }
        char[] illegal = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*'};
        for (i = '\u0000'; i < illegal.length; i = (char)((char)(i + '\u0001'))) {
            Assertions.assertEquals((char)'-', (char)fs.toLegalFileName(String.valueOf(i), '-').charAt(0));
        }
        for (i = 'a'; i < 'z'; i = (char)(i + '\u0001')) {
            Assertions.assertEquals((char)i, (char)fs.toLegalFileName(String.valueOf(i), '-').charAt(0));
        }
        for (i = 'A'; i < 'Z'; i = (char)(i + '\u0001')) {
            Assertions.assertEquals((char)i, (char)fs.toLegalFileName(String.valueOf(i), '-').charAt(0));
        }
        for (i = '0'; i < '9'; i = (char)(i + '\u0001')) {
            Assertions.assertEquals((char)i, (char)fs.toLegalFileName(String.valueOf(i), '-').charAt(0));
        }
    }
}

