/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.transport;

import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.syntax.IBitStream;
import net.sourceforge.jaad.aac.syntax.PCE;

public final class ADIFHeader {
    private static final long ADIF_ID = 1094994246L;
    private long id;
    private boolean copyrightIDPresent;
    private byte[] copyrightID = new byte[9];
    private boolean originalCopy;
    private boolean home;
    private boolean bitstreamType;
    private int bitrate;
    private int pceCount;
    private int[] adifBufferFullness;
    private PCE[] pces;

    public static boolean isPresent(IBitStream _in) throws AACException {
        return (long)_in.peekBits(32) == 1094994246L;
    }

    private ADIFHeader() {
    }

    public static ADIFHeader readHeader(IBitStream _in) throws AACException {
        ADIFHeader h = new ADIFHeader();
        h.decode(_in);
        return h;
    }

    private void decode(IBitStream _in) throws AACException {
        int i;
        this.id = _in.readBits(32);
        this.copyrightIDPresent = _in.readBool();
        if (this.copyrightIDPresent) {
            for (i = 0; i < 9; ++i) {
                this.copyrightID[i] = (byte)_in.readBits(8);
            }
        }
        this.originalCopy = _in.readBool();
        this.home = _in.readBool();
        this.bitstreamType = _in.readBool();
        this.bitrate = _in.readBits(23);
        this.pceCount = _in.readBits(4) + 1;
        this.pces = new PCE[this.pceCount];
        this.adifBufferFullness = new int[this.pceCount];
        for (i = 0; i < this.pceCount; ++i) {
            this.adifBufferFullness[i] = this.bitstreamType ? -1 : _in.readBits(20);
            this.pces[i] = new PCE();
            this.pces[i].decode(_in);
        }
    }

    public PCE getFirstPCE() {
        return this.pces[0];
    }
}

