package org.openqa.selenium.devtools.v139.security;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * Security
 */
public class Security {

    /**
     * Disables tracking security state changes.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Security.disable", Map.copyOf(params));
    }

    /**
     * Enables tracking security state changes.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Security.enable", Map.copyOf(params));
    }

    /**
     * Enable/disable whether all certificate errors should be ignored.
     */
    public static Command<Void> setIgnoreCertificateErrors(java.lang.Boolean ignore) {
        java.util.Objects.requireNonNull(ignore, "ignore is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("ignore", ignore);
        return new Command<>("Security.setIgnoreCertificateErrors", Map.copyOf(params));
    }

    /**
     * Handles a certificate error that fired a certificateError event.
     */
    @Deprecated()
    public static Command<Void> handleCertificateError(java.lang.Integer eventId, org.openqa.selenium.devtools.v139.security.model.CertificateErrorAction action) {
        java.util.Objects.requireNonNull(eventId, "eventId is required");
        java.util.Objects.requireNonNull(action, "action is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("eventId", eventId);
        params.put("action", action);
        return new Command<>("Security.handleCertificateError", Map.copyOf(params));
    }

    /**
     * Enable/disable overriding certificate errors. If enabled, all certificate error events need to
     * be handled by the DevTools client and should be answered with `handleCertificateError` commands.
     */
    @Deprecated()
    public static Command<Void> setOverrideCertificateErrors(java.lang.Boolean override) {
        java.util.Objects.requireNonNull(override, "override is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("override", override);
        return new Command<>("Security.setOverrideCertificateErrors", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v139.security.model.CertificateError> certificateError() {
        return new Event<>("Security.certificateError", input -> input.read(org.openqa.selenium.devtools.v139.security.model.CertificateError.class));
    }

    public static Event<org.openqa.selenium.devtools.v139.security.model.VisibleSecurityState> visibleSecurityStateChanged() {
        return new Event<>("Security.visibleSecurityStateChanged", ConverterFunctions.map("visibleSecurityState", org.openqa.selenium.devtools.v139.security.model.VisibleSecurityState.class));
    }

    public static Event<org.openqa.selenium.devtools.v139.security.model.SecurityStateChanged> securityStateChanged() {
        return new Event<>("Security.securityStateChanged", input -> input.read(org.openqa.selenium.devtools.v139.security.model.SecurityStateChanged.class));
    }
}
