/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.LazyObjectBinding;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.util.Subscription;

public class FlatMappedBinding<S, T>
extends LazyObjectBinding<T> {
    private final ObservableValue<S> source;
    private final Function<? super S, ? extends ObservableValue<? extends T>> mapper;
    private Subscription indirectSourceSubscription = Subscription.EMPTY;
    private ObservableValue<? extends T> indirectSource;

    public FlatMappedBinding(ObservableValue<S> observableValue, Function<? super S, ? extends ObservableValue<? extends T>> function) {
        this.source = Objects.requireNonNull(observableValue, "source cannot be null");
        this.mapper = Objects.requireNonNull(function, "mapper cannot be null");
    }

    @Override
    protected T computeValue() {
        ObservableValue<T> observableValue;
        S s2 = this.source.getValue();
        ObservableValue<T> observableValue2 = observableValue = s2 == null ? null : this.mapper.apply(s2);
        if (this.isObserved() && this.indirectSource != observableValue) {
            this.indirectSourceSubscription.unsubscribe();
            this.indirectSourceSubscription = observableValue == null ? Subscription.EMPTY : observableValue.subscribe(this::invalidate);
            this.indirectSource = observableValue;
        }
        return observableValue == null ? null : (T)observableValue.getValue();
    }

    @Override
    protected Subscription observeSources() {
        Subscription subscription = this.source.subscribe(this::invalidateAll);
        return () -> {
            subscription.unsubscribe();
            this.unsubscribeIndirectSource();
        };
    }

    private void invalidateAll() {
        this.unsubscribeIndirectSource();
        this.invalidate();
    }

    private void unsubscribeIndirectSource() {
        this.indirectSourceSubscription.unsubscribe();
        this.indirectSourceSubscription = Subscription.EMPTY;
        this.indirectSource = null;
    }
}

