/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.OperationDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.LinkedHashSet;
import java.util.Set;

@Internal
public class UniqueOperationNames
extends AbstractRule {
    private Set<String> operationNames = new LinkedHashSet<String>();

    public UniqueOperationNames(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDefinition) {
        super.checkOperationDefinition(operationDefinition);
        String name = operationDefinition.getName();
        if (name == null) {
            return;
        }
        if (this.operationNames.contains(name)) {
            String message = this.i18n(ValidationErrorType.DuplicateOperationName, "UniqueOperationNames.oneOperation", operationDefinition.getName());
            this.addError(ValidationErrorType.DuplicateOperationName, operationDefinition.getSourceLocation(), message);
        } else {
            this.operationNames.add(name);
        }
    }
}

