/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.io.function.IOConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS})
public class DeleteDirectoryTest
extends AbstractTempDirTest {
    private void testDeleteDirectory(IOConsumer<Path> deleter) throws IOException {
        String contents = "Hello!";
        Path file = this.tempDirPath.resolve("file.txt");
        Charset charset = StandardCharsets.UTF_8;
        PathUtils.writeString(file, "Hello!", charset, new OpenOption[0]);
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(file, new LinkOption[0]);
        Assertions.assertTrue((boolean)permissions.contains((Object)PosixFilePermission.OWNER_WRITE), permissions::toString);
        Path testDir = this.tempDirPath.resolve("dir");
        Files.createDirectory(testDir, new FileAttribute[0]);
        Path symLink = testDir.resolve("symlink.txt");
        Files.createSymbolicLink(symLink, file, new FileAttribute[0]);
        Assertions.assertEquals((Object)"Hello!", (Object)PathUtils.readString(symLink, charset));
        deleter.accept(testDir);
        Assertions.assertFalse((boolean)Files.exists(symLink, new LinkOption[0]), symLink::toString);
        Assertions.assertTrue((boolean)Files.exists(file, new LinkOption[0]), file::toString);
        Assertions.assertEquals(permissions, Files.getPosixFilePermissions(file, new LinkOption[0]), file::toString);
    }

    @Test
    public void testDeleteDirectoryWithFileUtils() throws IOException {
        this.testDeleteDirectory(dir -> FileUtils.deleteDirectory(dir.toFile()));
    }

    @Test
    public void testDeleteDirectoryWithPathUtils() throws IOException {
        this.testDeleteDirectory(PathUtils::deleteDirectory);
    }

    @Test
    public void testDeleteDirectoryWithPathUtilsOverrideReadOnly() throws IOException {
        this.testDeleteDirectory(dir -> PathUtils.deleteDirectory(dir, StandardDeleteOption.OVERRIDE_READ_ONLY));
    }

    @Test
    @DisabledOnOs(value={OS.LINUX})
    public void testDeleteFileCheckParentAccess() throws IOException {
        Path testDir = this.tempDirPath.resolve("dir");
        Files.createDirectory(testDir, new FileAttribute[0]);
        Path file = testDir.resolve("file.txt");
        Charset charset = StandardCharsets.UTF_8;
        PathUtils.writeString(file, "Hello!", charset, new OpenOption[0]);
        PathUtils.setReadOnly(file, true, new LinkOption[0]);
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(testDir, new LinkOption[0]);
        Assertions.assertFalse((boolean)Files.isWritable(testDir), () -> String.format("Parent directory '%s' of '%s' should NOT be Writable, permissions are %s ", testDir, file, permissions));
        Assertions.assertFalse((boolean)Files.isExecutable(testDir), () -> String.format("Parent directory '%s' of '%s' should NOT be Executable, permissions are %s ", testDir, file, permissions));
        Assertions.assertThrows(IOException.class, () -> PathUtils.delete(file));
        PathUtils.delete(file, StandardDeleteOption.OVERRIDE_READ_ONLY);
        Assertions.assertFalse((boolean)Files.exists(file, new LinkOption[0]));
        Assertions.assertEquals(permissions, Files.getPosixFilePermissions(testDir, new LinkOption[0]), testDir::toString);
        Assertions.assertFalse((boolean)Files.isWritable(testDir));
        Assertions.assertFalse((boolean)Files.isExecutable(testDir));
    }
}

