/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.io.test.ThrowOnFlushAndCloseOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOUtilsWriteTest {
    private static final int FILE_SIZE = 4097;
    private final byte[] inData = TestUtils.generateTestData(4097L);

    @Test
    public void testWrite_byteArrayToOutputStream() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write(this.inData, (OutputStream)out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_byteArrayToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write((byte[])null, (OutputStream)out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_byteArrayToOutputStream_nullStream() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(this.inData, (OutputStream)null));
    }

    @Test
    public void testWrite_byteArrayToWriter() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write(this.inData, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_byteArrayToWriter_Encoding() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write(this.inData, (Writer)writer, "UTF8");
        out.off();
        ((Writer)writer).flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, StandardCharsets.UTF_8).getBytes(StandardCharsets.US_ASCII);
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])bytes, (String)"Content differs");
    }

    @Test
    public void testWrite_byteArrayToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write(null, (Writer)writer, "UTF8");
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_byteArrayToWriter_Encoding_nullEncoding() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write(this.inData, (Writer)writer, (String)null);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_byteArrayToWriter_Encoding_nullWriter() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(this.inData, null, "UTF8"));
    }

    @Test
    public void testWrite_byteArrayToWriter_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((byte[])null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_byteArrayToWriter_nullWriter() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(this.inData, (Writer)null));
    }

    @Test
    public void testWrite_charArrayToOutputStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write(str.toCharArray(), (OutputStream)out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_charArrayToOutputStream_Encoding() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write(str.toCharArray(), (OutputStream)out, "UTF16");
        out.off();
        out.flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, StandardCharsets.UTF_16).getBytes(StandardCharsets.US_ASCII);
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])bytes, (String)"Content differs");
    }

    @Test
    public void testWrite_charArrayToOutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write((char[])null, (OutputStream)out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_charArrayToOutputStream_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(str.toCharArray(), (OutputStream)null));
    }

    @Test
    public void testWrite_charArrayToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write((char[])null, (OutputStream)out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_charArrayToOutputStream_nullEncoding() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write(str.toCharArray(), (OutputStream)out, (String)null);
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_charArrayToOutputStream_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(str.toCharArray(), (OutputStream)null));
    }

    @Test
    public void testWrite_charArrayToWriter() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write(str.toCharArray(), (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_charArrayToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((char[])null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_charArrayToWriter_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(str.toCharArray(), (Writer)null));
    }

    @Test
    public void testWrite_charSequenceToOutputStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write((CharSequence)csq, (OutputStream)out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_charSequenceToOutputStream_Encoding() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write((CharSequence)csq, (OutputStream)out, "UTF16");
        out.off();
        out.flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, StandardCharsets.UTF_16).getBytes(StandardCharsets.US_ASCII);
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])bytes, (String)"Content differs");
    }

    @Test
    public void testWrite_charSequenceToOutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write((CharSequence)null, (OutputStream)out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_charSequenceToOutputStream_Encoding_nullStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(csq, (OutputStream)null));
    }

    @Test
    public void testWrite_charSequenceToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write((CharSequence)null, (OutputStream)out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_charSequenceToOutputStream_nullEncoding() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write((CharSequence)csq, (OutputStream)out, (String)null);
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_charSequenceToOutputStream_nullStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(csq, (OutputStream)null));
    }

    @Test
    public void testWrite_charSequenceToWriter() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((CharSequence)csq, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_charSequenceToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((CharSequence)null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_charSequenceToWriter_Encoding_nullStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(csq, (Writer)null));
    }

    @Test
    public void testWrite_stringToOutputStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write(str, (OutputStream)out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_stringToOutputStream_Encoding() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write(str, (OutputStream)out, "UTF16");
        out.off();
        out.flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, StandardCharsets.UTF_16).getBytes(StandardCharsets.US_ASCII);
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])bytes, (String)"Content differs");
    }

    @Test
    public void testWrite_stringToOutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write((String)null, (OutputStream)out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_stringToOutputStream_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(str, (OutputStream)null));
    }

    @Test
    public void testWrite_stringToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write((String)null, (OutputStream)out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_stringToOutputStream_nullEncoding() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        IOUtils.write(str, (OutputStream)out, (String)null);
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_stringToOutputStream_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(str, (OutputStream)null));
    }

    @Test
    public void testWrite_stringToWriter() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write(str, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    public void testWrite_stringToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((String)null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWrite_stringToWriter_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write(str, (Writer)null));
    }

    @Test
    public void testWriteLines_OutputStream() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        IOUtils.writeLines(list, "*", out);
        out.off();
        out.flush();
        String expected = "hello*world**this is**some text*";
        String actual = baout.toString();
        Assertions.assertEquals((Object)"hello*world**this is**some text*", (Object)actual);
    }

    @Test
    public void testWriteLines_OutputStream_Encoding() throws Exception {
        Object[] data = new Object[]{"hello\u8364", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        IOUtils.writeLines(list, "*", (OutputStream)out, StandardCharsets.UTF_8.name());
        out.off();
        out.flush();
        String expected = "hello\u8364*world**this is**some text*";
        String actual = baout.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"hello\u8364*world**this is**some text*", (Object)actual);
    }

    @Test
    public void testWriteLines_OutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        IOUtils.writeLines(null, "*", (OutputStream)out, StandardCharsets.US_ASCII.name());
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWriteLines_OutputStream_Encoding_nullEncoding() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        IOUtils.writeLines(list, "*", (OutputStream)out, (String)null);
        out.off();
        out.flush();
        String expected = "hello*world**this is**some text*";
        String actual = baout.toString();
        Assertions.assertEquals((Object)"hello*world**this is**some text*", (Object)actual);
    }

    @Test
    public void testWriteLines_OutputStream_Encoding_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        IOUtils.writeLines(list, null, (OutputStream)out, StandardCharsets.US_ASCII.name());
        out.off();
        out.flush();
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator();
        String actual = baout.toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_OutputStream_Encoding_nullStream() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.writeLines(list, "*", null, StandardCharsets.US_ASCII.name()));
    }

    @Test
    public void testWriteLines_OutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        IOUtils.writeLines(null, "*", out);
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWriteLines_OutputStream_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, false, true);
        IOUtils.writeLines(list, null, out);
        out.off();
        out.flush();
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator();
        String actual = baout.toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_OutputStream_nullStream() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.writeLines(list, "*", (OutputStream)null));
    }

    @Test
    public void testWriteLines_Writer() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.writeLines(list, "*", writer);
        out.off();
        ((Writer)writer).flush();
        String expected = "hello*world**this is**some text*";
        String actual = baout.toString();
        Assertions.assertEquals((Object)"hello*world**this is**some text*", (Object)actual);
    }

    @Test
    public void testWriteLines_Writer_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.writeLines(null, "*", writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    public void testWriteLines_Writer_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream(baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.writeLines(list, null, writer);
        out.off();
        ((Writer)writer).flush();
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator();
        String actual = baout.toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_Writer_nullStream() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.writeLines(list, "*", (Writer)null));
    }
}

