/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.PathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class PathUtilsContentEqualsTest {
    @TempDir
    public File temporaryFolder;

    private String getName() {
        return this.getClass().getSimpleName();
    }

    @Test
    public void testDirectoryAndFileContentEquals() throws Exception {
        Path path1 = new File(this.temporaryFolder, this.getName()).toPath();
        Path path2 = new File(this.temporaryFolder, this.getName() + "2").toPath();
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(null, null));
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals(null, path1));
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals(path1, null));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(path1, path1));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(path1, path2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(path2, path2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(path2, path1));
        Path dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only1", new String[0]);
        Path dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only2", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir1, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir2, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir1, dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir2, dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir2", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir1, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir2, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir1, dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir2, dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir1, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir2, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir1, dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(dir2, dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/directory-files-only1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/", new String[0]);
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals(dir1, dir2));
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals(dir2, dir1));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files", new String[0]);
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals(dir1, dir2));
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals(dir2, dir1));
    }

    @Test
    public void testDirectoryContentEquals() throws Exception {
        Path path1 = new File(this.temporaryFolder, this.getName()).toPath();
        Path path2 = new File(this.temporaryFolder, this.getName() + "2").toPath();
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(null, null));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals(null, path1));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals(path1, null));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(path1, path1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(path1, path2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(path2, path2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(path2, path1));
        Path dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only1", new String[0]);
        Path dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only2", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir1, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir2, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir1, dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir2, dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir2", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir1, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir2, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir1, dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir2, dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir1, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir2, dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir1, dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(dir2, dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/directory-files-only1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/", new String[0]);
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals(dir1, dir2));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals(dir2, dir1));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files", new String[0]);
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals(dir1, dir2));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals(dir2, dir1));
    }

    @Test
    public void testFileContentEquals() throws Exception {
        Path path1 = new File(this.temporaryFolder, this.getName()).toPath();
        Path path2 = new File(this.temporaryFolder, this.getName() + "2").toPath();
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(null, null));
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals(null, path1));
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals(path1, null));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(path1, path1));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(path1, path2));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(path2, path2));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(path2, path1));
        Assertions.assertThrows(IOException.class, () -> PathUtils.fileContentEquals(this.temporaryFolder.toPath(), this.temporaryFolder.toPath()));
        Path objFile1 = Paths.get(this.temporaryFolder.getAbsolutePath(), this.getName() + ".object");
        PathUtils.copyFile(this.getClass().getResource("/java/lang/Object.class"), objFile1, new CopyOption[0]);
        Path objFile1b = Paths.get(this.temporaryFolder.getAbsolutePath(), this.getName() + ".object2");
        PathUtils.copyFile(this.getClass().getResource("/java/lang/Object.class"), objFile1b, new CopyOption[0]);
        Path objFile2 = Paths.get(this.temporaryFolder.getAbsolutePath(), this.getName() + ".collection");
        PathUtils.copyFile(this.getClass().getResource("/java/util/Collection.class"), objFile2, new CopyOption[0]);
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals(objFile1, objFile2));
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals(objFile1b, objFile2));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(objFile1, objFile1b));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(objFile1, objFile1));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(objFile1b, objFile1b));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(objFile2, objFile2));
        Files.createFile(path1, new FileAttribute[0]);
        Files.createFile(path2, new FileAttribute[0]);
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(path1, path1));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(path1, path2));
    }

    @Test
    public void testFileContentEqualsZip() throws Exception {
        Path path1 = Paths.get("src/test/resources/org/apache/commons/io/bla.zip", new String[0]);
        Path path2 = Paths.get("src/test/resources/org/apache/commons/io/bla-copy.zip", new String[0]);
        Path path3 = Paths.get("src/test/resources/org/apache/commons/io/moby.zip", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(path1, path2));
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals(path1, path3));
    }

    @Test
    public void testFileContentEqualsZipFileSystem() throws Exception {
        try (FileSystem fileSystem = FileSystems.newFileSystem(Paths.get("src/test/resources/org/apache/commons/io/test-same-size-diff-contents.zip", new String[0]), ClassLoader.getSystemClassLoader());){
            Path path1 = fileSystem.getPath("/test-same-size-diff-contents/A.txt", new String[0]);
            Path path2 = fileSystem.getPath("/test-same-size-diff-contents/B.txt", new String[0]);
            Assertions.assertTrue((boolean)Files.exists(path1, new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(path2, new LinkOption[0]));
            Assertions.assertTrue((boolean)PathUtils.fileContentEquals(path1, path1));
            Assertions.assertTrue((boolean)PathUtils.fileContentEquals(path2, path2));
            Assertions.assertFalse((boolean)PathUtils.fileContentEquals(path1, path2));
        }
    }
}

