/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.function.IOLongSupplier;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.io.function.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IOLongSupplierTest {
    private AtomicLong atomicLong;

    private long getThrowsIO(IOLongSupplier supplier) throws IOException {
        return supplier.getAsLong();
    }

    private long getThrowsNone(IOLongSupplier supplier) {
        return supplier.asSupplier().getAsLong();
    }

    @BeforeEach
    public void initEach() {
        this.atomicLong = new AtomicLong();
    }

    @Test
    public void testAsSupplier() {
        Assertions.assertThrows(UncheckedIOException.class, () -> TestConstants.THROWING_IO_LONG_SUPPLIER.asSupplier().getAsLong());
        Assertions.assertEquals((long)1L, (long)this.getThrowsNone(() -> TestUtils.compareAndSetThrowsIO(this.atomicLong, 1L)));
        Assertions.assertEquals((long)1L, (long)this.atomicLong.get());
        Assertions.assertNotEquals((Object)TestConstants.THROWING_IO_LONG_SUPPLIER.asSupplier(), (Object)TestConstants.THROWING_IO_LONG_SUPPLIER.asSupplier());
    }

    @Test
    public void testGet() throws IOException {
        Assertions.assertThrows(IOException.class, () -> TestConstants.THROWING_IO_LONG_SUPPLIER.getAsLong());
        Assertions.assertThrows(IOException.class, () -> {
            throw new IOException();
        });
        Assertions.assertEquals((long)1L, (long)this.getThrowsIO(() -> TestUtils.compareAndSetThrowsIO(this.atomicLong, 1L)));
        Assertions.assertEquals((long)1L, (long)this.atomicLong.get());
    }
}

