/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.io.input.ProxyReader;
import org.junit.jupiter.api.Test;

public class ProxyReaderTest {
    @Test
    public void testNullCharArray() throws Exception {
        try (ProxyReaderImpl proxy = new ProxyReaderImpl(new CustomNullReader(0));){
            proxy.read((char[])null);
            proxy.read(null, 0, 0);
        }
    }

    @Test
    public void testNullCharBuffer() throws Exception {
        try (ProxyReaderImpl proxy = new ProxyReaderImpl(new CustomNullReader(0));){
            proxy.read((CharBuffer)null);
        }
    }

    private static final class ProxyReaderImpl
    extends ProxyReader {
        ProxyReaderImpl(Reader proxy) {
            super(proxy);
        }
    }

    private static final class CustomNullReader
    extends NullReader {
        CustomNullReader(int len) {
            super(len);
        }

        @Override
        public int read(char[] chars) throws IOException {
            return chars == null ? 0 : super.read(chars);
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            return target == null ? 0 : super.read(target);
        }
    }
}

