/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.input.BrokenReader;
import org.apache.commons.io.input.ClosedReader;
import org.apache.commons.io.input.TaggedReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TaggedReaderTest {
    @Test
    public void testBrokenReader() {
        IOException exception = new IOException("test exception");
        TaggedReader reader = new TaggedReader(new BrokenReader(exception));
        IOException readyException = (IOException)Assertions.assertThrows(IOException.class, reader::ready);
        Assertions.assertTrue((boolean)reader.isCauseOf(readyException));
        IOException rethrownReadyException = (IOException)Assertions.assertThrows(IOException.class, () -> reader.throwIfCauseOf(readyException));
        Assertions.assertEquals((Object)exception, (Object)rethrownReadyException);
        IOException readException = (IOException)Assertions.assertThrows(IOException.class, reader::read);
        Assertions.assertTrue((boolean)reader.isCauseOf(readException));
        IOException rethrownReadException = (IOException)Assertions.assertThrows(IOException.class, () -> reader.throwIfCauseOf(readException));
        Assertions.assertEquals((Object)exception, (Object)rethrownReadException);
        IOException closeException = (IOException)Assertions.assertThrows(IOException.class, reader::close);
        Assertions.assertTrue((boolean)reader.isCauseOf(closeException));
        IOException rethrownCloseException = (IOException)Assertions.assertThrows(IOException.class, () -> reader.throwIfCauseOf(closeException));
        Assertions.assertEquals((Object)exception, (Object)rethrownCloseException);
    }

    @Test
    public void testEmptyReader() throws IOException {
        try (TaggedReader reader = new TaggedReader(ClosedReader.INSTANCE);){
            Assertions.assertFalse((boolean)((Reader)reader).ready());
            Assertions.assertEquals((int)-1, (int)((Reader)reader).read());
            Assertions.assertEquals((int)-1, (int)((Reader)reader).read(new char[1]));
            Assertions.assertEquals((int)-1, (int)((Reader)reader).read(new char[1], 0, 1));
        }
    }

    @Test
    public void testNormalReader() throws IOException {
        try (TaggedReader reader = new TaggedReader(new StringReader("abc"));){
            Assertions.assertTrue((boolean)((Reader)reader).ready());
            Assertions.assertEquals((int)97, (int)((Reader)reader).read());
            char[] buffer = new char[1];
            Assertions.assertEquals((int)1, (int)((Reader)reader).read(buffer));
            Assertions.assertEquals((char)'b', (char)buffer[0]);
            Assertions.assertEquals((int)1, (int)((Reader)reader).read(buffer, 0, 1));
            Assertions.assertEquals((char)'c', (char)buffer[0]);
            Assertions.assertEquals((int)-1, (int)((Reader)reader).read());
        }
    }

    @Test
    public void testOtherException() throws Exception {
        IOException exception = new IOException("test exception");
        try (TaggedReader reader = new TaggedReader(ClosedReader.INSTANCE);){
            Assertions.assertFalse((boolean)reader.isCauseOf(exception));
            Assertions.assertFalse((boolean)reader.isCauseOf(new TaggedIOException(exception, UUID.randomUUID())));
            reader.throwIfCauseOf(exception);
            reader.throwIfCauseOf(new TaggedIOException(exception, UUID.randomUUID()));
        }
    }
}

