/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ProxyInputStreamTest;
import org.apache.commons.io.input.ThrottledInputStream;
import org.apache.commons.io.test.CustomIOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThrottledInputStreamTest
extends ProxyInputStreamTest<ThrottledInputStream> {
    @Override
    protected ThrottledInputStream createFixture() throws IOException {
        return ((ThrottledInputStream.Builder)ThrottledInputStream.builder().setInputStream(this.createOriginInputStream())).get();
    }

    @Test
    public void testAfterReadConsumer() throws Exception {
        AtomicBoolean boolRef = new AtomicBoolean();
        try (ThrottledInputStream bounded = ((ThrottledInputStream.Builder)((ThrottledInputStream.Builder)ThrottledInputStream.builder().setCharSequence("Hi")).setAfterRead(i -> boolRef.set(true))).get();){
            IOUtils.consume(bounded);
        }
        Assertions.assertTrue((boolean)boolRef.get());
        String message = "test exception message";
        try (ThrottledInputStream bounded = ((ThrottledInputStream.Builder)((ThrottledInputStream.Builder)ThrottledInputStream.builder().setCharSequence("Hi")).setAfterRead(i -> {
            throw new CustomIOException("test exception message");
        })).get();){
            Assertions.assertEquals((Object)"test exception message", (Object)((CustomIOException)Assertions.assertThrowsExactly(CustomIOException.class, () -> IOUtils.consume(bounded))).getMessage());
        }
    }

    @Test
    public void testCalSleepTimeMs() {
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis(0L, 10000L, 1000L));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis(Long.MAX_VALUE, 0L, 1000L));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis(Long.MAX_VALUE, -1L, 1000L));
        Assertions.assertEquals((long)1500L, (long)ThrottledInputStream.toSleepMillis(5L, 2L, 1000L));
        Assertions.assertEquals((long)500L, (long)ThrottledInputStream.toSleepMillis(5L, 2L, 2000L));
        Assertions.assertEquals((long)6500L, (long)ThrottledInputStream.toSleepMillis(15L, 2L, 1000L));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis(1L, 2L, 1000L));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis(2L, 2L, 2000L));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis(1L, 2L, 1000L));
    }

    @Test
    public void testCloseHandleIOException() throws IOException {
        ProxyInputStreamTest.testCloseHandleIOException(ThrottledInputStream.builder());
    }

    @Override
    protected void testEos(ThrottledInputStream inputStream) {
        Assertions.assertEquals((long)3L, (long)inputStream.getByteCount());
    }

    @Test
    public void testGet() throws IOException {
        try (ThrottledInputStream inputStream = this.createFixture();){
            inputStream.read();
            Assertions.assertEquals((Object)Duration.ZERO, (Object)inputStream.getTotalSleepDuration());
        }
    }
}

