/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.io.test.ThrowOnCloseOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TeeOutputStreamTest {
    private void assertByteArrayEquals(String msg, byte[] array1, byte[] array2) {
        Assertions.assertEquals((int)array1.length, (int)array2.length, (String)(msg + ": array size mismatch"));
        for (int i = 0; i < array1.length; ++i) {
            Assertions.assertEquals((byte)array1[i], (byte)array2[i], (String)(msg + ": array[ " + i + "] mismatch"));
        }
    }

    @Test
    public void testIOExceptionOnClose() throws IOException {
        ThrowOnCloseOutputStream badOs = new ThrowOnCloseOutputStream();
        ByteArrayOutputStream goodOs = (ByteArrayOutputStream)Mockito.mock(ByteArrayOutputStream.class);
        TeeOutputStream tos = new TeeOutputStream(badOs, goodOs);
        Assertions.assertThrows(IOException.class, tos::close);
        ((ByteArrayOutputStream)Mockito.verify((Object)goodOs)).close();
    }

    @Test
    public void testIOExceptionOnCloseBranch() throws IOException {
        ThrowOnCloseOutputStream badOs = new ThrowOnCloseOutputStream();
        ByteArrayOutputStream goodOs = (ByteArrayOutputStream)Mockito.mock(ByteArrayOutputStream.class);
        TeeOutputStream tos = new TeeOutputStream(goodOs, badOs);
        Assertions.assertThrows(IOException.class, tos::close);
        ((ByteArrayOutputStream)Mockito.verify((Object)goodOs)).close();
    }

    @Test
    public void testTee() throws IOException {
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        ByteArrayOutputStream expected = new ByteArrayOutputStream();
        try (TeeOutputStream tos = new TeeOutputStream(baos1, baos2);){
            int i;
            for (int i2 = 0; i2 < 20; ++i2) {
                tos.write(i2);
                expected.write(i2);
            }
            this.assertByteArrayEquals("TeeOutputStream.write(int)", expected.toByteArray(), baos1.toByteArray());
            this.assertByteArrayEquals("TeeOutputStream.write(int)", expected.toByteArray(), baos2.toByteArray());
            byte[] array = new byte[10];
            for (i = 20; i < 30; ++i) {
                array[i - 20] = (byte)i;
            }
            tos.write(array);
            expected.write(array);
            this.assertByteArrayEquals("TeeOutputStream.write(byte[])", expected.toByteArray(), baos1.toByteArray());
            this.assertByteArrayEquals("TeeOutputStream.write(byte[])", expected.toByteArray(), baos2.toByteArray());
            for (i = 25; i < 35; ++i) {
                array[i - 25] = (byte)i;
            }
            tos.write(array, 5, 5);
            expected.write(array, 5, 5);
            this.assertByteArrayEquals("TeeOutputStream.write(byte[], int, int)", expected.toByteArray(), baos1.toByteArray());
            this.assertByteArrayEquals("TeeOutputStream.write(byte[], int, int)", expected.toByteArray(), baos2.toByteArray());
            expected.flush();
            expected.close();
            tos.flush();
        }
    }
}

