/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import org.apache.commons.io.output.BrokenWriter;
import org.apache.commons.io.output.UncheckedFilterWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class UncheckedFilterWriterTest {
    private IOException exception;
    private UncheckedFilterWriter brokenWriter;
    private UncheckedFilterWriter stringWriter;

    @BeforeEach
    public void setUp() throws IOException {
        this.exception = new IOException("test exception");
        this.brokenWriter = ((UncheckedFilterWriter.Builder)UncheckedFilterWriter.builder().setWriter(new BrokenWriter(this.exception))).get();
        this.stringWriter = ((UncheckedFilterWriter.Builder)UncheckedFilterWriter.builder().setWriter(new StringWriter())).get();
    }

    @Test
    public void testAppendChar() {
        this.stringWriter.append('1');
    }

    @Test
    public void testAppendCharSequence() {
        this.stringWriter.append("01");
    }

    @Test
    public void testAppendCharSequenceIndexed() {
        this.stringWriter.append("01", 0, 1);
    }

    @Test
    public void testAppendCharSequenceIndexedThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.append("01", 0, 1))).getCause());
    }

    @Test
    public void testAppendCharSequenceThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.append("01"))).getCause());
    }

    @Test
    public void testAppendCharThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.append('1'))).getCause());
    }

    @Test
    public void testClose() {
        this.stringWriter.close();
    }

    @Test
    public void testCloseThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.close())).getCause());
    }

    @Test
    public void testEquals() {
        this.stringWriter.equals(null);
    }

    @Test
    @Disabled(value="What should happen here?")
    public void testEqualsThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.equals(null))).getCause());
    }

    @Test
    public void testFlush() {
        this.stringWriter.flush();
    }

    @Test
    public void testFlushThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.flush())).getCause());
    }

    @Test
    public void testHashCode() {
        this.stringWriter.hashCode();
    }

    @Test
    @Disabled(value="What should happen here?")
    public void testHashCodeThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.hashCode())).getCause());
    }

    @Test
    public void testToString() {
        this.stringWriter.toString();
    }

    @Test
    @Disabled(value="What should happen here?")
    public void testToStringThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.toString())).getCause());
    }

    @Test
    public void testWriteCharArray() {
        this.stringWriter.write(new char[1]);
    }

    @Test
    public void testWriteCharArrayIndexed() {
        this.stringWriter.write(new char[1], 0, 1);
    }

    @Test
    public void testWriteCharArrayIndexedThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write(new char[1], 0, 1))).getCause());
    }

    @Test
    public void testWriteCharArrayThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write(new char[1]))).getCause());
    }

    @Test
    public void testWriteInt() {
        this.stringWriter.write(1);
    }

    @Test
    public void testWriteIntThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write(1))).getCause());
    }

    @Test
    public void testWriteString() {
        this.stringWriter.write("01");
    }

    @Test
    public void testWriteStringIndexed() {
        this.stringWriter.write("01", 0, 1);
    }

    @Test
    public void testWriteStringIndexedThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write("01", 0, 1))).getCause());
    }

    @Test
    public void testWriteStringThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write("01"))).getCause());
    }
}

