/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpa;

import org.jcodec.codecs.mpa.MpaConst;
import org.jcodec.common.tools.MathUtil;

public class MpaPqmf {
    private static final double MY_PI = Math.PI;
    private static final float cos1_64 = (float)(1.0 / (2.0 * Math.cos(0.04908738521234052)));
    private static final float cos3_64 = (float)(1.0 / (2.0 * Math.cos(0.14726215563702155)));
    private static final float cos5_64 = (float)(1.0 / (2.0 * Math.cos(0.2454369260617026)));
    private static final float cos7_64 = (float)(1.0 / (2.0 * Math.cos(0.3436116964863836)));
    private static final float cos9_64 = (float)(1.0 / (2.0 * Math.cos(0.44178646691106466)));
    private static final float cos11_64 = (float)(1.0 / (2.0 * Math.cos(0.5399612373357456)));
    private static final float cos13_64 = (float)(1.0 / (2.0 * Math.cos(0.6381360077604268)));
    private static final float cos15_64 = (float)(1.0 / (2.0 * Math.cos(0.7363107781851077)));
    private static final float cos17_64 = (float)(1.0 / (2.0 * Math.cos(0.8344855486097889)));
    private static final float cos19_64 = (float)(1.0 / (2.0 * Math.cos(0.9326603190344698)));
    private static final float cos21_64 = (float)(1.0 / (2.0 * Math.cos(1.030835089459151)));
    private static final float cos23_64 = (float)(1.0 / (2.0 * Math.cos(1.1290098598838318)));
    private static final float cos25_64 = (float)(1.0 / (2.0 * Math.cos(1.227184630308513)));
    private static final float cos27_64 = (float)(1.0 / (2.0 * Math.cos(1.325359400733194)));
    private static final float cos29_64 = (float)(1.0 / (2.0 * Math.cos(1.423534171157875)));
    private static final float cos31_64 = (float)(1.0 / (2.0 * Math.cos(1.521708941582556)));
    private static final float cos1_32 = (float)(1.0 / (2.0 * Math.cos(0.09817477042468103)));
    private static final float cos3_32 = (float)(1.0 / (2.0 * Math.cos(0.2945243112740431)));
    private static final float cos5_32 = (float)(1.0 / (2.0 * Math.cos(0.4908738521234052)));
    private static final float cos7_32 = (float)(1.0 / (2.0 * Math.cos(0.6872233929727672)));
    private static final float cos9_32 = (float)(1.0 / (2.0 * Math.cos(0.8835729338221293)));
    private static final float cos11_32 = (float)(1.0 / (2.0 * Math.cos(1.0799224746714913)));
    private static final float cos13_32 = (float)(1.0 / (2.0 * Math.cos(1.2762720155208536)));
    private static final float cos15_32 = (float)(1.0 / (2.0 * Math.cos(1.4726215563702154)));
    private static final float cos1_16 = (float)(1.0 / (2.0 * Math.cos(0.19634954084936207)));
    private static final float cos3_16 = (float)(1.0 / (2.0 * Math.cos(0.5890486225480862)));
    private static final float cos5_16 = (float)(1.0 / (2.0 * Math.cos(0.9817477042468103)));
    private static final float cos7_16 = (float)(1.0 / (2.0 * Math.cos(1.3744467859455345)));
    private static final float cos1_8 = (float)(1.0 / (2.0 * Math.cos(0.39269908169872414)));
    private static final float cos3_8 = (float)(1.0 / (2.0 * Math.cos(1.1780972450961724)));
    private static final float cos1_4 = (float)(1.0 / (2.0 * Math.cos(0.7853981633974483)));
    private static final float[] bf32 = new float[]{cos1_64, cos3_64, cos5_64, cos7_64, cos9_64, cos11_64, cos13_64, cos15_64, cos17_64, cos19_64, cos21_64, cos23_64, cos25_64, cos27_64, cos29_64, cos31_64};
    private static final float[] bf16 = new float[]{cos1_32, cos3_32, cos5_32, cos7_32, cos9_32, cos11_32, cos13_32, cos15_32};
    private static final float[] bf8 = new float[]{cos1_16, cos3_16, cos5_16, cos7_16};

    static void computeFilter(int sampleOff, float[] samples, short[] out, int outOff, float scalefactor) {
        int dvp = 0;
        for (int i = 0; i < 32; ++i) {
            int b = i << 4;
            float pcm_sample = (samples[(16 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 0] + samples[(15 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 1] + samples[(14 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 2] + samples[(13 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 3] + samples[(12 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 4] + samples[(11 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 5] + samples[(10 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 6] + samples[(9 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 7] + samples[(8 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 8] + samples[(7 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 9] + samples[(6 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 10] + samples[(5 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 11] + samples[(4 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 12] + samples[(3 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 13] + samples[(2 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 14] + samples[(1 + sampleOff & 0xF) + dvp] * MpaConst.dp[b + 15]) * scalefactor;
            out[outOff + i] = (short)MathUtil.clip((int)pcm_sample, Short.MIN_VALUE, Short.MAX_VALUE);
            dvp += 16;
        }
    }

    static void computeButterfly(int pos, float[] s2) {
        int i;
        MpaPqmf.butterfly32(s2);
        MpaPqmf.butterfly16L(s2);
        MpaPqmf.butterfly16H(s2);
        MpaPqmf.butterfly8L(s2, 0);
        MpaPqmf.butterfly8H(s2, 0);
        MpaPqmf.butterfly8L(s2, 16);
        MpaPqmf.butterfly8H(s2, 16);
        for (i = 0; i < 32; i += 8) {
            MpaPqmf.butterfly4L(s2, i);
            MpaPqmf.butterfly4H(s2, i);
        }
        for (i = 0; i < 32; i += 4) {
            MpaPqmf.butterfly2L(s2, i);
            MpaPqmf.butterfly2H(s2, i);
        }
        float k0 = -s2[14] - s2[15] - s2[10] - s2[11];
        float k1 = s2[29] + s2[31] + s2[25];
        float k2 = k1 + s2[17];
        float k3 = k1 + s2[21] + s2[23];
        float k4 = s2[15] + s2[11];
        float k5 = s2[15] + s2[13] + s2[9];
        float k6 = s2[7] + s2[5];
        float k7 = s2[31] + s2[23];
        float k8 = k7 + s2[27];
        float k9 = s2[31] + s2[27] + s2[19];
        float k10 = -s2[26] - s2[27] - s2[30] - s2[31];
        float k11 = -s2[24] - s2[28] - s2[30] - s2[31];
        float k12 = s2[20] + s2[22] + s2[23];
        float k13 = s2[21] + s2[29];
        float s0 = s2[0];
        float s1 = s2[1];
        float s22 = s2[2];
        float s3 = s2[3];
        float s4 = s2[4];
        float s6 = s2[6];
        float s7 = s2[7];
        float s8 = s2[8];
        float s12 = s2[12];
        float s13 = s2[13];
        float s14 = s2[14];
        float s15 = s2[15];
        float s16 = s2[16];
        float s18 = s2[18];
        float s19 = s2[19];
        float s21 = s2[21];
        float s222 = s2[22];
        float s23 = s2[23];
        float s28 = s2[28];
        float s29 = s2[29];
        float s30 = s2[30];
        float s31 = s2[31];
        s2[0] = s1;
        s2[1] = k2;
        s2[2] = k5;
        s2[3] = k3;
        s2[4] = k6;
        s2[5] = k8 + k13;
        s2[6] = k4 + s13;
        s2[7] = k9 + s29;
        s2[8] = s3;
        s2[9] = k9;
        s2[10] = k4;
        s2[11] = k8;
        s2[12] = s7;
        s2[13] = k7;
        s2[14] = s15;
        s2[15] = s31;
        s2[16] = -k2 - s30;
        s2[17] = -k5 - s14;
        s2[18] = -k3 - s222 - s30;
        s2[19] = -k6 - s6;
        s2[20] = k10 - s29 - s21 - s222 - s23;
        s2[21] = k0 - s13;
        s2[22] = k10 - s29 - s18 - s19;
        s2[23] = -s3 - s22;
        s2[24] = k10 - s28 - s18 - s19;
        s2[25] = k0 - s12;
        s2[26] = k10 - s28 - k12;
        s2[27] = -s6 - s7 - s4;
        s2[28] = k11 - k12;
        s2[29] = -s14 - s15 - s12 - s8;
        s2[30] = k11 - s16;
        s2[31] = -s0;
    }

    private static void butterfly16H(float[] s2) {
        for (int i = 0; i < 8; ++i) {
            float tmp0 = s2[16 + i];
            float tmp1 = s2[31 - i];
            s2[16 + i] = tmp0 + tmp1;
            s2[31 - i] = -(tmp0 - tmp1) * bf16[i];
        }
    }

    private static void butterfly16L(float[] s2) {
        for (int i = 0; i < 8; ++i) {
            float tmp0 = s2[i];
            float tmp1 = s2[15 - i];
            s2[i] = tmp0 + tmp1;
            s2[15 - i] = (tmp0 - tmp1) * bf16[i];
        }
    }

    private static void butterfly8H(float[] s2, int o) {
        for (int i = 0; i < 4; ++i) {
            float tmp0 = s2[o + 8 + i];
            float tmp1 = s2[o + 15 - i];
            s2[o + 8 + i] = tmp0 + tmp1;
            s2[o + 15 - i] = -(tmp0 - tmp1) * bf8[i];
        }
    }

    private static void butterfly8L(float[] s2, int o) {
        for (int i = 0; i < 4; ++i) {
            float tmp0 = s2[o + i];
            float tmp1 = s2[o + 7 - i];
            s2[o + i] = tmp0 + tmp1;
            s2[o + 7 - i] = (tmp0 - tmp1) * bf8[i];
        }
    }

    private static void butterfly4H(float[] s2, int o) {
        float tmp0 = s2[o + 4];
        float tmp1 = s2[o + 7];
        s2[o + 4] = tmp0 + tmp1;
        s2[o + 7] = -(tmp0 - tmp1) * cos1_8;
        float tmp2 = s2[o + 5];
        float tmp3 = s2[o + 6];
        s2[o + 5] = tmp2 + tmp3;
        s2[o + 6] = -(tmp2 - tmp3) * cos3_8;
    }

    private static void butterfly4L(float[] s2, int o) {
        float tmp0 = s2[o];
        float tmp1 = s2[o + 3];
        s2[o + 0] = tmp0 + tmp1;
        s2[o + 3] = (tmp0 - tmp1) * cos1_8;
        float tmp2 = s2[o + 1];
        float tmp3 = s2[o + 2];
        s2[o + 1] = tmp2 + tmp3;
        s2[o + 2] = (tmp2 - tmp3) * cos3_8;
    }

    private static void butterfly2H(float[] s2, int o) {
        float tmp0 = s2[o + 2];
        float tmp1 = s2[o + 3];
        s2[o + 2] = tmp0 + tmp1;
        s2[o + 3] = -(tmp0 - tmp1) * cos1_4;
    }

    private static void butterfly2L(float[] s2, int o) {
        float tmp0 = s2[o];
        float tmp1 = s2[o + 1];
        s2[o + 0] = tmp0 + tmp1;
        s2[o + 1] = (tmp0 - tmp1) * cos1_4;
    }

    private static void butterfly32(float[] s2) {
        for (int i = 0; i < 16; ++i) {
            float tmp0 = s2[i];
            float tmp1 = s2[31 - i];
            s2[i] = tmp0 + tmp1;
            s2[31 - i] = (tmp0 - tmp1) * bf32[i];
        }
    }
}

