/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.overlay.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum InspectMode {
    SEARCHFORNODE("searchForNode"),
    SEARCHFORUASHADOWDOM("searchForUAShadowDOM"),
    CAPTUREAREASCREENSHOT("captureAreaScreenshot"),
    SHOWDISTANCES("showDistances"),
    NONE("none");

    private String value;

    private InspectMode(String value) {
        this.value = value;
    }

    public static InspectMode fromString(String s2) {
        return Arrays.stream(InspectMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within InspectMode "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static InspectMode fromJson(JsonInput input) {
        return InspectMode.fromString(input.nextString());
    }
}

