/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.target;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v131.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v131.target.model.AttachedToTarget;
import org.openqa.selenium.devtools.v131.target.model.DetachedFromTarget;
import org.openqa.selenium.devtools.v131.target.model.ReceivedMessageFromTarget;
import org.openqa.selenium.devtools.v131.target.model.RemoteLocation;
import org.openqa.selenium.devtools.v131.target.model.SessionID;
import org.openqa.selenium.devtools.v131.target.model.TargetCrashed;
import org.openqa.selenium.devtools.v131.target.model.TargetFilter;
import org.openqa.selenium.devtools.v131.target.model.TargetID;
import org.openqa.selenium.devtools.v131.target.model.TargetInfo;

public class Target {
    public static Command<Void> activateTarget(TargetID targetId) {
        Objects.requireNonNull(targetId, "targetId is required");
        LinkedHashMap<String, TargetID> params = new LinkedHashMap<String, TargetID>();
        params.put("targetId", targetId);
        return new Command<Void>("Target.activateTarget", Map.copyOf(params));
    }

    public static Command<SessionID> attachToTarget(TargetID targetId, Optional<Boolean> flatten) {
        Objects.requireNonNull(targetId, "targetId is required");
        LinkedHashMap<String, TargetID> params = new LinkedHashMap<String, TargetID>();
        params.put("targetId", targetId);
        flatten.ifPresent(p -> params.put("flatten", (TargetID)p));
        return new Command<SessionID>("Target.attachToTarget", Map.copyOf(params), ConverterFunctions.map("sessionId", SessionID.class));
    }

    @Beta
    public static Command<SessionID> attachToBrowserTarget() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<SessionID>("Target.attachToBrowserTarget", Map.copyOf(params), ConverterFunctions.map("sessionId", SessionID.class));
    }

    public static Command<Boolean> closeTarget(TargetID targetId) {
        Objects.requireNonNull(targetId, "targetId is required");
        LinkedHashMap<String, TargetID> params = new LinkedHashMap<String, TargetID>();
        params.put("targetId", targetId);
        return new Command<Boolean>("Target.closeTarget", Map.copyOf(params), ConverterFunctions.map("success", Boolean.class));
    }

    @Beta
    public static Command<Void> exposeDevToolsProtocol(TargetID targetId, Optional<String> bindingName) {
        Objects.requireNonNull(targetId, "targetId is required");
        LinkedHashMap<String, TargetID> params = new LinkedHashMap<String, TargetID>();
        params.put("targetId", targetId);
        bindingName.ifPresent(p -> params.put("bindingName", (TargetID)p));
        return new Command<Void>("Target.exposeDevToolsProtocol", Map.copyOf(params));
    }

    public static Command<BrowserContextID> createBrowserContext(Optional<Boolean> disposeOnDetach, Optional<String> proxyServer, Optional<String> proxyBypassList, Optional<List<String>> originsWithUniversalNetworkAccess) {
        LinkedHashMap params = new LinkedHashMap();
        disposeOnDetach.ifPresent(p -> params.put("disposeOnDetach", p));
        proxyServer.ifPresent(p -> params.put("proxyServer", p));
        proxyBypassList.ifPresent(p -> params.put("proxyBypassList", p));
        originsWithUniversalNetworkAccess.ifPresent(p -> params.put("originsWithUniversalNetworkAccess", p));
        return new Command<BrowserContextID>("Target.createBrowserContext", Map.copyOf(params), ConverterFunctions.map("browserContextId", BrowserContextID.class));
    }

    public static Command<List<BrowserContextID>> getBrowserContexts() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<List<BrowserContextID>>("Target.getBrowserContexts", Map.copyOf(params), ConverterFunctions.map("browserContextIds", input -> input.readArray((Type)((Object)BrowserContextID.class))));
    }

    public static Command<TargetID> createTarget(String url, Optional<Integer> width, Optional<Integer> height, Optional<BrowserContextID> browserContextId, Optional<Boolean> enableBeginFrameControl, Optional<Boolean> newWindow, Optional<Boolean> background, Optional<Boolean> forTab) {
        Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("url", url);
        width.ifPresent(p -> params.put("width", (String)p));
        height.ifPresent(p -> params.put("height", (String)p));
        browserContextId.ifPresent(p -> params.put("browserContextId", (String)p));
        enableBeginFrameControl.ifPresent(p -> params.put("enableBeginFrameControl", (String)p));
        newWindow.ifPresent(p -> params.put("newWindow", (String)p));
        background.ifPresent(p -> params.put("background", (String)p));
        forTab.ifPresent(p -> params.put("forTab", (String)p));
        return new Command<TargetID>("Target.createTarget", Map.copyOf(params), ConverterFunctions.map("targetId", TargetID.class));
    }

    public static Command<Void> detachFromTarget(Optional<SessionID> sessionId, Optional<TargetID> targetId) {
        LinkedHashMap params = new LinkedHashMap();
        sessionId.ifPresent(p -> params.put("sessionId", p));
        targetId.ifPresent(p -> params.put("targetId", p));
        return new Command<Void>("Target.detachFromTarget", Map.copyOf(params));
    }

    public static Command<Void> disposeBrowserContext(BrowserContextID browserContextId) {
        Objects.requireNonNull(browserContextId, "browserContextId is required");
        LinkedHashMap<String, BrowserContextID> params = new LinkedHashMap<String, BrowserContextID>();
        params.put("browserContextId", browserContextId);
        return new Command<Void>("Target.disposeBrowserContext", Map.copyOf(params));
    }

    @Beta
    public static Command<TargetInfo> getTargetInfo(Optional<TargetID> targetId) {
        LinkedHashMap params = new LinkedHashMap();
        targetId.ifPresent(p -> params.put("targetId", p));
        return new Command<TargetInfo>("Target.getTargetInfo", Map.copyOf(params), ConverterFunctions.map("targetInfo", TargetInfo.class));
    }

    public static Command<List<TargetInfo>> getTargets(Optional<TargetFilter> filter) {
        LinkedHashMap params = new LinkedHashMap();
        filter.ifPresent(p -> params.put("filter", p));
        return new Command<List<TargetInfo>>("Target.getTargets", Map.copyOf(params), ConverterFunctions.map("targetInfos", input -> input.readArray((Type)((Object)TargetInfo.class))));
    }

    @Deprecated
    public static Command<Void> sendMessageToTarget(String message, Optional<SessionID> sessionId, Optional<TargetID> targetId) {
        Objects.requireNonNull(message, "message is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("message", message);
        sessionId.ifPresent(p -> params.put("sessionId", (String)p));
        targetId.ifPresent(p -> params.put("targetId", (String)p));
        return new Command<Void>("Target.sendMessageToTarget", Map.copyOf(params));
    }

    public static Command<Void> setAutoAttach(Boolean autoAttach, Boolean waitForDebuggerOnStart, Optional<Boolean> flatten, Optional<TargetFilter> filter) {
        Objects.requireNonNull(autoAttach, "autoAttach is required");
        Objects.requireNonNull(waitForDebuggerOnStart, "waitForDebuggerOnStart is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("autoAttach", autoAttach);
        params.put("waitForDebuggerOnStart", waitForDebuggerOnStart);
        flatten.ifPresent(p -> params.put("flatten", (Boolean)p));
        filter.ifPresent(p -> params.put("filter", (Boolean)p));
        return new Command<Void>("Target.setAutoAttach", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> autoAttachRelated(TargetID targetId, Boolean waitForDebuggerOnStart, Optional<TargetFilter> filter) {
        Objects.requireNonNull(targetId, "targetId is required");
        Objects.requireNonNull(waitForDebuggerOnStart, "waitForDebuggerOnStart is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("targetId", targetId);
        params.put("waitForDebuggerOnStart", waitForDebuggerOnStart);
        filter.ifPresent(p -> params.put("filter", p));
        return new Command<Void>("Target.autoAttachRelated", Map.copyOf(params));
    }

    public static Command<Void> setDiscoverTargets(Boolean discover, Optional<TargetFilter> filter) {
        Objects.requireNonNull(discover, "discover is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("discover", discover);
        filter.ifPresent(p -> params.put("filter", (Boolean)p));
        return new Command<Void>("Target.setDiscoverTargets", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setRemoteLocations(List<RemoteLocation> locations) {
        Objects.requireNonNull(locations, "locations is required");
        LinkedHashMap<String, List<RemoteLocation>> params = new LinkedHashMap<String, List<RemoteLocation>>();
        params.put("locations", locations);
        return new Command<Void>("Target.setRemoteLocations", Map.copyOf(params));
    }

    public static Event<AttachedToTarget> attachedToTarget() {
        return new Event<AttachedToTarget>("Target.attachedToTarget", input -> (AttachedToTarget)input.read((Type)((Object)AttachedToTarget.class)));
    }

    public static Event<DetachedFromTarget> detachedFromTarget() {
        return new Event<DetachedFromTarget>("Target.detachedFromTarget", input -> (DetachedFromTarget)input.read((Type)((Object)DetachedFromTarget.class)));
    }

    public static Event<ReceivedMessageFromTarget> receivedMessageFromTarget() {
        return new Event<ReceivedMessageFromTarget>("Target.receivedMessageFromTarget", input -> (ReceivedMessageFromTarget)input.read((Type)((Object)ReceivedMessageFromTarget.class)));
    }

    public static Event<TargetInfo> targetCreated() {
        return new Event<TargetInfo>("Target.targetCreated", ConverterFunctions.map("targetInfo", TargetInfo.class));
    }

    public static Event<TargetID> targetDestroyed() {
        return new Event<TargetID>("Target.targetDestroyed", ConverterFunctions.map("targetId", TargetID.class));
    }

    public static Event<TargetCrashed> targetCrashed() {
        return new Event<TargetCrashed>("Target.targetCrashed", input -> (TargetCrashed)input.read((Type)((Object)TargetCrashed.class)));
    }

    public static Event<TargetInfo> targetInfoChanged() {
        return new Event<TargetInfo>("Target.targetInfoChanged", ConverterFunctions.map("targetInfo", TargetInfo.class));
    }
}

