/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.storage.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum SharedStorageAccessType {
    DOCUMENTADDMODULE("documentAddModule"),
    DOCUMENTSELECTURL("documentSelectURL"),
    DOCUMENTRUN("documentRun"),
    DOCUMENTSET("documentSet"),
    DOCUMENTAPPEND("documentAppend"),
    DOCUMENTDELETE("documentDelete"),
    DOCUMENTCLEAR("documentClear"),
    DOCUMENTGET("documentGet"),
    WORKLETSET("workletSet"),
    WORKLETAPPEND("workletAppend"),
    WORKLETDELETE("workletDelete"),
    WORKLETCLEAR("workletClear"),
    WORKLETGET("workletGet"),
    WORKLETKEYS("workletKeys"),
    WORKLETENTRIES("workletEntries"),
    WORKLETLENGTH("workletLength"),
    WORKLETREMAININGBUDGET("workletRemainingBudget"),
    HEADERSET("headerSet"),
    HEADERAPPEND("headerAppend"),
    HEADERDELETE("headerDelete"),
    HEADERCLEAR("headerClear");

    private String value;

    private SharedStorageAccessType(String value) {
        this.value = value;
    }

    public static SharedStorageAccessType fromString(String s2) {
        return Arrays.stream(SharedStorageAccessType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within SharedStorageAccessType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static SharedStorageAccessType fromJson(JsonInput input) {
        return SharedStorageAccessType.fromString(input.nextString());
    }
}

