/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.network.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ErrorReason {
    FAILED("Failed"),
    ABORTED("Aborted"),
    TIMEDOUT("TimedOut"),
    ACCESSDENIED("AccessDenied"),
    CONNECTIONCLOSED("ConnectionClosed"),
    CONNECTIONRESET("ConnectionReset"),
    CONNECTIONREFUSED("ConnectionRefused"),
    CONNECTIONABORTED("ConnectionAborted"),
    CONNECTIONFAILED("ConnectionFailed"),
    NAMENOTRESOLVED("NameNotResolved"),
    INTERNETDISCONNECTED("InternetDisconnected"),
    ADDRESSUNREACHABLE("AddressUnreachable"),
    BLOCKEDBYCLIENT("BlockedByClient"),
    BLOCKEDBYRESPONSE("BlockedByResponse");

    private String value;

    private ErrorReason(String value) {
        this.value = value;
    }

    public static ErrorReason fromString(String s2) {
        return Arrays.stream(ErrorReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within ErrorReason "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ErrorReason fromJson(JsonInput input) {
        return ErrorReason.fromString(input.nextString());
    }
}

