/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.local;

import java.io.UncheckedIOException;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.RetrySessionRequestException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.relay.RelaySessionFactory;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class SessionSlot
implements HttpHandler,
Function<CreateSessionRequest, Either<WebDriverException, ActiveSession>>,
Predicate<Capabilities> {
    private static final Logger LOG = Logger.getLogger(SessionSlot.class.getName());
    private final EventBus bus;
    private final UUID id;
    private final Capabilities stereotype;
    private final SessionFactory factory;
    private final AtomicBoolean reserved = new AtomicBoolean(false);
    private final boolean supportingCdp;
    private final boolean supportingBiDi;
    private final AtomicLong connectionCounter;
    private ActiveSession currentSession;

    public SessionSlot(EventBus bus, Capabilities stereotype, SessionFactory factory) {
        this.bus = Require.nonNull("Event bus", bus);
        this.id = UUID.randomUUID();
        this.stereotype = ImmutableCapabilities.copyOf(Require.nonNull("Stereotype", stereotype));
        this.factory = Require.nonNull("Session factory", factory);
        this.supportingCdp = this.isSlotSupportingCdp(this.stereotype);
        this.supportingBiDi = this.isSlotSupportingBiDi(this.stereotype);
        this.connectionCounter = new AtomicLong();
    }

    public UUID getId() {
        return this.id;
    }

    public Capabilities getStereotype() {
        return this.stereotype;
    }

    public void reserve() {
        if (this.reserved.getAndSet(true)) {
            throw new IllegalStateException("Attempt to reserve a slot that is already reserved");
        }
    }

    public void release() {
        this.reserved.set(false);
    }

    public boolean isAvailable() {
        return !this.reserved.get();
    }

    public ActiveSession getSession() {
        if (this.isAvailable()) {
            throw new NoSuchSessionException("Session is not running");
        }
        return this.currentSession;
    }

    public void stop() {
        if (this.isAvailable()) {
            return;
        }
        SessionId id = this.currentSession.getId();
        try {
            this.currentSession.stop();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to cleanly close session", e);
        }
        this.currentSession = null;
        this.connectionCounter.set(0L);
        this.release();
        this.bus.fire(new SessionClosedEvent(id));
        LOG.info(String.format("Stopping session %s", id));
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        if (this.currentSession == null) {
            throw new NoSuchSessionException("No session currently running: " + req.getUri());
        }
        return this.currentSession.execute(req);
    }

    @Override
    public boolean test(Capabilities capabilities) {
        return this.factory.test(capabilities);
    }

    @Override
    public Either<WebDriverException, ActiveSession> apply(CreateSessionRequest sessionRequest) {
        if (this.currentSession != null) {
            return Either.left(new RetrySessionRequestException("Slot is busy. Try another slot."));
        }
        if (!this.test(sessionRequest.getDesiredCapabilities())) {
            return Either.left(new SessionNotCreatedException("New session request capabilities do not match the stereotype."));
        }
        try {
            Either possibleSession = (Either)this.factory.apply(sessionRequest);
            if (possibleSession.isRight()) {
                ActiveSession session;
                this.currentSession = session = (ActiveSession)possibleSession.right();
                this.connectionCounter.set(0L);
                return Either.right(session);
            }
            return Either.left((WebDriverException)possibleSession.left());
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to create session", e);
            return Either.left(new SessionNotCreatedException(e.getMessage()));
        }
    }

    public boolean isSupportingCdp() {
        return this.supportingCdp;
    }

    public boolean isSupportingBiDi() {
        return this.supportingBiDi;
    }

    private boolean isSlotSupportingCdp(Capabilities stereotype) {
        return StreamSupport.stream(ServiceLoader.load(WebDriverInfo.class).spliterator(), false).filter(webDriverInfo -> webDriverInfo.isSupporting(stereotype)).anyMatch(WebDriverInfo::isSupportingCdp);
    }

    private boolean isSlotSupportingBiDi(Capabilities stereotype) {
        return StreamSupport.stream(ServiceLoader.load(WebDriverInfo.class).spliterator(), false).filter(webDriverInfo -> webDriverInfo.isSupporting(stereotype)).anyMatch(WebDriverInfo::isSupportingBiDi);
    }

    public boolean hasRelayFactory() {
        return this.factory instanceof RelaySessionFactory;
    }

    public boolean isRelayServiceUp() {
        return this.hasRelayFactory() && ((RelaySessionFactory)this.factory).isServiceUp();
    }

    public AtomicLong getConnectionCounter() {
        return this.connectionCounter;
    }
}

