/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.language.SourceLocation;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Internal
public class GraphqlErrorHelper {
    public static Map<String, Object> toSpecification(GraphQLError error) {
        LinkedHashMap<String, Object> errorMap = new LinkedHashMap<String, Object>();
        errorMap.put("message", error.getMessage());
        if (error.getLocations() != null) {
            errorMap.put("locations", GraphqlErrorHelper.locations(error.getLocations()));
        }
        if (error.getPath() != null) {
            errorMap.put("path", error.getPath());
        }
        Map<String, Object> extensions = error.getExtensions();
        ErrorClassification errorClassification = error.getErrorType();
        if (errorClassification != null && !(extensions = extensions != null ? new LinkedHashMap<String, Object>(extensions) : new LinkedHashMap<String, Object>()).containsKey("classification")) {
            extensions.put("classification", errorClassification.toSpecification(error));
        }
        if (extensions != null) {
            errorMap.put("extensions", extensions);
        }
        return errorMap;
    }

    public static Object locations(List<SourceLocation> locations) {
        return ImmutableKit.mapAndDropNulls(locations, GraphqlErrorHelper::location);
    }

    public static Object location(SourceLocation location) {
        if (location == null) {
            return null;
        }
        int line = location.getLine();
        int column = location.getColumn();
        if (line < 1 || column < 1) {
            return null;
        }
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>(2);
        map.put("line", line);
        map.put("column", column);
        return map;
    }

    static List<GraphQLError> fromSpecification(List<Map<String, Object>> specificationMaps) {
        List<GraphQLError> list = FpKit.arrayListSizedTo(specificationMaps);
        for (Map<String, Object> specificationMap : specificationMaps) {
            list.add(GraphqlErrorHelper.fromSpecification(specificationMap));
        }
        return list;
    }

    static GraphQLError fromSpecification(Map<String, Object> specificationMap) {
        GraphQLError.Builder<?> errorBuilder = GraphQLError.newError();
        errorBuilder.message((String)specificationMap.get("message"), new Object[0]);
        GraphqlErrorHelper.extractLocations(errorBuilder, specificationMap);
        GraphqlErrorHelper.extractPath(errorBuilder, specificationMap);
        GraphqlErrorHelper.extractExtensions(errorBuilder, specificationMap);
        return errorBuilder.build();
    }

    private static void extractPath(GraphQLError.Builder<?> errorBuilder, Map<String, Object> rawError) {
        List path = (List)rawError.get("path");
        if (path != null) {
            errorBuilder.path(path);
        }
    }

    private static void extractExtensions(GraphQLError.Builder<?> errorBuilder, Map<String, Object> rawError) {
        Map extensions = (Map)rawError.get("extensions");
        if (extensions != null) {
            errorBuilder.extensions(extensions);
            Object classification = extensions.get("classification");
            if (classification != null) {
                ErrorClassification errorClassification = ErrorClassification.errorClassification((String)classification);
                errorBuilder.errorType(errorClassification);
            }
        }
    }

    private static void extractLocations(GraphQLError.Builder<?> errorBuilder, Map<String, Object> rawError) {
        List locations = (List)rawError.get("locations");
        if (locations != null) {
            ArrayList<SourceLocation> sourceLocations = new ArrayList<SourceLocation>();
            for (Object locationObj : locations) {
                Map location = (Map)locationObj;
                if (location == null) continue;
                Integer line = (Integer)location.get("line");
                Integer column = (Integer)location.get("column");
                if (line == null || column == null) continue;
                sourceLocations.add(new SourceLocation(line, column));
            }
            errorBuilder.locations(sourceLocations);
        }
    }

    public static int hashCode(GraphQLError dis) {
        int result = 1;
        result = 31 * result + Objects.hashCode(dis.getMessage());
        result = 31 * result + Objects.hashCode(dis.getLocations());
        result = 31 * result + Objects.hashCode(dis.getPath());
        result = 31 * result + Objects.hashCode(dis.getErrorType());
        return result;
    }

    public static boolean equals(GraphQLError dis, Object o) {
        if (dis == o) {
            return true;
        }
        if (o == null || dis.getClass() != o.getClass()) {
            return false;
        }
        GraphQLError dat = (GraphQLError)o;
        if (!Objects.equals(dis.getMessage(), dat.getMessage())) {
            return false;
        }
        if (!Objects.equals(dis.getLocations(), dat.getLocations())) {
            return false;
        }
        if (!Objects.equals(dis.getPath(), dat.getPath())) {
            return false;
        }
        return dis.getErrorType() == dat.getErrorType();
    }
}

