/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.reactive;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.reactive.CompletionStageSubscriber;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@Internal
public class CompletionStageMappingPublisher<D, U>
implements Publisher<D> {
    protected final Publisher<U> upstreamPublisher;
    protected final Function<U, CompletionStage<D>> mapper;

    public CompletionStageMappingPublisher(Publisher<U> upstreamPublisher, Function<U, CompletionStage<D>> mapper) {
        this.upstreamPublisher = upstreamPublisher;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(Subscriber<? super D> downstreamSubscriber) {
        Assert.assertNotNullWithNPE(downstreamSubscriber, () -> "Subscriber passed to subscribe must not be null");
        this.upstreamPublisher.subscribe(this.createSubscriber(downstreamSubscriber));
    }

    protected @NonNull Subscriber<? super U> createSubscriber(Subscriber<? super D> downstreamSubscriber) {
        return new CompletionStageSubscriber<U, D>(this.mapper, downstreamSubscriber);
    }

    public Publisher<U> getUpstreamPublisher() {
        return this.upstreamPublisher;
    }
}

