/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.Value;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public class GraphqlFloatCoercing
implements Coercing<Double, Double> {
    private Double convertImpl(Object input) {
        Double doubleInput;
        if (input instanceof Double) {
            doubleInput = (Double)input;
        } else if (CoercingUtil.isNumberIsh(input)) {
            BigDecimal value;
            try {
                value = new BigDecimal(input.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
            doubleInput = value.doubleValue();
        } else {
            return null;
        }
        if (Double.isNaN(doubleInput) || Double.isInfinite(doubleInput)) {
            return null;
        }
        return doubleInput;
    }

    private @NonNull Double serialiseImpl(Object input, @NonNull Locale locale) {
        Double result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException(CoercingUtil.i18nMsg(locale, "Float.notFloat", CoercingUtil.typeName(input)));
        }
        return result;
    }

    private @NonNull Double parseValueImpl(@NonNull Object input, @NonNull Locale locale) {
        if (!(input instanceof Number)) {
            throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "Float.unexpectedRawValueType", CoercingUtil.typeName(input)));
        }
        Double result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "Float.notFloat", CoercingUtil.typeName(input)));
        }
        return result;
    }

    private static double parseLiteralImpl(@NonNull Object input, @NonNull Locale locale) {
        if (input instanceof IntValue) {
            return ((IntValue)input).getValue().doubleValue();
        }
        if (input instanceof FloatValue) {
            return ((FloatValue)input).getValue().doubleValue();
        }
        throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "Float.unexpectedAstType", CoercingUtil.typeName(input)));
    }

    private @NonNull FloatValue valueToLiteralImpl(Object input, @NonNull Locale locale) {
        Double result = this.convertImpl(input);
        if (result == null) {
            Assert.assertShouldNeverHappen(CoercingUtil.i18nMsg(locale, "Float.notFloat", CoercingUtil.typeName(input)), new Object[0]);
        }
        return FloatValue.newFloatValue(BigDecimal.valueOf(result)).build();
    }

    @Override
    @Deprecated
    public Double serialize(@NonNull Object dataFetcherResult) {
        return this.serialiseImpl(dataFetcherResult, Locale.getDefault());
    }

    @Override
    public @Nullable Double serialize(@NonNull Object dataFetcherResult, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) throws CoercingSerializeException {
        return this.serialiseImpl(dataFetcherResult, locale);
    }

    @Override
    @Deprecated
    public @NonNull Double parseValue(@NonNull Object input) {
        return this.parseValueImpl(input, Locale.getDefault());
    }

    @Override
    public Double parseValue(@NonNull Object input, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) throws CoercingParseValueException {
        return this.parseValueImpl(input, locale);
    }

    @Override
    @Deprecated
    public Double parseLiteral(@NonNull Object input) {
        return GraphqlFloatCoercing.parseLiteralImpl(input, Locale.getDefault());
    }

    @Override
    public @Nullable Double parseLiteral(@NonNull Value<?> input, @NonNull CoercedVariables variables, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) throws CoercingParseLiteralException {
        return GraphqlFloatCoercing.parseLiteralImpl(input, locale);
    }

    @Override
    @Deprecated
    public Value valueToLiteral(@NonNull Object input) {
        return this.valueToLiteralImpl(input, Locale.getDefault());
    }

    @Override
    public @NonNull Value<?> valueToLiteral(@NonNull Object input, @NonNull GraphQLContext graphQLContext, @NonNull Locale locale) {
        return this.valueToLiteralImpl(input, locale);
    }
}

