/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.Argument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

@Internal
public class KnownArgumentNames
extends AbstractRule {
    public KnownArgumentNames(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkArgument(Argument argument) {
        GraphQLDirective directiveDef = this.getValidationContext().getDirective();
        if (directiveDef != null) {
            GraphQLArgument directiveArgument = directiveDef.getArgument(argument.getName());
            if (directiveArgument == null) {
                String message = this.i18n(ValidationErrorType.UnknownDirective, "KnownArgumentNames.unknownDirectiveArg", argument.getName());
                this.addError(ValidationErrorType.UnknownDirective, argument.getSourceLocation(), message);
            }
            return;
        }
        GraphQLFieldDefinition fieldDef = this.getValidationContext().getFieldDef();
        if (fieldDef == null) {
            return;
        }
        GraphQLArgument fieldArgument = fieldDef.getArgument(argument.getName());
        if (fieldArgument == null) {
            String message = this.i18n(ValidationErrorType.UnknownArgument, "KnownArgumentNames.unknownFieldArg", argument.getName());
            this.addError(ValidationErrorType.UnknownArgument, argument.getSourceLocation(), message);
        }
    }
}

