/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import com.google.common.collect.ImmutableMap;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class DrainNode
implements HttpHandler {
    private final Distributor distributor;
    private final NodeId nodeId;

    public DrainNode(Distributor distributor, NodeId nodeId) {
        this.distributor = Objects.requireNonNull(distributor);
        this.nodeId = Objects.requireNonNull(nodeId);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        HttpResponse response = new HttpResponse();
        boolean value = this.distributor.drain(this.nodeId);
        if (value) {
            response.setContent(Contents.asJson(ImmutableMap.of("value", value, "message", "Node status was successfully set to draining.")));
        } else {
            response.setContent(Contents.asJson(ImmutableMap.of("value", value, "message", "Unable to drain node. Please check the node exists by using /status. If so, try again.")));
        }
        return response;
    }
}

