/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.httpd;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.sessionqueue.httpd.DefaultNewSessionQueueConfig;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Route;

@AutoService(value={CliCommand.class})
public class NewSessionQueueServer
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger(NewSessionQueueServer.class.getName());
    private static final String LOCAL_NEW_SESSION_QUEUE = "org.openqa.selenium.grid.sessionqueue.local.LocalNewSessionQueue";

    @Override
    public String getName() {
        return "sessionqueue";
    }

    @Override
    public String getDescription() {
        return "Adds this server as the new session queue in a selenium grid.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of(StandardGridRoles.HTTPD_ROLE, StandardGridRoles.SESSION_QUEUE_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "sessionqueue";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultNewSessionQueueConfig();
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        NewSessionQueueOptions queueOptions = new NewSessionQueueOptions(config);
        final NewSessionQueue sessionQueue = queueOptions.getSessionQueue(LOCAL_NEW_SESSION_QUEUE);
        return new TemplateGridServerCommand.Handlers(Route.combine(sessionQueue, Route.get("/status").to(() -> req -> (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.asJson(ImmutableMap.of("value", ImmutableMap.of("ready", true, "message", "New Session Queue is ready."))))), Route.get("/readyz").to(() -> req -> new HttpResponse().setStatus(204))), null){

            @Override
            public void close() {
                if (sessionQueue instanceof Closeable) {
                    try {
                        ((Closeable)((Object)sessionQueue)).close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
        };
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull("Config", config);
        config.get("server", "max-threads").ifPresent(value -> LOG.log(Level.WARNING, () -> "Support for max-threads flag is deprecated. The intent of the flag is to set the thread pool size in the Distributor. Please use newsession-threadpool-size flag instead."));
        Server<?> server = this.asServer(config);
        server.start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium SessionQueue %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }
}

