/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.apache.commons.io.EndianUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndianUtilsTest {
    @Test
    public void testCtor() {
        new EndianUtils();
    }

    @Test
    public void testEOFException() {
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
        Assertions.assertThrows(EOFException.class, () -> EndianUtils.readSwappedDouble(input));
    }

    @Test
    public void testInvalidOffset() throws IOException {
        byte[] bytes = new byte[]{};
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.readSwappedInteger(bytes, 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.readSwappedLong(bytes, 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.readSwappedShort(bytes, 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.readSwappedUnsignedInteger(bytes, 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.readSwappedUnsignedShort(bytes, 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.writeSwappedInteger(bytes, 0, 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.writeSwappedLong(bytes, 0, 0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.writeSwappedShort(bytes, 0, (short)0));
    }

    @Test
    public void testReadSwappedDouble() throws IOException {
        byte[] bytes = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        double d1 = Double.longBitsToDouble(72623859790382856L);
        double d2 = EndianUtils.readSwappedDouble(bytes, 0);
        Assertions.assertEquals((double)d1, (double)d2, (double)0.0);
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((double)d1, (double)EndianUtils.readSwappedDouble(input), (double)0.0);
    }

    @Test
    public void testReadSwappedFloat() throws IOException {
        byte[] bytes = new byte[]{4, 3, 2, 1};
        float f1 = Float.intBitsToFloat(16909060);
        float f2 = EndianUtils.readSwappedFloat(bytes, 0);
        Assertions.assertEquals((double)f1, (double)f2, (double)0.0);
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((double)f1, (double)EndianUtils.readSwappedFloat(input), (double)0.0);
    }

    @Test
    public void testReadSwappedInteger() throws IOException {
        byte[] bytes = new byte[]{4, 3, 2, 1};
        Assertions.assertEquals((int)16909060, (int)EndianUtils.readSwappedInteger(bytes, 0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((int)16909060, (int)EndianUtils.readSwappedInteger(input));
    }

    @Test
    public void testReadSwappedLong() throws IOException {
        byte[] bytes = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        Assertions.assertEquals((long)72623859790382856L, (long)EndianUtils.readSwappedLong(bytes, 0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((long)72623859790382856L, (long)EndianUtils.readSwappedLong(input));
    }

    @Test
    public void testReadSwappedShort() throws IOException {
        byte[] bytes = new byte[]{2, 1};
        Assertions.assertEquals((int)258, (int)EndianUtils.readSwappedShort(bytes, 0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((int)258, (int)EndianUtils.readSwappedShort(input));
    }

    @Test
    public void testReadSwappedUnsignedInteger() throws IOException {
        byte[] bytes = new byte[]{4, 3, 2, 1};
        Assertions.assertEquals((long)16909060L, (long)EndianUtils.readSwappedUnsignedInteger(bytes, 0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((long)16909060L, (long)EndianUtils.readSwappedUnsignedInteger(input));
    }

    @Test
    public void testReadSwappedUnsignedShort() throws IOException {
        byte[] bytes = new byte[]{2, 1};
        Assertions.assertEquals((int)258, (int)EndianUtils.readSwappedUnsignedShort(bytes, 0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((int)258, (int)EndianUtils.readSwappedUnsignedShort(input));
    }

    @Test
    public void testSwapDouble() {
        Assertions.assertEquals((double)0.0, (double)EndianUtils.swapDouble(0.0), (double)0.0);
        double d1 = Double.longBitsToDouble(72623859790382856L);
        double d2 = Double.longBitsToDouble(578437695752307201L);
        Assertions.assertEquals((double)d2, (double)EndianUtils.swapDouble(d1), (double)0.0);
    }

    @Test
    public void testSwapFloat() {
        Assertions.assertEquals((double)0.0, (double)EndianUtils.swapFloat(0.0f), (double)0.0);
        float f1 = Float.intBitsToFloat(16909060);
        float f2 = Float.intBitsToFloat(67305985);
        Assertions.assertEquals((double)f2, (double)EndianUtils.swapFloat(f1), (double)0.0);
    }

    @Test
    public void testSwapInteger() {
        Assertions.assertEquals((int)0, (int)EndianUtils.swapInteger(0));
        Assertions.assertEquals((int)67305985, (int)EndianUtils.swapInteger(16909060));
        Assertions.assertEquals((int)0x1000000, (int)EndianUtils.swapInteger(1));
        Assertions.assertEquals((int)1, (int)EndianUtils.swapInteger(0x1000000));
        Assertions.assertEquals((int)0x11111111, (int)EndianUtils.swapInteger(0x11111111));
        Assertions.assertEquals((int)-1412567280, (int)EndianUtils.swapInteger(284151211));
        Assertions.assertEquals((int)171, (int)EndianUtils.swapInteger(-1426063360));
    }

    @Test
    public void testSwapLong() {
        Assertions.assertEquals((long)0L, (long)EndianUtils.swapLong(0L));
        Assertions.assertEquals((long)578437695752307201L, (long)EndianUtils.swapLong(72623859790382856L));
        Assertions.assertEquals((long)-1L, (long)EndianUtils.swapLong(-1L));
        Assertions.assertEquals((long)171L, (long)EndianUtils.swapLong(-6124895493223874560L));
    }

    @Test
    public void testSwapShort() {
        Assertions.assertEquals((short)0, (short)EndianUtils.swapShort((short)0));
        Assertions.assertEquals((short)513, (short)EndianUtils.swapShort((short)258));
        Assertions.assertEquals((short)-1, (short)EndianUtils.swapShort((short)-1));
        Assertions.assertEquals((short)258, (short)EndianUtils.swapShort((short)513));
    }

    @Test
    public void testSymmetry() {
        Assertions.assertEquals((short)258, (short)EndianUtils.swapShort(EndianUtils.swapShort((short)258)));
        Assertions.assertEquals((int)16909060, (int)EndianUtils.swapInteger(EndianUtils.swapInteger(16909060)));
        Assertions.assertEquals((long)72623859790382856L, (long)EndianUtils.swapLong(EndianUtils.swapLong(72623859790382856L)));
        float f1 = Float.intBitsToFloat(16909060);
        Assertions.assertEquals((double)f1, (double)EndianUtils.swapFloat(EndianUtils.swapFloat(f1)), (double)0.0);
        double d1 = Double.longBitsToDouble(72623859790382856L);
        Assertions.assertEquals((double)d1, (double)EndianUtils.swapDouble(EndianUtils.swapDouble(d1)), (double)0.0);
    }

    @Test
    public void testSymmetryOfLong() {
        double[] tests;
        for (double test : tests = new double[]{34.345, -345.5645, 545.12, 10.043, 7.123456789123}) {
            byte[] buffer = new byte[8];
            long ln1 = Double.doubleToLongBits(test);
            EndianUtils.writeSwappedLong(buffer, 0, ln1);
            long ln2 = EndianUtils.readSwappedLong(buffer, 0);
            Assertions.assertEquals((long)ln1, (long)ln2);
            buffer = new byte[8];
            EndianUtils.writeSwappedDouble(buffer, 0, test);
            double val = EndianUtils.readSwappedDouble(buffer, 0);
            Assertions.assertEquals((double)test, (double)val, (double)0.0);
        }
    }

    @Test
    public void testUnsignedOverrun() throws Exception {
        byte[] target = new byte[]{0, 0, 0, -128};
        long expected = 0x80000000L;
        long actual = EndianUtils.readSwappedUnsignedInteger(target, 0);
        Assertions.assertEquals((long)0x80000000L, (long)actual, (String)"readSwappedUnsignedInteger(byte[], int) was incorrect");
        ByteArrayInputStream in = new ByteArrayInputStream(target);
        actual = EndianUtils.readSwappedUnsignedInteger(in);
        Assertions.assertEquals((long)0x80000000L, (long)actual, (String)"readSwappedUnsignedInteger(InputStream) was incorrect");
    }

    @Test
    public void testWriteSwappedDouble() throws IOException {
        byte[] bytes = new byte[8];
        double d1 = Double.longBitsToDouble(72623859790382856L);
        EndianUtils.writeSwappedDouble(bytes, 0, d1);
        Assertions.assertEquals((int)8, (int)bytes[0]);
        Assertions.assertEquals((int)7, (int)bytes[1]);
        Assertions.assertEquals((int)6, (int)bytes[2]);
        Assertions.assertEquals((int)5, (int)bytes[3]);
        Assertions.assertEquals((int)4, (int)bytes[4]);
        Assertions.assertEquals((int)3, (int)bytes[5]);
        Assertions.assertEquals((int)2, (int)bytes[6]);
        Assertions.assertEquals((int)1, (int)bytes[7]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
        EndianUtils.writeSwappedDouble(baos, d1);
        bytes = baos.toByteArray();
        Assertions.assertEquals((int)8, (int)bytes[0]);
        Assertions.assertEquals((int)7, (int)bytes[1]);
        Assertions.assertEquals((int)6, (int)bytes[2]);
        Assertions.assertEquals((int)5, (int)bytes[3]);
        Assertions.assertEquals((int)4, (int)bytes[4]);
        Assertions.assertEquals((int)3, (int)bytes[5]);
        Assertions.assertEquals((int)2, (int)bytes[6]);
        Assertions.assertEquals((int)1, (int)bytes[7]);
    }

    @Test
    public void testWriteSwappedFloat() throws IOException {
        byte[] bytes = new byte[4];
        float f1 = Float.intBitsToFloat(16909060);
        EndianUtils.writeSwappedFloat(bytes, 0, f1);
        Assertions.assertEquals((int)4, (int)bytes[0]);
        Assertions.assertEquals((int)3, (int)bytes[1]);
        Assertions.assertEquals((int)2, (int)bytes[2]);
        Assertions.assertEquals((int)1, (int)bytes[3]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        EndianUtils.writeSwappedFloat(baos, f1);
        bytes = baos.toByteArray();
        Assertions.assertEquals((int)4, (int)bytes[0]);
        Assertions.assertEquals((int)3, (int)bytes[1]);
        Assertions.assertEquals((int)2, (int)bytes[2]);
        Assertions.assertEquals((int)1, (int)bytes[3]);
    }

    @Test
    public void testWriteSwappedInteger() throws IOException {
        byte[] bytes = new byte[4];
        EndianUtils.writeSwappedInteger(bytes, 0, 16909060);
        Assertions.assertEquals((int)4, (int)bytes[0]);
        Assertions.assertEquals((int)3, (int)bytes[1]);
        Assertions.assertEquals((int)2, (int)bytes[2]);
        Assertions.assertEquals((int)1, (int)bytes[3]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        EndianUtils.writeSwappedInteger(baos, 16909060);
        bytes = baos.toByteArray();
        Assertions.assertEquals((int)4, (int)bytes[0]);
        Assertions.assertEquals((int)3, (int)bytes[1]);
        Assertions.assertEquals((int)2, (int)bytes[2]);
        Assertions.assertEquals((int)1, (int)bytes[3]);
    }

    @Test
    public void testWriteSwappedLong() throws IOException {
        byte[] bytes = new byte[8];
        EndianUtils.writeSwappedLong(bytes, 0, 72623859790382856L);
        Assertions.assertEquals((int)8, (int)bytes[0]);
        Assertions.assertEquals((int)7, (int)bytes[1]);
        Assertions.assertEquals((int)6, (int)bytes[2]);
        Assertions.assertEquals((int)5, (int)bytes[3]);
        Assertions.assertEquals((int)4, (int)bytes[4]);
        Assertions.assertEquals((int)3, (int)bytes[5]);
        Assertions.assertEquals((int)2, (int)bytes[6]);
        Assertions.assertEquals((int)1, (int)bytes[7]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
        EndianUtils.writeSwappedLong(baos, 72623859790382856L);
        bytes = baos.toByteArray();
        Assertions.assertEquals((int)8, (int)bytes[0]);
        Assertions.assertEquals((int)7, (int)bytes[1]);
        Assertions.assertEquals((int)6, (int)bytes[2]);
        Assertions.assertEquals((int)5, (int)bytes[3]);
        Assertions.assertEquals((int)4, (int)bytes[4]);
        Assertions.assertEquals((int)3, (int)bytes[5]);
        Assertions.assertEquals((int)2, (int)bytes[6]);
        Assertions.assertEquals((int)1, (int)bytes[7]);
    }

    @Test
    public void testWriteSwappedShort() throws IOException {
        byte[] bytes = new byte[2];
        EndianUtils.writeSwappedShort(bytes, 0, (short)258);
        Assertions.assertEquals((int)2, (int)bytes[0]);
        Assertions.assertEquals((int)1, (int)bytes[1]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
        EndianUtils.writeSwappedShort(baos, (short)258);
        bytes = baos.toByteArray();
        Assertions.assertEquals((int)2, (int)bytes[0]);
        Assertions.assertEquals((int)1, (int)bytes[1]);
    }
}

