/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TempDirectory;
import org.apache.commons.io.file.TempFile;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class FileUtilsTest
extends AbstractTempDirTest {
    private static final Path DIR_SIZE_1 = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]);
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final long DATE3 = 1000000002000L;
    private static final long DATE2 = 1000000001000L;
    private static final long DATE1 = 1000000000000L;
    private static final int TEST_DIRECTORY_SIZE = 0;
    private static final BigInteger TEST_DIRECTORY_SIZE_BI = BigInteger.ZERO;
    private static final BigInteger TEST_DIRECTORY_SIZE_GT_ZERO_BI = BigInteger.valueOf(100L);
    private static final ListDirectoryWalker LIST_WALKER = new ListDirectoryWalker();
    private File testFile1;
    private File testFile2;
    private long testFile1Size;
    private long testFile2Size;

    private void assertContentMatchesAfterCopyURLToFileFor(String resourceName, File destination) throws IOException {
        FileUtils.copyURLToFile(this.getClass().getResource(resourceName), destination);
        try (InputStream fis = Files.newInputStream(destination.toPath(), new OpenOption[0]);
             InputStream expected = this.getClass().getResourceAsStream(resourceName);){
            Assertions.assertTrue((boolean)IOUtils.contentEquals(expected, fis), (String)"Content is not equal.");
        }
    }

    private void backDateFile10Minutes(File testFile) throws IOException {
        long mins10 = 600000L;
        long lastModified1 = this.getLastModifiedMillis(testFile);
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(testFile, lastModified1 - 600000L));
        Assertions.assertNotEquals((long)this.getLastModifiedMillis(testFile), (long)lastModified1, (String)"Should have changed source date");
    }

    private void consumeRemaining(Iterator<File> iterator) {
        if (iterator != null) {
            iterator.forEachRemaining(e -> {});
        }
    }

    private Path createCircularOsSymbolicLink(String linkName, String targetName) throws IOException {
        return Files.createSymbolicLink(Paths.get(linkName, new String[0]), Paths.get(targetName, new String[0]), new FileAttribute[0]);
    }

    private void createCircularSymbolicLink(File file) throws IOException {
        Assertions.assertTrue((boolean)file.exists());
        String linkName = file + "/cycle";
        String targetName = file + "/..";
        Assertions.assertTrue((boolean)file.exists());
        Path linkPath = Paths.get(linkName, new String[0]);
        Assertions.assertFalse((boolean)Files.exists(linkPath, new LinkOption[0]));
        Path targetPath = Paths.get(targetName, new String[0]);
        Assertions.assertTrue((boolean)Files.exists(targetPath, new LinkOption[0]));
        try {
            Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
        }
        catch (UnsupportedOperationException e) {
            this.createCircularOsSymbolicLink(linkName, targetName);
        }
        Assertions.assertTrue((boolean)Files.isSymbolicLink(linkPath), () -> "Expected a symbolic link here: " + linkName);
    }

    private void createFilesForTestCopyDirectory(File grandParentDir, File parentDir, File childDir) throws IOException {
        File childDir2 = new File(parentDir, "child2");
        File grandChildDir = new File(childDir, "grandChild");
        File grandChild2Dir = new File(childDir2, "grandChild2");
        File file1 = new File(grandParentDir, "file1.txt");
        File file2 = new File(parentDir, "file2.txt");
        File file3 = new File(childDir, "file3.txt");
        File file4 = new File(childDir2, "file4.txt");
        File file5 = new File(grandChildDir, "file5.txt");
        File file6 = new File(grandChild2Dir, "file6.txt");
        FileUtils.deleteDirectory(grandParentDir);
        grandChildDir.mkdirs();
        grandChild2Dir.mkdirs();
        FileUtils.writeStringToFile(file1, "File 1 in grandparent", "UTF8");
        FileUtils.writeStringToFile(file2, "File 2 in parent", "UTF8");
        FileUtils.writeStringToFile(file3, "File 3 in child", "UTF8");
        FileUtils.writeStringToFile(file4, "File 4 in child2", "UTF8");
        FileUtils.writeStringToFile(file5, "File 5 in grandChild", "UTF8");
        FileUtils.writeStringToFile(file6, "File 6 in grandChild2", "UTF8");
    }

    private ImmutablePair<Path, Path> createTempSymbolicLinkedRelativeDir() throws IOException {
        Path targetDir = this.tempDirPath.resolve("subdir");
        Path symLinkedDir = this.tempDirPath.resolve("symlinked-dir");
        Files.createDirectory(targetDir, new FileAttribute[0]);
        Files.createSymbolicLink(symLinkedDir, targetDir, new FileAttribute[0]);
        return ImmutablePair.of((Object)symLinkedDir, (Object)targetDir);
    }

    private Set<String> getFilePathSet(List<File> files) {
        return files.stream().map(f -> {
            try {
                return f.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet());
    }

    private long getLastModifiedMillis(File file) throws IOException {
        return FileUtils.lastModified(file);
    }

    private String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateFilesAndDirs(File dir, IOFileFilter fileFilter, IOFileFilter dirFilter, Collection<File> expectedFilesAndDirs) {
        Iterator<File> iterator = FileUtils.iterateFilesAndDirs(dir, fileFilter, dirFilter);
        int filesCount = 0;
        try {
            ArrayList<File> actualFiles = new ArrayList<File>();
            while (iterator.hasNext()) {
                ++filesCount;
                File file = iterator.next();
                actualFiles.add(file);
                Assertions.assertTrue((boolean)expectedFilesAndDirs.contains(file), () -> "Unexpected directory/file " + file + ", expected one of " + expectedFilesAndDirs);
            }
            Assertions.assertEquals((int)expectedFilesAndDirs.size(), (int)filesCount, actualFiles::toString);
        }
        finally {
            this.consumeRemaining(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openOutputStream_noParent(boolean createFile) throws Exception {
        File file = new File("test.txt");
        Assertions.assertNull((Object)file.getParentFile());
        try {
            if (createFile) {
                TestUtils.createLineBasedFile(file, new String[]{"Hello"});
            }
            try (FileOutputStream out = FileUtils.openOutputStream(file);){
                out.write(0);
            }
            Assertions.assertTrue((boolean)file.exists());
        }
        finally {
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    private boolean setLastModifiedMillis(File testFile, long millis) {
        return testFile.setLastModified(millis);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testFile1 = new File(this.tempDirFile, "file1-test.txt");
        this.testFile2 = new File(this.tempDirFile, "file1a-test.txt");
        this.testFile1Size = this.testFile1.length();
        this.testFile2Size = this.testFile2.length();
        if (!this.testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output3 = new BufferedOutputStream(Files.newOutputStream(this.testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output3, this.testFile1Size);
        }
        if (!this.testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output2 = new BufferedOutputStream(Files.newOutputStream(this.testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output2, this.testFile2Size);
        }
        FileUtils.deleteDirectory(this.tempDirFile);
        this.tempDirFile.mkdirs();
        if (!this.testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(this.testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, this.testFile1Size);
        }
        if (!this.testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, this.testFile2Size);
        }
    }

    @Test
    public void test_openInputStream_exists() throws Exception {
        File file = new File(this.tempDirFile, "test.txt");
        TestUtils.createLineBasedFile(file, new String[]{"Hello"});
        try (FileInputStream in = FileUtils.openInputStream(file);){
            Assertions.assertEquals((int)72, (int)in.read());
        }
    }

    @Test
    public void test_openInputStream_existsButIsDirectory() {
        File directory = new File(this.tempDirFile, "subdir");
        directory.mkdirs();
        Assertions.assertThrows(IOException.class, () -> FileUtils.openInputStream(directory));
    }

    @Test
    public void test_openInputStream_notExists() {
        File directory = new File(this.tempDirFile, "test.txt");
        Assertions.assertThrows(IOException.class, () -> FileUtils.openInputStream(directory));
    }

    @Test
    public void test_openOutputStream_exists() throws Exception {
        File file = new File(this.tempDirFile, "test.txt");
        TestUtils.createLineBasedFile(file, new String[]{"Hello"});
        try (FileOutputStream out = FileUtils.openOutputStream(file);){
            out.write(0);
        }
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    public void test_openOutputStream_existsButIsDirectory() {
        File directory = new File(this.tempDirFile, "subdir");
        directory.mkdirs();
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.openOutputStream(directory));
    }

    @Test
    public void test_openOutputStream_intoExistingSymlinkedDir() throws Exception {
        Path symlinkedDir = (Path)this.createTempSymbolicLinkedRelativeDir().getLeft();
        File file = symlinkedDir.resolve("test.txt").toFile();
        try (FileOutputStream out = FileUtils.openOutputStream(file);){
            out.write(0);
        }
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    public void test_openOutputStream_noParentCreateFile() throws Exception {
        this.openOutputStream_noParent(true);
    }

    @Test
    public void test_openOutputStream_noParentNoFile() throws Exception {
        this.openOutputStream_noParent(false);
    }

    @Test
    public void test_openOutputStream_notExists() throws Exception {
        File file = new File(this.tempDirFile, "a/test.txt");
        try (FileOutputStream out = FileUtils.openOutputStream(file);){
            out.write(0);
        }
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    public void test_openOutputStream_notExistsCannotCreate() {
        String longStr = "abcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyz";
        File file = new File(this.tempDirFile, "a/abcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyz/test.txt");
        Assertions.assertThrows(IOException.class, () -> FileUtils.openOutputStream(file));
    }

    @Test
    public void testByteCountToDisplaySizeBigInteger() {
        BigInteger b1023 = BigInteger.valueOf(1023L);
        BigInteger b1025 = BigInteger.valueOf(1025L);
        BigInteger KB1 = BigInteger.valueOf(1024L);
        BigInteger MB1 = KB1.multiply(KB1);
        BigInteger GB1 = MB1.multiply(KB1);
        BigInteger GB2 = GB1.add(GB1);
        BigInteger TB1 = GB1.multiply(KB1);
        BigInteger PB1 = TB1.multiply(KB1);
        BigInteger EB1 = PB1.multiply(KB1);
        Assertions.assertEquals((Object)"0 bytes", (Object)FileUtils.byteCountToDisplaySize(BigInteger.ZERO));
        Assertions.assertEquals((Object)"1 bytes", (Object)FileUtils.byteCountToDisplaySize(BigInteger.ONE));
        Assertions.assertEquals((Object)"1023 bytes", (Object)FileUtils.byteCountToDisplaySize(b1023));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize(KB1));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize(b1025));
        Assertions.assertEquals((Object)"1023 KB", (Object)FileUtils.byteCountToDisplaySize(MB1.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize(MB1));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize(MB1.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1023 MB", (Object)FileUtils.byteCountToDisplaySize(GB1.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize(GB1));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize(GB1.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"2 GB", (Object)FileUtils.byteCountToDisplaySize(GB2));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize(GB2.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize(TB1));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize(PB1));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize(EB1));
        Assertions.assertEquals((Object)"7 EB", (Object)FileUtils.byteCountToDisplaySize(Long.MAX_VALUE));
        Assertions.assertEquals((Object)"63 KB", (Object)FileUtils.byteCountToDisplaySize(BigInteger.valueOf(65535L)));
        Assertions.assertEquals((Object)"31 KB", (Object)FileUtils.byteCountToDisplaySize(BigInteger.valueOf(32767L)));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize(BigInteger.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    public void testByteCountToDisplaySizeLong() {
        Assertions.assertEquals((Object)"0 bytes", (Object)FileUtils.byteCountToDisplaySize(0L));
        Assertions.assertEquals((Object)"1 bytes", (Object)FileUtils.byteCountToDisplaySize(1L));
        Assertions.assertEquals((Object)"1023 bytes", (Object)FileUtils.byteCountToDisplaySize(1023L));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize(1024L));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize(1025L));
        Assertions.assertEquals((Object)"1023 KB", (Object)FileUtils.byteCountToDisplaySize(1047552L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize(0x100000L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize(0x100400L));
        Assertions.assertEquals((Object)"1023 MB", (Object)FileUtils.byteCountToDisplaySize(0x3FF00000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize(0x40000000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize(0x40100000L));
        Assertions.assertEquals((Object)"2 GB", (Object)FileUtils.byteCountToDisplaySize(0x80000000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize(Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize(0x10000000000L));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize(0x4000000000000L));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize(0x1000000000000000L));
        Assertions.assertEquals((Object)"7 EB", (Object)FileUtils.byteCountToDisplaySize(Long.MAX_VALUE));
        Assertions.assertEquals((Object)"63 KB", (Object)FileUtils.byteCountToDisplaySize(65535L));
        Assertions.assertEquals((Object)"31 KB", (Object)FileUtils.byteCountToDisplaySize(32767L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize(Integer.MAX_VALUE));
    }

    @Test
    public void testByteCountToDisplaySizeNumber() {
        Assertions.assertEquals((Object)"0 bytes", (Object)FileUtils.byteCountToDisplaySize((Number)0));
        Assertions.assertEquals((Object)"1 bytes", (Object)FileUtils.byteCountToDisplaySize((Number)1));
        Assertions.assertEquals((Object)"1023 bytes", (Object)FileUtils.byteCountToDisplaySize((Number)1023));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((Number)1024));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((Number)1025));
        Assertions.assertEquals((Object)"1023 KB", (Object)FileUtils.byteCountToDisplaySize((Number)1047552L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((Number)0x100000L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((Number)0x100400L));
        Assertions.assertEquals((Object)"1023 MB", (Object)FileUtils.byteCountToDisplaySize((Number)0x3FF00000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((Number)0x40000000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((Number)0x40100000L));
        Assertions.assertEquals((Object)"2 GB", (Object)FileUtils.byteCountToDisplaySize((Number)0x80000000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((Number)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize((Number)0x10000000000L));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize((Number)0x4000000000000L));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize((Number)0x1000000000000000L));
        Assertions.assertEquals((Object)"7 EB", (Object)FileUtils.byteCountToDisplaySize((Number)Long.MAX_VALUE));
        Assertions.assertEquals((Object)"63 KB", (Object)FileUtils.byteCountToDisplaySize((Number)65535));
        Assertions.assertEquals((Object)"31 KB", (Object)FileUtils.byteCountToDisplaySize((Number)Short.MAX_VALUE));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((Number)Integer.MAX_VALUE));
    }

    @Test
    public void testChecksum() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(this.tempDirFile, "checksum-test.txt");
        FileUtils.writeStringToFile(file, "Imagination is more important than knowledge - Einstein", StandardCharsets.US_ASCII.name());
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update("Imagination is more important than knowledge - Einstein".getBytes(StandardCharsets.US_ASCII), 0, "Imagination is more important than knowledge - Einstein".length());
        long expectedValue = expectedChecksum.getValue();
        CRC32 testChecksum = new CRC32();
        Checksum resultChecksum = FileUtils.checksum(file, testChecksum);
        long resultValue = resultChecksum.getValue();
        Assertions.assertSame((Object)testChecksum, (Object)resultChecksum);
        Assertions.assertEquals((long)expectedValue, (long)resultValue);
    }

    @Test
    public void testChecksumCRC32() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(this.tempDirFile, "checksum-test.txt");
        FileUtils.writeStringToFile(file, "Imagination is more important than knowledge - Einstein", StandardCharsets.US_ASCII.name());
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update("Imagination is more important than knowledge - Einstein".getBytes(StandardCharsets.US_ASCII), 0, "Imagination is more important than knowledge - Einstein".length());
        long expectedValue = expectedChecksum.getValue();
        long resultValue = FileUtils.checksumCRC32(file);
        Assertions.assertEquals((long)expectedValue, (long)resultValue);
    }

    @Test
    public void testChecksumDouble() throws Exception {
        String text1 = "Imagination is more important than knowledge - Einstein";
        File file1 = new File(this.tempDirFile, "checksum-test.txt");
        FileUtils.writeStringToFile(file1, "Imagination is more important than knowledge - Einstein", StandardCharsets.US_ASCII.name());
        String text2 = "To be or not to be - Shakespeare";
        File file2 = new File(this.tempDirFile, "checksum-test2.txt");
        FileUtils.writeStringToFile(file2, "To be or not to be - Shakespeare", StandardCharsets.US_ASCII.name());
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update("Imagination is more important than knowledge - Einstein".getBytes(StandardCharsets.US_ASCII), 0, "Imagination is more important than knowledge - Einstein".length());
        expectedChecksum.update("To be or not to be - Shakespeare".getBytes(StandardCharsets.US_ASCII), 0, "To be or not to be - Shakespeare".length());
        long expectedValue = expectedChecksum.getValue();
        CRC32 testChecksum = new CRC32();
        FileUtils.checksum(file1, testChecksum);
        FileUtils.checksum(file2, testChecksum);
        long resultValue = testChecksum.getValue();
        Assertions.assertEquals((long)expectedValue, (long)resultValue);
    }

    @Test
    public void testChecksumOnDirectory() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.checksum(FileUtils.current(), new CRC32()));
    }

    @Test
    public void testChecksumOnNullChecksum() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(this.tempDirFile, "checksum-test.txt");
        FileUtils.writeStringToFile(file, "Imagination is more important than knowledge - Einstein", StandardCharsets.US_ASCII.name());
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.checksum(file, null));
    }

    @Test
    public void testChecksumOnNullFile() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.checksum(null, new CRC32()));
    }

    @Test
    public void testCompareSizeOf() {
        File start = new File("src/test/java");
        long sizeLong1 = FileUtils.sizeOf(start);
        BigInteger sizeBig = FileUtils.sizeOfAsBigInteger(start);
        long sizeLong2 = FileUtils.sizeOf(start);
        Assertions.assertEquals((long)sizeLong1, (long)sizeLong2, (String)"Size should not change");
        Assertions.assertEquals((long)sizeLong1, (long)sizeBig.longValue(), (String)"longSize should equal BigSize");
    }

    @Test
    public void testContentEquals() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        File file2 = new File(this.tempDirFile, this.getName() + "2");
        Assertions.assertTrue((boolean)FileUtils.contentEquals(null, null));
        Assertions.assertFalse((boolean)FileUtils.contentEquals(null, file));
        Assertions.assertFalse((boolean)FileUtils.contentEquals(file, null));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(file, file));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(file, file2));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(file2, file2));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(file2, file));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.contentEquals(this.tempDirFile, this.tempDirFile));
        File objFile1 = new File(this.tempDirFile, this.getName() + ".object");
        FileUtils.copyURLToFile(this.getClass().getResource("/java/lang/Object.class"), objFile1);
        File objFile1b = new File(this.tempDirFile, this.getName() + ".object2");
        FileUtils.copyURLToFile(this.getClass().getResource("/java/lang/Object.class"), objFile1b);
        File objFile2 = new File(this.tempDirFile, this.getName() + ".collection");
        FileUtils.copyURLToFile(this.getClass().getResource("/java/util/Collection.class"), objFile2);
        Assertions.assertFalse((boolean)FileUtils.contentEquals(objFile1, objFile2));
        Assertions.assertFalse((boolean)FileUtils.contentEquals(objFile1b, objFile2));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(objFile1, objFile1b));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(objFile1, objFile1));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(objFile1b, objFile1b));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(objFile2, objFile2));
        file.createNewFile();
        file2.createNewFile();
        Assertions.assertTrue((boolean)FileUtils.contentEquals(file, file));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(file, file2));
    }

    @Test
    public void testContentEqualsIgnoreEOL() throws Exception {
        File file1 = new File(this.tempDirFile, this.getName());
        File file2 = new File(this.tempDirFile, this.getName() + "2");
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(null, null, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL(null, file1, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL(file1, null, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(file1, file1, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(file1, file2, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(file2, file2, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(file2, file1, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.contentEqualsIgnoreEOL(this.tempDirFile, this.tempDirFile, null));
        File tfile1 = new File(this.tempDirFile, this.getName() + ".txt1");
        FileUtils.write(tfile1, "123\r");
        File tfile2 = new File(this.tempDirFile, this.getName() + ".txt2");
        FileUtils.write(tfile2, "123\n");
        File tfile3 = new File(this.tempDirFile, this.getName() + ".collection");
        FileUtils.write(tfile3, "123\r\n2");
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(tfile1, tfile1, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(tfile2, tfile2, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(tfile3, tfile3, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(tfile1, tfile2, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL(tfile1, tfile3, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL(tfile2, tfile3, null));
        URL urlCR = this.getClass().getResource("FileUtilsTestDataCR.dat");
        Assertions.assertNotNull((Object)urlCR);
        File cr = new File(urlCR.toURI());
        Assertions.assertTrue((boolean)cr.exists());
        URL urlCRLF = this.getClass().getResource("FileUtilsTestDataCRLF.dat");
        Assertions.assertNotNull((Object)urlCRLF);
        File crlf = new File(urlCRLF.toURI());
        Assertions.assertTrue((boolean)crlf.exists());
        URL urlLF = this.getClass().getResource("FileUtilsTestDataLF.dat");
        Assertions.assertNotNull((Object)urlLF);
        File lf = new File(urlLF.toURI());
        Assertions.assertTrue((boolean)lf.exists());
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(cr, cr, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(crlf, crlf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(lf, lf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(cr, crlf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(cr, lf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(crlf, lf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(cr, cr));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(crlf, crlf));
        Assertions.assertTrue((boolean)FileUtils.contentEquals(lf, lf));
        Assertions.assertFalse((boolean)FileUtils.contentEquals(cr, crlf));
        Assertions.assertFalse((boolean)FileUtils.contentEquals(cr, lf));
        Assertions.assertFalse((boolean)FileUtils.contentEquals(crlf, lf));
        file1.createNewFile();
        file2.createNewFile();
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(file1, file1, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(file1, file2, null));
    }

    @Test
    public void testCopyDir_SymbolicLink() throws Exception {
        File realDirectory = new File(this.tempDirFile, "real_directory");
        realDirectory.mkdir();
        File content = new File(realDirectory, "hello.txt");
        FileUtils.writeStringToFile(content, "HELLO WORLD", "UTF8");
        Path linkPath = this.tempDirFile.toPath().resolve("link_to_directory");
        Files.createSymbolicLink(linkPath, realDirectory.toPath(), new FileAttribute[0]);
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyDirectory(linkPath.toFile(), destination);
        Assumptions.assumeTrue((boolean)content.delete());
        Assertions.assertFalse((boolean)Files.isSymbolicLink(destination.toPath()));
        File copied_content = new File(destination, "hello.txt");
        String actual = FileUtils.readFileToString(copied_content, "UTF8");
        Assertions.assertEquals((Object)"HELLO WORLD", (Object)actual);
    }

    @Test
    public void testCopyDir_SymbolicLinkCycle() throws Exception {
        File topDirectory = new File(this.tempDirFile, "topDirectory");
        topDirectory.mkdir();
        File content = new File(topDirectory, "hello.txt");
        FileUtils.writeStringToFile(content, "HELLO WORLD", "UTF8");
        File childDirectory = new File(topDirectory, "child_directory");
        childDirectory.mkdir();
        Path linkPath = childDirectory.toPath().resolve("link_to_top");
        Files.createSymbolicLink(linkPath, topDirectory.toPath(), new FileAttribute[0]);
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyDirectory(linkPath.toFile(), destination);
        Assumptions.assumeTrue((boolean)content.delete());
        Assertions.assertFalse((boolean)Files.isSymbolicLink(destination.toPath()));
        File copied_content = new File(destination, "hello.txt");
        String actual = FileUtils.readFileToString(copied_content, "UTF8");
        Assertions.assertEquals((Object)"HELLO WORLD", (Object)actual);
        File[] copied = destination.listFiles();
        Assertions.assertEquals((int)2, (int)copied.length);
    }

    @Test
    public void testCopyDirectory_brokenSymbolicLink() throws IOException {
        File sourceDirectory = new File(this.tempDirFile, "source_directory");
        sourceDirectory.mkdir();
        File targetFile = new File(sourceDirectory, "hello.txt");
        FileUtils.writeStringToFile(targetFile, "HELLO WORLD", "UTF8");
        Path targetPath = targetFile.toPath();
        Path linkPath = sourceDirectory.toPath().resolve("linkfile");
        Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
        Assumptions.assumeTrue((boolean)Files.isSymbolicLink(linkPath), () -> "Expected a symlink here: " + linkPath);
        Assumptions.assumeTrue((boolean)Files.exists(linkPath, new LinkOption[0]));
        Assumptions.assumeTrue((boolean)Files.exists(linkPath, LinkOption.NOFOLLOW_LINKS));
        Assumptions.assumeTrue((boolean)targetFile.delete());
        Assumptions.assumeFalse((boolean)Files.exists(linkPath, new LinkOption[0]));
        Assumptions.assumeTrue((boolean)Files.exists(linkPath, LinkOption.NOFOLLOW_LINKS));
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyDirectory(sourceDirectory, destination);
        Assertions.assertTrue((boolean)destination.exists());
        Path copiedBrokenSymlink = new File(destination, "linkfile").toPath();
        Assertions.assertTrue((boolean)Files.isSymbolicLink(copiedBrokenSymlink));
        Assertions.assertFalse((boolean)Files.exists(copiedBrokenSymlink, new LinkOption[0]));
    }

    @Test
    public void testCopyDirectory_SymbolicLink() throws IOException {
        File sourceDirectory = new File(this.tempDirFile, "source_directory");
        sourceDirectory.mkdir();
        File targetFile = new File(sourceDirectory, "hello.txt");
        FileUtils.writeStringToFile(targetFile, "HELLO WORLD", "UTF8");
        Path targetPath = targetFile.toPath();
        Path linkPath = sourceDirectory.toPath().resolve("linkfile");
        Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
        Assumptions.assumeTrue((boolean)Files.isSymbolicLink(linkPath), () -> "Expected a symlink here: " + linkPath);
        Assumptions.assumeTrue((boolean)Files.exists(linkPath, new LinkOption[0]));
        Assumptions.assumeTrue((boolean)Files.exists(linkPath, LinkOption.NOFOLLOW_LINKS));
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyDirectory(sourceDirectory, destination);
        Assertions.assertTrue((boolean)destination.exists());
        Path copiedSymlink = new File(destination, "linkfile").toPath();
        Assertions.assertTrue((boolean)Files.isSymbolicLink(copiedSymlink));
        Assertions.assertTrue((boolean)Files.exists(copiedSymlink, new LinkOption[0]));
    }

    @Test
    public void testCopyDirectory_SymbolicLinkExternalFile() throws Exception {
        File content = new File(this.tempDirFile, "hello.txt");
        FileUtils.writeStringToFile(content, "HELLO WORLD", "UTF8");
        File realDirectory = new File(this.tempDirFile, "real_directory");
        realDirectory.mkdir();
        Path linkPath = realDirectory.toPath().resolve("link_to_file");
        Files.createSymbolicLink(linkPath, content.toPath(), new FileAttribute[0]);
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyDirectory(realDirectory, destination);
        File copiedLink = new File(destination, "link_to_file");
        Assertions.assertTrue((boolean)Files.isSymbolicLink(copiedLink.toPath()));
        String actual = FileUtils.readFileToString(copiedLink, "UTF8");
        Assertions.assertEquals((Object)"HELLO WORLD", (Object)actual);
        Path source = Files.readSymbolicLink(copiedLink.toPath());
        Assertions.assertEquals((Object)content.toPath(), (Object)source);
    }

    @Test
    public void testCopyDirectoryExceptions() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory(null, this.testFile1));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory(this.testFile1, null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory(null, new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory(this.testFile1, new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory(this.testFile1, new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory(this.tempDirFile, this.tempDirFile));
        Assertions.assertThrows(IOException.class, () -> FileUtils.copyDirectory(new File("doesnt-exist"), new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory(this.tempDirFile, this.testFile1));
    }

    @Test
    public void testCopyDirectoryFiltered() throws IOException {
        File grandParentDir = new File(this.tempDirFile, "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        NameFileFilter filter = new NameFileFilter("parent", "child", "file3.txt");
        File destDir = new File(this.tempDirFile, "copydest");
        FileUtils.copyDirectory(grandParentDir, destDir, filter);
        List<File> files = LIST_WALKER.list(destDir);
        Assertions.assertEquals((int)3, (int)files.size());
        Assertions.assertEquals((Object)"parent", (Object)files.get(0).getName());
        Assertions.assertEquals((Object)"child", (Object)files.get(1).getName());
        Assertions.assertEquals((Object)"file3.txt", (Object)files.get(2).getName());
    }

    @Test
    public void testCopyDirectoryPreserveDates() throws Exception {
        File source = new File(this.tempDirFile, "source");
        File sourceDirectory = new File(source, "directory");
        File sourceFile = new File(sourceDirectory, "hello.txt");
        source.mkdirs();
        sourceDirectory.mkdir();
        FileUtils.writeStringToFile(sourceFile, "HELLO WORLD", "UTF8");
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(sourceFile, 1000000002000L));
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(sourceDirectory, 1000000001000L));
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(source, 1000000000000L));
        File target = new File(this.tempDirFile, "target");
        File targetDirectory = new File(target, "directory");
        File targetFile = new File(targetDirectory, "hello.txt");
        FileUtils.copyDirectory(source, target, false);
        Assertions.assertNotEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertNotEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        if (!SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertNotEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        }
        if (!SystemUtils.IS_OS_WINDOWS) {
            Set<PosixFilePermission> parentPerms = Files.getPosixFilePermissions(target.getParentFile().toPath(), new LinkOption[0]);
            Set<PosixFilePermission> targetPerms = Files.getPosixFilePermissions(target.toPath(), new LinkOption[0]);
            Assertions.assertEquals(parentPerms, targetPerms);
        } else {
            AclFileAttributeView parentView = Files.getFileAttributeView(target.getParentFile().toPath(), AclFileAttributeView.class, new LinkOption[0]);
            AclFileAttributeView targetView = Files.getFileAttributeView(target.toPath(), AclFileAttributeView.class, new LinkOption[0]);
            Assertions.assertEquals(parentView.getAcl(), targetView.getAcl());
        }
        FileUtils.deleteDirectory(target);
        FileUtils.copyDirectory(source, target, true);
        Assertions.assertEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        Assertions.assertEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        FileUtils.deleteDirectory(target);
        target.mkdirs();
        FileUtils.copyDirectory(source, target, true);
        Assertions.assertEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        Assertions.assertEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        FileUtils.deleteDirectory(target);
        targetDirectory.mkdirs();
        FileUtils.copyDirectory(source, target, true);
        Assertions.assertEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        Assertions.assertEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        FileUtils.deleteDirectory(target);
    }

    @Test
    public void testCopyDirectoryToChild() throws IOException {
        File grandParentDir = new File(this.tempDirFile, "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        long expectedCount = LIST_WALKER.list(grandParentDir).size() + LIST_WALKER.list(parentDir).size();
        long expectedSize = FileUtils.sizeOfDirectory(grandParentDir) + FileUtils.sizeOfDirectory(parentDir);
        FileUtils.copyDirectory(parentDir, childDir);
        Assertions.assertEquals((long)expectedCount, (long)LIST_WALKER.list(grandParentDir).size());
        Assertions.assertEquals((long)expectedSize, (long)FileUtils.sizeOfDirectory(grandParentDir));
        Assertions.assertTrue((expectedCount > 0L ? 1 : 0) != 0, (String)"Count > 0");
        Assertions.assertTrue((expectedSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
    }

    @Test
    public void testCopyDirectoryToDirectory_NonExistingDest() throws Exception {
        if (!this.testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(this.testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 1234L);
        }
        if (!this.testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 4321L);
        }
        File srcDir = this.tempDirFile;
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile(subFile, "HELLO WORLD", "UTF8");
        File destDir = new File(FileUtils.getTempDirectoryPath(), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory(destDir);
        File actualDestDir = new File(destDir, srcDir.getName());
        FileUtils.copyDirectoryToDirectory(srcDir, destDir);
        Assertions.assertTrue((boolean)destDir.exists(), (String)"Check exists");
        Assertions.assertTrue((boolean)actualDestDir.exists(), (String)"Check exists");
        long srcSize = FileUtils.sizeOfDirectory(srcDir);
        Assertions.assertTrue((srcSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
        Assertions.assertEquals((long)srcSize, (long)FileUtils.sizeOfDirectory(actualDestDir), (String)"Check size");
        Assertions.assertTrue((boolean)new File(actualDestDir, "sub/A.txt").exists());
        FileUtils.deleteDirectory(destDir);
    }

    @Test
    public void testCopyDirectoryToExistingDest() throws Exception {
        if (!this.testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(this.testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 1234L);
        }
        if (!this.testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 4321L);
        }
        File srcDir = this.tempDirFile;
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile(subFile, "HELLO WORLD", "UTF8");
        File destDir = new File(SystemProperties.getJavaIoTmpdir(), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory(destDir);
        destDir.mkdirs();
        FileUtils.copyDirectory(srcDir, destDir);
        long srcSize = FileUtils.sizeOfDirectory(srcDir);
        Assertions.assertTrue((srcSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
        Assertions.assertEquals((long)srcSize, (long)FileUtils.sizeOfDirectory(destDir));
        Assertions.assertTrue((boolean)new File(destDir, "sub/A.txt").exists());
    }

    @Test
    public void testCopyDirectoryToGrandChild() throws IOException {
        File grandParentDir = new File(this.tempDirFile, "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        long expectedCount = LIST_WALKER.list(grandParentDir).size() * 2;
        long expectedSize = FileUtils.sizeOfDirectory(grandParentDir) * 2L;
        FileUtils.copyDirectory(grandParentDir, childDir);
        Assertions.assertEquals((long)expectedCount, (long)LIST_WALKER.list(grandParentDir).size());
        Assertions.assertEquals((long)expectedSize, (long)FileUtils.sizeOfDirectory(grandParentDir));
        Assertions.assertTrue((expectedSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
    }

    @Test
    public void testCopyDirectoryToItself() throws Exception {
        File dir = new File(this.tempDirFile, "itself");
        dir.mkdirs();
        FileUtils.copyDirectoryToDirectory(dir, dir);
        Assertions.assertEquals((int)1, (int)LIST_WALKER.list(dir).size());
    }

    @Test
    public void testCopyDirectoryToNonExistingDest() throws Exception {
        if (!this.testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(this.testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 1234L);
        }
        if (!this.testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + this.testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 4321L);
        }
        File srcDir = this.tempDirFile;
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile(subFile, "HELLO WORLD", "UTF8");
        File destDir = new File(FileUtils.getTempDirectoryPath(), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory(destDir);
        FileUtils.copyDirectory(srcDir, destDir);
        Assertions.assertTrue((boolean)destDir.exists(), (String)"Check exists");
        long sizeOfSrcDirectory = FileUtils.sizeOfDirectory(srcDir);
        Assertions.assertTrue((sizeOfSrcDirectory > 0L ? 1 : 0) != 0, (String)"Size > 0");
        Assertions.assertEquals((long)sizeOfSrcDirectory, (long)FileUtils.sizeOfDirectory(destDir), (String)"Check size");
        Assertions.assertTrue((boolean)new File(destDir, "sub/A.txt").exists());
        FileUtils.deleteDirectory(destDir);
    }

    @Test
    public void testCopyDirectoryWithPotentialFalsePartialMatch() throws IOException {
        File grandParentDir = new File(this.tempDirFile, "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File parDir = new File(grandParentDir, "par");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parDir, childDir);
        List<File> initFiles = LIST_WALKER.list(grandParentDir);
        List<File> parFiles = LIST_WALKER.list(parDir);
        long expectedCount = initFiles.size() + parFiles.size();
        long expectedSize = FileUtils.sizeOfDirectory(grandParentDir) + FileUtils.sizeOfDirectory(parDir);
        FileUtils.copyDirectory(parDir, childDir);
        List<File> latestFiles = LIST_WALKER.list(grandParentDir);
        Assertions.assertEquals((long)expectedCount, (long)latestFiles.size());
        Assertions.assertEquals((long)expectedSize, (long)FileUtils.sizeOfDirectory(grandParentDir));
        Assertions.assertTrue((expectedCount > 0L ? 1 : 0) != 0, (String)"Count > 0");
        Assertions.assertTrue((expectedSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
        Set<String> initFilePaths = this.getFilePathSet(initFiles);
        Set<String> newFilePaths = this.getFilePathSet(latestFiles);
        newFilePaths.removeAll(initFilePaths);
        Assertions.assertEquals((int)parFiles.size(), (int)newFilePaths.size());
    }

    @Test
    public void testCopyFile_SymbolicLink() throws Exception {
        File sourceDirectory = new File(this.tempDirFile, "source_directory");
        sourceDirectory.mkdir();
        File targetFile = new File(sourceDirectory, "hello.txt");
        FileUtils.writeStringToFile(targetFile, "HELLO WORLD", "UTF8");
        Path targetPath = targetFile.toPath();
        Path linkPath = sourceDirectory.toPath().resolve("linkfile");
        Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
        File destination = new File(this.tempDirFile, "destination");
        FileUtils.copyFile(linkPath.toFile(), destination);
        Assertions.assertFalse((boolean)Files.isSymbolicLink(destination.toPath()));
        String contents = FileUtils.readFileToString(destination, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"HELLO WORLD", (Object)contents);
    }

    @Test
    public void testCopyFile1() throws Exception {
        File destination = new File(this.tempDirFile, "copy1.txt");
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFile(this.testFile1, destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)this.getLastModifiedMillis(this.testFile1), (long)this.getLastModifiedMillis(destination), (String)"Check last modified date preserved");
    }

    @Test
    public void testCopyFile1ToDir() throws Exception {
        File directory = new File(this.tempDirFile, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File destination = new File(directory, this.testFile1.getName());
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFileToDirectory(this.testFile1, directory);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)FileUtils.lastModified(this.testFile1), (long)FileUtils.lastModified(destination), (String)"Check last modified date preserved");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyFileToDirectory(destination, directory), (String)"Should not be able to copy a file into the same directory as itself");
    }

    @Test
    public void testCopyFile2() throws Exception {
        File destination = new File(this.tempDirFile, "copy2.txt");
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFile(this.testFile1, destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile2Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)this.getLastModifiedMillis(this.testFile1), (long)this.getLastModifiedMillis(destination), (String)"Check last modified date preserved");
    }

    @Test
    public void testCopyFile2ToDir() throws Exception {
        File directory = new File(this.tempDirFile, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File destination = new File(directory, this.testFile1.getName());
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFileToDirectory(this.testFile1, directory);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile2Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)FileUtils.lastModified(this.testFile1), (long)FileUtils.lastModified(destination), (String)"Check last modified date preserved");
    }

    @Test
    public void testCopyFile2WithoutFileDatePreservation() throws Exception {
        File destFile = new File(this.tempDirFile, "copy2.txt");
        this.backDateFile10Minutes(this.testFile1);
        long nowMillis = System.currentTimeMillis() - 1000L;
        FileUtils.copyFile(this.testFile1, destFile, false);
        Assertions.assertTrue((boolean)destFile.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile1Size, (long)destFile.length(), (String)"Check Full copy");
        long destLastModMillis = this.getLastModifiedMillis(destFile);
        long unexpectedMillis = this.getLastModifiedMillis(this.testFile1);
        if (!SystemUtils.IS_OS_WINDOWS) {
            long deltaMillis = destLastModMillis - unexpectedMillis;
            Assertions.assertNotEquals((long)unexpectedMillis, (long)destLastModMillis, (String)("Check last modified date not same as input, delta " + deltaMillis));
            Assertions.assertTrue((destLastModMillis > nowMillis ? 1 : 0) != 0, (String)(destLastModMillis + " > " + nowMillis + " (delta " + deltaMillis + ")"));
        }
    }

    @Test
    @Disabled
    public void testCopyFileLarge() throws Exception {
        File largeFile = new File(this.tempDirFile, "large.txt");
        File destination = new File(this.tempDirFile, "copylarge.txt");
        if (!largeFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + largeFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(largeFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0x40000000L);
        }
        FileUtils.copyFile(largeFile, destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)largeFile.length(), (long)destination.length(), (String)"Check Full copy");
    }

    @Test
    public void testCopyFileToOutputStream() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        FileUtils.copyFile(this.testFile1, destination);
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.size(), (String)"Check Full copy size");
        byte[] expected = FileUtils.readFileToByteArray(this.testFile1);
        Assertions.assertArrayEquals((byte[])expected, (byte[])destination.toByteArray(), (String)"Check Full copy");
    }

    @Test
    public void testCopyFileToReadOnlyDirectory() throws Exception {
        File directory = new File(this.tempDirFile, "readonly");
        if (!directory.exists()) {
            Assumptions.assumeTrue((boolean)directory.mkdirs());
        }
        Assumptions.assumeTrue((boolean)directory.setWritable(false));
        Assertions.assertThrows(IOException.class, () -> FileUtils.copyFileToDirectory(this.testFile1, directory), (String)"Should not be able to copy a file into a readonly directory");
    }

    @Test
    public void testCopyToDirectoryWithDirectory() throws IOException {
        File inputDirectory;
        File destDirectory = new File(this.tempDirFile, "destination");
        if (!destDirectory.exists()) {
            destDirectory.mkdirs();
        }
        if (!(inputDirectory = new File(this.tempDirFile, "input")).exists()) {
            inputDirectory.mkdirs();
        }
        File outputDirDestination = new File(destDirectory, inputDirectory.getName());
        FileUtils.copyToDirectory(this.testFile1, inputDirectory);
        File destFile1 = new File(outputDirDestination, this.testFile1.getName());
        FileUtils.copyToDirectory(this.testFile2, inputDirectory);
        File destFile2 = new File(outputDirDestination, this.testFile2.getName());
        FileUtils.copyToDirectory(inputDirectory, destDirectory);
        Assertions.assertTrue((boolean)outputDirDestination.exists(), (String)"Check Exists");
        Assertions.assertTrue((boolean)outputDirDestination.isDirectory(), (String)"Check Directory");
        Assertions.assertTrue((boolean)destFile1.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile1Size, (long)destFile1.length(), (String)"Check Full Copy");
        Assertions.assertTrue((boolean)destFile2.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile2Size, (long)destFile2.length(), (String)"Check Full Copy");
    }

    @Test
    public void testCopyToDirectoryWithFile() throws IOException {
        File directory = new File(this.tempDirFile, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File destination = new File(directory, this.testFile1.getName());
        FileUtils.copyToDirectory(this.testFile1, directory);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.length(), (String)"Check Full Copy");
    }

    @Test
    public void testCopyToDirectoryWithFileSourceDoesNotExist() {
        Assertions.assertThrows(IOException.class, () -> FileUtils.copyToDirectory(new File(this.tempDirFile, "doesNotExists"), this.tempDirFile));
    }

    @Test
    public void testCopyToDirectoryWithFileSourceIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyToDirectory((File)null, this.tempDirFile));
    }

    @Test
    public void testCopyToDirectoryWithIterable() throws IOException {
        File directory = new File(this.tempDirFile, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        ArrayList<File> input = new ArrayList<File>();
        input.add(this.testFile1);
        input.add(this.testFile2);
        File destFile1 = new File(directory, this.testFile1.getName());
        File destFile2 = new File(directory, this.testFile2.getName());
        FileUtils.copyToDirectory(input, directory);
        Assertions.assertTrue((boolean)destFile1.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile1Size, (long)destFile1.length(), (String)"Check Full Copy");
        Assertions.assertTrue((boolean)destFile2.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile2Size, (long)destFile2.length(), (String)"Check Full Copy");
    }

    @Test
    public void testCopyToDirectoryWithIterableSourceDoesNotExist() {
        Assertions.assertThrows(IOException.class, () -> FileUtils.copyToDirectory(Collections.singleton(new File(this.tempDirFile, "doesNotExists")), this.tempDirFile));
    }

    @Test
    public void testCopyToDirectoryWithIterableSourceIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyToDirectory((Iterable<File>)null, this.tempDirFile));
    }

    @Test
    public void testCopyToSelf() throws Exception {
        File destination = new File(this.tempDirFile, "copy3.txt");
        FileUtils.copyFile(this.testFile1, destination);
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyFile(destination, destination));
    }

    @Test
    public void testCopyURLToFile() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        this.assertContentMatchesAfterCopyURLToFileFor("/java/lang/Object.class", file);
    }

    @Test
    public void testCopyURLToFileCreatesParentDirs() throws Exception {
        File file = this.managedTempDirPath.resolve("subdir").resolve(this.getName()).toFile();
        this.assertContentMatchesAfterCopyURLToFileFor("/java/lang/Object.class", file);
    }

    @Test
    public void testCopyURLToFileReplacesExisting() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        this.assertContentMatchesAfterCopyURLToFileFor("/java/lang/Object.class", file);
        this.assertContentMatchesAfterCopyURLToFileFor("/java/lang/String.class", file);
    }

    @Test
    public void testCopyURLToFileWithTimeout() throws Exception {
        File file = new File(this.tempDirFile, "testCopyURLToFileWithTimeout");
        String resourceName = "/java/lang/Object.class";
        FileUtils.copyURLToFile(this.getClass().getResource("/java/lang/Object.class"), file, 500, 500);
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
             InputStream resStream = this.getClass().getResourceAsStream("/java/lang/Object.class");){
            Assertions.assertTrue((boolean)IOUtils.contentEquals(resStream, fis), (String)"Content is not equal.");
        }
    }

    @Test
    public void testCountFolders1FileSize0() {
        Assertions.assertEquals((long)0L, (long)FileUtils.sizeOfDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]).toFile()));
    }

    @Test
    public void testCountFolders1FileSize1() {
        Assertions.assertEquals((long)1L, (long)FileUtils.sizeOfDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]).toFile()));
    }

    @Test
    public void testCountFolders2FileSize2() {
        Assertions.assertEquals((long)2L, (long)FileUtils.sizeOfDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]).toFile()));
    }

    @Test
    public void testCountFolders2FileSize4() {
        Assertions.assertEquals((long)8L, (long)FileUtils.sizeOfDirectory(Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-4", new String[0]).toFile()));
    }

    @Test
    public void testCreateParentDirectories() throws IOException {
        FileUtils.createParentDirectories(FileUtils.current());
        FileUtils.createParentDirectories(null);
    }

    @Test
    public void testDecodeUrl() {
        Assertions.assertEquals((Object)"", (Object)FileUtils.decodeUrl(""));
        Assertions.assertEquals((Object)"foo", (Object)FileUtils.decodeUrl("foo"));
        Assertions.assertEquals((Object)"+", (Object)FileUtils.decodeUrl("+"));
        Assertions.assertEquals((Object)"% ", (Object)FileUtils.decodeUrl("%25%20"));
        Assertions.assertEquals((Object)"%20", (Object)FileUtils.decodeUrl("%2520"));
        Assertions.assertEquals((Object)"jar:file:/C:/dir/sub dir/1.0/foo-1.0.jar!/org/Bar.class", (Object)FileUtils.decodeUrl("jar:file:/C:/dir/sub%20dir/1.0/foo-1.0.jar!/org/Bar.class"));
    }

    @Test
    public void testDecodeUrlEncodingUtf8() {
        Assertions.assertEquals((Object)"\u00e4\u00f6\u00fc\u00df", (Object)FileUtils.decodeUrl("%C3%A4%C3%B6%C3%BC%C3%9F"));
    }

    @Test
    public void testDecodeUrlLenient() {
        Assertions.assertEquals((Object)" ", (Object)FileUtils.decodeUrl(" "));
        Assertions.assertEquals((Object)"\u00e4\u00f6\u00fc\u00df", (Object)FileUtils.decodeUrl("\u00e4\u00f6\u00fc\u00df"));
        Assertions.assertEquals((Object)"%", (Object)FileUtils.decodeUrl("%"));
        Assertions.assertEquals((Object)"% ", (Object)FileUtils.decodeUrl("%%20"));
        Assertions.assertEquals((Object)"%2", (Object)FileUtils.decodeUrl("%2"));
        Assertions.assertEquals((Object)"%2G", (Object)FileUtils.decodeUrl("%2G"));
    }

    @Test
    public void testDecodeUrlNullSafe() {
        Assertions.assertNull((Object)FileUtils.decodeUrl(null));
    }

    @Test
    public void testDelete() throws Exception {
        Assertions.assertEquals((Object)this.testFile1, (Object)FileUtils.delete(this.testFile1));
        Assertions.assertThrows(IOException.class, () -> FileUtils.delete(new File("does not exist.nope")));
    }

    @Test
    public void testDeleteDirectoryFailsOnFile() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.deleteDirectory(this.testFile1));
    }

    @Test
    public void testDeleteDirectoryNoopIfAbsent() {
        Assertions.assertDoesNotThrow(() -> FileUtils.deleteDirectory(new File("does not exist.nope")));
    }

    @Test
    public void testDeleteDirectorySymbolicLink() throws IOException {
        Path symlinkedDir = (Path)this.createTempSymbolicLinkedRelativeDir().getLeft();
        FileUtils.deleteDirectory(symlinkedDir.toFile());
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]));
    }

    @Test
    public void testDeleteDirectorySymbolicLinkAbsent() throws IOException {
        ImmutablePair<Path, Path> pair = this.createTempSymbolicLinkedRelativeDir();
        Path symlinkedDir = (Path)pair.getLeft();
        Path targetDir = (Path)pair.getRight();
        Assertions.assertTrue((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
        Files.delete(symlinkedDir);
        Assertions.assertTrue((boolean)Files.exists(targetDir, new LinkOption[0]), targetDir::toString);
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
        FileUtils.deleteDirectory(symlinkedDir.toFile());
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
    }

    @Test
    public void testDeleteDirectorySymbolicLinkAbsentDeepTarget() throws IOException {
        ImmutablePair<Path, Path> pair = this.createTempSymbolicLinkedRelativeDir();
        Path symLinkedDir = (Path)pair.getLeft();
        Path targetDir = (Path)pair.getRight();
        Path targetDir2 = targetDir.resolve("subdir2");
        Path symLinkedDir2 = targetDir.resolve("symlinked-dir2");
        Files.createDirectory(targetDir2, new FileAttribute[0]);
        Files.createSymbolicLink(symLinkedDir2, targetDir2, new FileAttribute[0]);
        Assertions.assertTrue((boolean)Files.exists(symLinkedDir2, new LinkOption[0]), symLinkedDir2::toString);
        Files.delete(targetDir2);
        Assertions.assertFalse((boolean)Files.exists(targetDir2, new LinkOption[0]), targetDir2::toString);
        Assertions.assertFalse((boolean)Files.exists(symLinkedDir2, new LinkOption[0]), symLinkedDir2::toString);
        FileUtils.deleteDirectory(targetDir.toFile());
        Assertions.assertFalse((boolean)Files.exists(targetDir, new LinkOption[0]), targetDir::toString);
    }

    @Test
    public void testDeleteDirectorySymbolicLinkAbsentTarget() throws IOException {
        ImmutablePair<Path, Path> pair = this.createTempSymbolicLinkedRelativeDir();
        Path symlinkedDir = (Path)pair.getLeft();
        Path targetDir = (Path)pair.getRight();
        Assertions.assertTrue((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
        Files.delete(targetDir);
        Assertions.assertFalse((boolean)Files.exists(targetDir, new LinkOption[0]), targetDir::toString);
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
        FileUtils.deleteDirectory(symlinkedDir.toFile());
        Assertions.assertFalse((boolean)Files.exists(symlinkedDir, new LinkOption[0]), symlinkedDir::toString);
    }

    @Test
    public void testDeleteQuietlyDir() throws IOException {
        File testDirectory = new File(this.tempDirFile, "testDeleteQuietlyDir");
        File testFile = new File(testDirectory, "testDeleteQuietlyFile");
        testDirectory.mkdirs();
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Assertions.assertTrue((boolean)testDirectory.exists());
        Assertions.assertTrue((boolean)testFile.exists());
        FileUtils.deleteQuietly(testDirectory);
        Assertions.assertFalse((boolean)testDirectory.exists(), (String)"Check No Exist");
        Assertions.assertFalse((boolean)testFile.exists(), (String)"Check No Exist");
    }

    @Test
    public void testDeleteQuietlyFile() throws IOException {
        File testFile = new File(this.tempDirFile, "testDeleteQuietlyFile");
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Assertions.assertTrue((boolean)testFile.exists());
        FileUtils.deleteQuietly(testFile);
        Assertions.assertFalse((boolean)testFile.exists(), (String)"Check No Exist");
    }

    @Test
    public void testDeleteQuietlyForNull() {
        FileUtils.deleteQuietly(null);
    }

    @Test
    public void testDeleteQuietlyNonExistent() {
        File testFile = new File("testDeleteQuietlyNonExistent");
        Assertions.assertFalse((boolean)testFile.exists());
        FileUtils.deleteQuietly(testFile);
    }

    @Test
    public void testFileUtils() throws Exception {
        File file1 = new File(this.tempDirFile, "test.txt");
        String fileName = file1.getAbsolutePath();
        try (OutputStream out = Files.newOutputStream(file1.toPath(), new OpenOption[0]);){
            out.write("This is a test".getBytes(StandardCharsets.UTF_8));
        }
        File file2 = new File(this.tempDirFile, "test2.txt");
        FileUtils.writeStringToFile(file2, fileName, UTF_8);
        Assertions.assertTrue((boolean)file2.exists());
        Assertions.assertTrue((file2.length() > 0L ? 1 : 0) != 0);
        String file2contents = FileUtils.readFileToString(file2, UTF_8);
        Assertions.assertEquals((Object)fileName, (Object)file2contents, (String)"Second file's contents correct");
        Assertions.assertTrue((boolean)file2.delete());
        String contents = FileUtils.readFileToString(new File(fileName), UTF_8);
        Assertions.assertEquals((Object)"This is a test", (Object)contents, (String)"FileUtils.fileRead()");
    }

    @Test
    public void testForceDeleteAFile1() throws Exception {
        File destination = new File(this.tempDirFile, "copy1.txt");
        destination.createNewFile();
        Assertions.assertTrue((boolean)destination.exists(), (String)"Copy1.txt doesn't exist to delete");
        FileUtils.forceDelete(destination);
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check No Exist");
    }

    @Test
    public void testForceDeleteAFile2() throws Exception {
        File destination = new File(this.tempDirFile, "copy2.txt");
        destination.createNewFile();
        Assertions.assertTrue((boolean)destination.exists(), (String)"Copy2.txt doesn't exist to delete");
        FileUtils.forceDelete(destination);
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check No Exist");
    }

    @Test
    public void testForceDeleteAFileDoesNotExist() {
        File destination = new File(this.tempDirFile, "no_such_file");
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check No Exist");
        Assertions.assertThrowsExactly(FileNotFoundException.class, () -> FileUtils.forceDelete(destination));
    }

    @Test
    public void testForceDeleteDir() throws Exception {
        File testDirectory = this.tempDirFile;
        Assertions.assertTrue((boolean)testDirectory.exists(), (String)"TestDirectory must exist");
        FileUtils.forceDelete(testDirectory);
        Assertions.assertFalse((boolean)testDirectory.exists(), (String)"TestDirectory must not exist");
    }

    @Test
    @EnabledOnOs(value={OS.MAC})
    public void testForceDeleteReadOnlyDirectory() throws Exception {
        TempFile destination;
        try (TempDirectory destDir = TempDirectory.create("dir-", new FileAttribute[0]);){
            destination = TempFile.create(destDir, "test-", ".txt", new FileAttribute[0]);
            try {
                Assertions.assertTrue((boolean)Files.isDirectory(destDir.get(), new LinkOption[0]));
                Assertions.assertEquals((Object)destDir.get(), (Object)destination.get().getParent());
                File file = destination.toFile();
                Assertions.assertTrue((boolean)file.setReadOnly());
                Assertions.assertTrue((boolean)file.canRead());
                Assertions.assertFalse((boolean)file.canWrite());
                Counters.PathCounters delete = destDir.delete();
                Assertions.assertEquals((long)1L, (long)delete.getDirectoryCounter().get());
                Assertions.assertEquals((long)1L, (long)delete.getFileCounter().get());
                Assertions.assertFalse((boolean)file.exists());
                Assertions.assertFalse((boolean)destDir.exists(new LinkOption[0]));
            }
            finally {
                if (destination != null) {
                    destination.close();
                }
            }
        }
        destDir = TempDirectory.create("dir-", new FileAttribute[0]);
        try {
            destination = TempFile.create(destDir, "test-", ".txt", new FileAttribute[0]);
            try {
                Assertions.assertTrue((boolean)Files.isDirectory(destDir.get(), new LinkOption[0]));
                Assertions.assertEquals((Object)destDir.get(), (Object)destination.get().getParent());
                File dir = destDir.toFile();
                Assertions.assertTrue((boolean)dir.setReadOnly());
                Assertions.assertTrue((boolean)dir.canRead());
                Assertions.assertFalse((boolean)dir.canWrite());
                Assertions.assertTrue((boolean)dir.exists(), (String)"File doesn't exist to delete");
                FileUtils.forceDelete(dir);
                Assertions.assertFalse((boolean)destination.exists(new LinkOption[0]), (String)"Check deletion");
                Assertions.assertFalse((boolean)dir.exists(), (String)"Check deletion");
                Assertions.assertFalse((boolean)destDir.exists(new LinkOption[0]), (String)"Check deletion");
            }
            finally {
                if (destination != null) {
                    destination.close();
                }
            }
        }
        finally {
            if (destDir != null) {
                destDir.close();
            }
        }
    }

    @Test
    public void testForceDeleteReadOnlyFile() throws Exception {
        File file;
        try (TempFile destination = TempFile.create("test-", ".txt", new FileAttribute[0]);){
            file = destination.toFile();
            Assertions.assertTrue((boolean)file.setReadOnly());
            Assertions.assertTrue((boolean)file.canRead());
            Assertions.assertFalse((boolean)file.canWrite());
            Assertions.assertTrue((boolean)file.delete());
        }
        destination = TempFile.create("test-", ".txt", new FileAttribute[0]);
        try {
            file = destination.toFile();
            Assertions.assertTrue((boolean)file.setReadOnly());
            Assertions.assertTrue((boolean)file.canRead());
            Assertions.assertFalse((boolean)file.canWrite());
            Assertions.assertTrue((boolean)file.exists(), (String)"File doesn't exist to delete");
            FileUtils.forceDelete(file);
            Assertions.assertFalse((boolean)file.exists(), (String)"Check deletion");
        }
        finally {
            if (destination != null) {
                destination.close();
            }
        }
    }

    @Test
    @EnabledOnOs(value={OS.MAC})
    public void testForceDeleteUnwritableDirectory() throws Exception {
        File dir;
        TempFile file;
        try (TempDirectory destDir = TempDirectory.create("dir-", new FileAttribute[0]);){
            file = TempFile.create(destDir, "test-", ".txt", new FileAttribute[0]);
            try {
                Assertions.assertTrue((boolean)Files.isDirectory(destDir.get(), new LinkOption[0]));
                Assertions.assertEquals((Object)destDir.get(), (Object)file.get().getParent());
                dir = destDir.toFile();
                Assertions.assertTrue((boolean)dir.canWrite());
                Assertions.assertTrue((boolean)dir.setWritable(false), () -> "setWritable(false) on " + dir);
                Assertions.assertFalse((boolean)dir.canWrite());
                Assertions.assertTrue((boolean)dir.canRead());
                Assertions.assertFalse((boolean)dir.delete());
                Assertions.assertFalse((boolean)file.toFile().delete());
                Assertions.assertTrue((boolean)dir.setWritable(true));
                Assertions.assertTrue((boolean)file.toFile().delete());
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        destDir = TempDirectory.create("dir-", new FileAttribute[0]);
        try {
            file = TempFile.create(destDir, "test-", ".txt", new FileAttribute[0]);
            try {
                Assertions.assertTrue((boolean)Files.isDirectory(destDir.get(), new LinkOption[0]));
                Assertions.assertEquals((Object)destDir.get(), (Object)file.get().getParent());
                dir = destDir.toFile();
                Assertions.assertTrue((boolean)dir.canWrite());
                Assertions.assertTrue((boolean)dir.setWritable(false));
                Assertions.assertFalse((boolean)dir.canWrite());
                Assertions.assertTrue((boolean)dir.canRead());
                Assertions.assertFalse((boolean)dir.delete());
                FileUtils.forceDelete(dir);
                Assertions.assertFalse((boolean)file.exists(new LinkOption[0]));
                Assertions.assertFalse((boolean)dir.exists());
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        finally {
            if (destDir != null) {
                destDir.close();
            }
        }
    }

    @Test
    public void testForceDeleteUnwritableFile() throws Exception {
        File file;
        try (TempFile destination = TempFile.create("test-", ".txt", new FileAttribute[0]);){
            file = destination.toFile();
            Assertions.assertTrue((boolean)file.canWrite());
            Assertions.assertTrue((boolean)file.setWritable(false));
            Assertions.assertFalse((boolean)file.canWrite());
            Assertions.assertTrue((boolean)file.canRead());
            Assertions.assertTrue((boolean)file.delete());
        }
        destination = TempFile.create("test-", ".txt", new FileAttribute[0]);
        try {
            file = destination.toFile();
            Assertions.assertTrue((boolean)file.canWrite());
            Assertions.assertTrue((boolean)file.setWritable(false));
            Assertions.assertFalse((boolean)file.canWrite());
            Assertions.assertTrue((boolean)file.canRead());
            Assertions.assertTrue((boolean)file.exists(), (String)"File doesn't exist to delete");
            FileUtils.forceDelete(file);
            Assertions.assertFalse((boolean)file.exists(), (String)"Check deletion");
        }
        finally {
            if (destination != null) {
                destination.close();
            }
        }
    }

    @Test
    public void testForceMkdir() throws Exception {
        FileUtils.forceMkdir(this.tempDirFile);
        File testFile = new File(this.tempDirFile, this.getName());
        testFile.createNewFile();
        Assertions.assertTrue((boolean)testFile.exists(), (String)"Test file does not exist.");
        Assertions.assertThrows(IOException.class, () -> FileUtils.forceMkdir(testFile));
        testFile.delete();
        FileUtils.forceMkdir(testFile);
        Assertions.assertTrue((boolean)testFile.exists(), (String)"Directory was not created.");
        FileUtils.forceMkdir(null);
    }

    @Test
    public void testForceMkdirParent() throws Exception {
        Assertions.assertTrue((boolean)this.tempDirFile.exists());
        File testParentDir = new File(this.tempDirFile, "testForceMkdirParent");
        testParentDir.delete();
        Assertions.assertFalse((boolean)testParentDir.exists());
        File testFile = new File(testParentDir, "test.txt");
        Assertions.assertFalse((boolean)testParentDir.exists());
        Assertions.assertFalse((boolean)testFile.exists());
        FileUtils.forceMkdirParent(testFile);
        Assertions.assertTrue((boolean)testParentDir.exists());
        Assertions.assertFalse((boolean)testFile.exists());
        FileUtils.forceMkdirParent(testFile);
        Assertions.assertTrue((boolean)testParentDir.exists());
        Assertions.assertFalse((boolean)testFile.exists());
    }

    @Test
    public void testGetFile() {
        File expected_A = new File("src");
        File expected_B = new File(expected_A, "main");
        File expected_C = new File(expected_B, "java");
        Assertions.assertEquals((Object)expected_A, (Object)FileUtils.getFile("src"), (String)"A");
        Assertions.assertEquals((Object)expected_B, (Object)FileUtils.getFile("src", "main"), (String)"B");
        Assertions.assertEquals((Object)expected_C, (Object)FileUtils.getFile("src", "main", "java"), (String)"C");
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.getFile((String[])null));
    }

    @Test
    public void testGetFile_Parent() {
        File parent = new File("parent");
        File expected_A = new File(parent, "src");
        File expected_B = new File(expected_A, "main");
        File expected_C = new File(expected_B, "java");
        Assertions.assertEquals((Object)expected_A, (Object)FileUtils.getFile(parent, "src"), (String)"A");
        Assertions.assertEquals((Object)expected_B, (Object)FileUtils.getFile(parent, "src", "main"), (String)"B");
        Assertions.assertEquals((Object)expected_C, (Object)FileUtils.getFile(parent, "src", "main", "java"), (String)"C");
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.getFile(parent, (String[])null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.getFile((File)null, "src"));
    }

    @Test
    public void testGetTempDirectory() {
        File tempDirectory = new File(FileUtils.getTempDirectoryPath());
        Assertions.assertEquals((Object)tempDirectory, (Object)FileUtils.getTempDirectory());
    }

    @Test
    public void testGetTempDirectoryPath() {
        Assertions.assertEquals((Object)SystemProperties.getJavaIoTmpdir(), (Object)FileUtils.getTempDirectoryPath());
    }

    @Test
    public void testGetUserDirectory() {
        File userDirectory = new File(SystemProperties.getUserHome());
        Assertions.assertEquals((Object)userDirectory, (Object)FileUtils.getUserDirectory());
    }

    @Test
    public void testGetUserDirectoryPath() {
        Assertions.assertEquals((Object)SystemProperties.getUserHome(), (Object)FileUtils.getUserDirectoryPath());
    }

    @Test
    public void testIO276() throws Exception {
        File dir = new File("target", "IO276");
        Files.deleteIfExists(dir.toPath());
        Assertions.assertTrue((boolean)dir.mkdirs(), (String)(dir + " should not be present"));
        File file = new File(dir, "IO276.txt");
        Assertions.assertTrue((boolean)file.createNewFile(), (String)(file + " should not be present"));
        FileUtils.forceDeleteOnExit(dir);
    }

    @Test
    public void testIO300() {
        File testDirectory = this.tempDirFile;
        File src = new File(testDirectory, "dir1");
        File dest = new File(src, "dir2");
        Assertions.assertTrue((boolean)dest.mkdirs());
        Assertions.assertTrue((boolean)src.exists());
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveDirectoryToDirectory(src, dest, false));
        Assertions.assertTrue((boolean)src.exists());
    }

    @Test
    public void testIO575() throws IOException {
        Path sourceDir = Files.createTempDirectory("source-dir", new FileAttribute[0]);
        String fileName = "some-file";
        Path sourceFile = Files.createFile(sourceDir.resolve("some-file"), new FileAttribute[0]);
        Assertions.assertEquals((Object)SystemUtils.IS_OS_WINDOWS, (Object)sourceFile.toFile().canExecute());
        sourceFile.toFile().setExecutable(true);
        Assertions.assertTrue((boolean)sourceFile.toFile().canExecute());
        Path destDir = Files.createTempDirectory("some-empty-destination", new FileAttribute[0]);
        FileUtils.copyDirectory(sourceDir.toFile(), destDir.toFile());
        Path destFile = destDir.resolve("some-file");
        Assertions.assertTrue((boolean)destFile.toFile().exists());
        Assertions.assertTrue((boolean)destFile.toFile().canExecute());
    }

    @Test
    public void testIsDirectory() throws IOException {
        File tempDirAsFile;
        Assertions.assertFalse((boolean)FileUtils.isDirectory(null, new LinkOption[0]));
        Assertions.assertTrue((boolean)FileUtils.isDirectory(this.tempDirFile, new LinkOption[0]));
        Assertions.assertFalse((boolean)FileUtils.isDirectory(this.testFile1, new LinkOption[0]));
        try (TempDirectory tempDir = TempDirectory.create(this.getClass().getCanonicalName(), new FileAttribute[0]);){
            tempDirAsFile = tempDir.toFile();
            Assertions.assertTrue((boolean)FileUtils.isDirectory(tempDirAsFile, new LinkOption[0]));
        }
        Assertions.assertFalse((boolean)FileUtils.isDirectory(tempDirAsFile, new LinkOption[0]));
    }

    @Test
    public void testIsEmptyDirectory() throws IOException {
        try (TempDirectory tempDir = TempDirectory.create(this.getClass().getCanonicalName(), new FileAttribute[0]);){
            File tempDirAsFile = tempDir.toFile();
            Assertions.assertTrue((boolean)FileUtils.isEmptyDirectory(tempDirAsFile));
        }
        Assertions.assertFalse((boolean)FileUtils.isEmptyDirectory(DIR_SIZE_1.toFile()));
    }

    @ParameterizedTest
    @ValueSource(longs={1L, 100L, 1000L, 10000L, 100000L, 1000000L})
    public void testIsFileNewerOlder(long millis) throws Exception {
        File oldFile = new File(this.tempDirFile, "FileUtils-old.txt");
        File refFile = new File(this.tempDirFile, "FileUtils-reference.txt");
        File newFile = new File(this.tempDirFile, "FileUtils-new.txt");
        File invalidFile = new File(this.tempDirFile, "FileUtils-invalid-file.txt");
        Path oldPath = oldFile.toPath();
        Path refPath = refFile.toPath();
        Path newPath = newFile.toPath();
        long actualMillis = SystemUtils.IS_OS_MAC && SystemUtils.IS_JAVA_1_8 ? millis + 1000L : millis;
        FileTime oldFileTime = FileTime.from(actualMillis * 1L, TimeUnit.MILLISECONDS);
        FileTime refFileTime = FileTime.from(actualMillis * 2L, TimeUnit.MILLISECONDS);
        FileTime testFileTime = FileTime.from(actualMillis * 3L, TimeUnit.MILLISECONDS);
        FileTime newFileTime = FileTime.from(actualMillis * 4L, TimeUnit.MILLISECONDS);
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(oldPath, new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Files.setLastModifiedTime(oldPath, oldFileTime);
        output = new BufferedOutputStream(Files.newOutputStream(refPath, new OpenOption[0]));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            ((OutputStream)output).close();
        }
        Files.setLastModifiedTime(refPath, refFileTime);
        Date date = new Date(testFileTime.toMillis());
        long now = date.getTime();
        Instant instant = date.toInstant();
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        OffsetDateTime offsetDateTime = zonedDateTime.toOffsetDateTime();
        LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
        LocalDate localDate = zonedDateTime.toLocalDate();
        LocalDate localDatePlusDay = localDate.plusDays(1L);
        LocalTime localTime0 = LocalTime.MIDNIGHT;
        OffsetTime offsetTime0 = OffsetTime.of(localTime0, ZoneOffset.UTC);
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(newPath, new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Files.setLastModifiedTime(newPath, newFileTime);
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, refFile), (String)"Old File - Newer - File");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, date), (String)"Old File - Newer - Date");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, now), (String)"Old File - Newer - Mili");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, instant), (String)"Old File - Newer - Instant");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, zonedDateTime), (String)"Old File - Newer - ZonedDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, offsetDateTime), (String)"Old File - Newer - OffsetDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, localDateTime), (String)"Old File - Newer - LocalDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, localDateTime, ZoneId.systemDefault()), (String)"Old File - Newer - LocalDateTime,ZoneId");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, localDate), (String)"Old File - Newer - LocalDate");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(oldFile, (ChronoLocalDate)localDate, localTime0), (String)"Old File - Newer - LocalDate,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(oldFile, (ChronoLocalDate)localDate, offsetTime0), (String)"Old File - Newer - LocalDate,OffsetTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, localDatePlusDay), (String)"Old File - Newer - LocalDate plus one day");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, (ChronoLocalDate)localDatePlusDay, localTime0), (String)"Old File - Newer - LocalDate plus one day,LocalTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(oldFile, (ChronoLocalDate)localDatePlusDay, offsetTime0), (String)"Old File - Newer - LocalDate plus one day,OffsetTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(newFile, refFile), (String)"New File - Newer - File");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(newFile, date), (String)"New File - Newer - Date");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(newFile, now), (String)"New File - Newer - Mili");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(newFile, instant), (String)"New File - Newer - Instant");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(newFile, zonedDateTime), (String)"New File - Newer - ZonedDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(newFile, offsetDateTime), (String)"New File - Newer - OffsetDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(newFile, localDateTime), (String)"New File - Newer - LocalDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(newFile, localDateTime, ZoneId.systemDefault()), (String)"New File - Newer - LocalDateTime,ZoneId");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(newFile, localDate), (String)"New File - Newer - LocalDate");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(newFile, (ChronoLocalDate)localDate, localTime0), (String)"New File - Newer - LocalDate,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer(newFile, (ChronoLocalDate)localDate, offsetTime0), (String)"New File - Newer - LocalDate,OffsetTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(newFile, localDatePlusDay), (String)"New File - Newer - LocalDate plus one day");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(newFile, (ChronoLocalDate)localDatePlusDay, localTime0), (String)"New File - Newer - LocalDate plus one day,LocalTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(newFile, (ChronoLocalDate)localDatePlusDay, offsetTime0), (String)"New File - Newer - LocalDate plus one day,OffsetTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer(invalidFile, refFile), (String)"Illegal - Newer - File");
        Assertions.assertThrows(UncheckedIOException.class, () -> FileUtils.isFileNewer(newFile, invalidFile));
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, refFile), (String)"Old File - Older - File");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, date), (String)"Old File - Older - Date");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, now), (String)"Old File - Older - Mili");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, instant), (String)"Old File - Older - Instant");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, zonedDateTime), (String)"Old File - Older - ZonedDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, offsetDateTime), (String)"Old File - Older - OffsetDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, localDateTime), (String)"Old File - Older - LocalDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, localDateTime, ZoneId.systemDefault()), (String)"Old File - Older - LocalDateTime,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, localDate), (String)"Old File - Older - LocalDate");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(oldFile, (ChronoLocalDate)localDate, localTime0), (String)"Old File - Older - LocalDate,LocalTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(oldFile, (ChronoLocalDate)localDate, offsetTime0), (String)"Old File - Older - LocalDate,OffsetTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, localDatePlusDay), (String)"Old File - Older - LocalDate plus one day");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, (ChronoLocalDate)localDatePlusDay, localTime0), (String)"Old File - Older - LocalDate plus one day,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(oldFile, (ChronoLocalDate)localDatePlusDay, offsetTime0), (String)"Old File - Older - LocalDate plus one day,OffsetTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(newFile, refFile), (String)"New File - Older - File");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(newFile, date), (String)"New File - Older - Date");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(newFile, now), (String)"New File - Older - Mili");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(newFile, instant), (String)"New File - Older - Instant");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(newFile, zonedDateTime), (String)"New File - Older - ZonedDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(newFile, offsetDateTime), (String)"New File - Older - OffsetDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(newFile, localDateTime), (String)"New File - Older - LocalDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(newFile, localDateTime, ZoneId.systemDefault()), (String)"New File - Older - LocalDateTime,ZoneId");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(newFile, localDate), (String)"New File - Older - LocalDate");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(newFile, (ChronoLocalDate)localDate, localTime0), (String)"New File - Older - LocalDate,LocalTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(newFile, (ChronoLocalDate)localDate, offsetTime0), (String)"New File - Older - LocalDate,OffsetTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(newFile, localDatePlusDay), (String)"New File - Older - LocalDate plus one day");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(newFile, (ChronoLocalDate)localDatePlusDay, localTime0), (String)"New File - Older - LocalDate plus one day,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder(newFile, (ChronoLocalDate)localDatePlusDay, offsetTime0), (String)"New File - Older - LocalDate plus one day,OffsetTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder(invalidFile, refFile), (String)"Illegal - Older - File");
        Assertions.assertThrows(UncheckedIOException.class, () -> FileUtils.isFileOlder(newFile, invalidFile));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer(null, now));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer(oldFile, (File)null));
        Assertions.assertThrows(UncheckedIOException.class, () -> FileUtils.isFileNewer(oldFile, invalidFile));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer(oldFile, (Date)null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileOlder(null, now));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileOlder(oldFile, (File)null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileOlder(oldFile, (Date)null));
        Assertions.assertThrows(UncheckedIOException.class, () -> FileUtils.isFileOlder(oldFile, invalidFile));
    }

    @Test
    public void testIsRegularFile() throws IOException {
        Assertions.assertFalse((boolean)FileUtils.isRegularFile(null, new LinkOption[0]));
        Assertions.assertFalse((boolean)FileUtils.isRegularFile(this.tempDirFile, new LinkOption[0]));
        Assertions.assertTrue((boolean)FileUtils.isRegularFile(this.testFile1, new LinkOption[0]));
        Files.delete(this.testFile1.toPath());
        Assertions.assertFalse((boolean)FileUtils.isRegularFile(this.testFile1, new LinkOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIterateFiles() throws Exception {
        File srcDir = this.tempDirFile;
        File subDir = new File(srcDir, "list_test");
        File subSubDir = new File(subDir, "subSubDir");
        File notSubSubDir = new File(subDir, "notSubSubDir");
        Assertions.assertTrue((boolean)subDir.mkdir());
        Assertions.assertTrue((boolean)subSubDir.mkdir());
        Assertions.assertTrue((boolean)notSubSubDir.mkdir());
        Iterator<File> iterator = null;
        try {
            ArrayList<String> expectedFileNames = new ArrayList<String>(Arrays.asList("a.txt", "b.txt", "c.txt", "d.txt", "e.txt", "f.txt"));
            int[] fileSizes = new int[]{123, 234, 345, 456, 678, 789};
            Assertions.assertEquals((int)expectedFileNames.size(), (int)fileSizes.length);
            Collections.sort(expectedFileNames);
            Arrays.sort(fileSizes);
            for (int i = 0; i < fileSizes.length; ++i) {
                TestUtils.generateTestData(new File(subDir, (String)expectedFileNames.get(i)), (long)fileSizes[i]);
            }
            String subSubFileName = "z.txt";
            TestUtils.generateTestData(new File(subSubDir, "z.txt"), 1L);
            expectedFileNames.add("z.txt");
            String notSubSubFileName = "not.txt";
            TestUtils.generateTestData(new File(notSubSubDir, "not.txt"), 1L);
            WildcardFileFilter allFilesFileFilter = WildcardFileFilter.builder().setWildcards("*.*").get();
            NameFileFilter dirFilter = new NameFileFilter("subSubDir");
            iterator = FileUtils.iterateFiles(subDir, allFilesFileFilter, dirFilter);
            HashMap<String, String> matchedFileNames = new HashMap<String, String>();
            ArrayList<String> actualFileNames = new ArrayList<String>();
            while (iterator.hasNext()) {
                boolean found = false;
                String fileName = iterator.next().getName();
                actualFileNames.add(fileName);
                for (int j = 0; !found && j < expectedFileNames.size(); ++j) {
                    String expectedFileName = (String)expectedFileNames.get(j);
                    if (!expectedFileName.equals(fileName)) continue;
                    matchedFileNames.put(expectedFileName, expectedFileName);
                    found = true;
                }
            }
            Assertions.assertEquals((int)expectedFileNames.size(), (int)matchedFileNames.size());
            Collections.sort(actualFileNames);
            Assertions.assertEquals(expectedFileNames, actualFileNames);
        }
        finally {
            this.consumeRemaining(iterator);
            notSubSubDir.delete();
            subSubDir.delete();
            subDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIterateFilesAndDirs() throws IOException {
        File srcDir = this.tempDirFile;
        File subDir1 = new File(srcDir, "subdir1");
        File subDir2 = new File(subDir1, "subdir2");
        File subDir3 = new File(subDir2, "subdir3");
        File subDir4 = new File(subDir2, "subdir4");
        Assertions.assertTrue((boolean)subDir1.mkdir());
        Assertions.assertTrue((boolean)subDir2.mkdir());
        Assertions.assertTrue((boolean)subDir3.mkdir());
        Assertions.assertTrue((boolean)subDir4.mkdir());
        File someFile = new File(subDir2, "a.txt");
        WildcardFileFilter fileFilterAllFiles = WildcardFileFilter.builder().setWildcards("*.*").get();
        WildcardFileFilter fileFilterAllDirs = WildcardFileFilter.builder().setWildcards("*").get();
        WildcardFileFilter fileFilterExtTxt = WildcardFileFilter.builder().setWildcards("*.txt").get();
        try {
            try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(someFile.toPath(), new OpenOption[0]));){
                TestUtils.generateTestData(output, 100L);
            }
            List<File> expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile, subDir3, subDir4);
            this.iterateFilesAndDirs(subDir1, fileFilterAllFiles, fileFilterAllDirs, expectedFilesAndDirs);
            expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile, subDir3, subDir4);
            this.iterateFilesAndDirs(subDir1, fileFilterExtTxt, fileFilterAllDirs, expectedFilesAndDirs);
            expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile);
            this.iterateFilesAndDirs(subDir1, fileFilterAllFiles, new NameFileFilter("subdir2"), expectedFilesAndDirs);
            expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile);
            this.iterateFilesAndDirs(subDir1, fileFilterExtTxt, new NameFileFilter("subdir2"), expectedFilesAndDirs);
        }
        finally {
            someFile.delete();
            subDir4.delete();
            subDir3.delete();
            subDir2.delete();
            subDir1.delete();
        }
    }

    @Test
    public void testIterateFilesOnlyNoDirs() throws IOException {
        File directory = this.tempDirFile;
        Assertions.assertTrue((boolean)new File(directory, "TEST").mkdir());
        Assertions.assertTrue((boolean)new File(directory, "test.txt").createNewFile());
        WildcardFileFilter filter = WildcardFileFilter.builder().setWildcards("*").setIoCase(IOCase.INSENSITIVE).get();
        FileUtils.iterateFiles(directory, filter, null).forEachRemaining(file -> Assertions.assertFalse((boolean)file.isDirectory(), file::getAbsolutePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListFiles() throws Exception {
        File srcDir = this.tempDirFile;
        File subDir = new File(srcDir, "list_test");
        File subDir2 = new File(subDir, "subdir");
        subDir.mkdir();
        subDir2.mkdir();
        try {
            String[] expectedFileNames = new String[]{"a.txt", "b.txt", "c.txt", "d.txt", "e.txt", "f.txt"};
            int[] fileSizes = new int[]{123, 234, 345, 456, 678, 789};
            for (int i = 0; i < expectedFileNames.length; ++i) {
                File theFile = new File(subDir, expectedFileNames[i]);
                if (!theFile.getParentFile().exists()) {
                    Assertions.fail((String)("Cannot create file " + theFile + " as the parent directory does not exist"));
                }
                try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(theFile.toPath(), new OpenOption[0]));){
                    TestUtils.generateTestData(output, (long)fileSizes[i]);
                    continue;
                }
            }
            Collection<File> actualFiles = FileUtils.listFiles(subDir, WildcardFileFilter.builder().setWildcards("*.*").get(), WildcardFileFilter.builder().setWildcards("*").get());
            int count = actualFiles.size();
            Object[] fileObjs = actualFiles.toArray();
            Assertions.assertEquals((int)expectedFileNames.length, (int)actualFiles.size(), actualFiles::toString);
            HashMap<String, String> foundFileNames = new HashMap<String, String>();
            for (int i = 0; i < count; ++i) {
                boolean found = false;
                for (int j = 0; !found && j < expectedFileNames.length; ++j) {
                    if (!expectedFileNames[j].equals(((File)fileObjs[i]).getName())) continue;
                    foundFileNames.put(expectedFileNames[j], expectedFileNames[j]);
                    found = true;
                }
            }
            Assertions.assertEquals((int)foundFileNames.size(), (int)expectedFileNames.length, foundFileNames::toString);
        }
        finally {
            subDir.delete();
        }
    }

    @Test
    public void testListFilesOnlyNoDirs() throws IOException {
        File directory = this.tempDirFile;
        Assertions.assertTrue((boolean)new File(directory, "TEST").mkdir());
        Assertions.assertTrue((boolean)new File(directory, "test.txt").createNewFile());
        WildcardFileFilter filter = WildcardFileFilter.builder().setWildcards("*").setIoCase(IOCase.INSENSITIVE).get();
        for (File file : FileUtils.listFiles(directory, filter, null)) {
            Assertions.assertFalse((boolean)file.isDirectory(), file::getAbsolutePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListFilesWithDirs() throws IOException {
        File srcDir = this.tempDirFile;
        File subDir1 = new File(srcDir, "subdir");
        File subDir2 = new File(subDir1, "subdir2");
        subDir1.mkdir();
        subDir2.mkdir();
        try {
            File someFile = new File(subDir2, "a.txt");
            if (!someFile.getParentFile().exists()) {
                Assertions.fail((String)("Cannot create file " + someFile + " as the parent directory does not exist"));
            }
            try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(someFile.toPath(), new OpenOption[0]));){
                TestUtils.generateTestData(output, 100L);
            }
            File subDir3 = new File(subDir2, "subdir3");
            subDir3.mkdir();
            Collection<File> files = FileUtils.listFilesAndDirs(subDir1, WildcardFileFilter.builder().setWildcards("*.*").get(), WildcardFileFilter.builder().setWildcards("*").get());
            Assertions.assertEquals((int)4, (int)files.size());
            Assertions.assertTrue((boolean)files.contains(subDir1), (String)"Should contain the directory.");
            Assertions.assertTrue((boolean)files.contains(subDir2), (String)"Should contain the directory.");
            Assertions.assertTrue((boolean)files.contains(someFile), (String)"Should contain the file.");
            Assertions.assertTrue((boolean)files.contains(subDir3), (String)"Should contain the directory.");
        }
        finally {
            subDir1.delete();
        }
    }

    @Test
    public void testMoveDirectory_CopyDelete() throws Exception {
        File dir = this.tempDirFile;
        File src = new File(dir, "testMoveDirectory2Source"){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File dest) {
                return false;
            }
        };
        File testDir = new File(src, "foo");
        File testFile = new File(testDir, "bar");
        testDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        File destination = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory(destination);
        FileUtils.moveDirectory(src, destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        File movedDir = new File(destination, testDir.getName());
        File movedFile = new File(movedDir, testFile.getName());
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check dir moved");
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check file moved");
    }

    @Test
    public void testMoveDirectory_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectory(null, new File("foo")));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectory(new File("foo"), null));
        Assertions.assertThrows(FileNotFoundException.class, () -> FileUtils.moveDirectory(new File("non-existent"), new File("foo")));
        File testFile = new File(this.tempDirFile, "testMoveDirectoryFile");
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.moveDirectory(testFile, new File("foo")));
        File testSrcFile = new File(this.tempDirFile, "testMoveDirectorySource");
        File testDestFile = new File(this.tempDirFile, "testMoveDirectoryDest");
        testSrcFile.mkdir();
        testDestFile.mkdir();
        Assertions.assertThrows(FileExistsException.class, () -> FileUtils.moveDirectory(testSrcFile, testDestFile), (String)"Expected FileExistsException when dest already exists");
    }

    @Test
    public void testMoveDirectory_Rename() throws Exception {
        File dir = this.tempDirFile;
        File src = new File(dir, "testMoveDirectory1Source");
        File testDir = new File(src, "foo");
        File testFile = new File(testDir, "bar");
        testDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        File destination = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory(destination);
        FileUtils.moveDirectory(src, destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        File movedDir = new File(destination, testDir.getName());
        File movedFile = new File(movedDir, testFile.getName());
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check dir moved");
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check file moved");
    }

    @Test
    public void testMoveDirectoryToDirectory() throws Exception {
        File dir = this.tempDirFile;
        File src = new File(dir, "testMoveDirectory1Source");
        File testChildDir = new File(src, "foo");
        File testFile = new File(testChildDir, "bar");
        testChildDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        File destDir = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory(destDir);
        Assertions.assertFalse((boolean)destDir.exists(), (String)"Check Exist before");
        FileUtils.moveDirectoryToDirectory(src, destDir, true);
        Assertions.assertTrue((boolean)destDir.exists(), (String)"Check Exist after");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        File movedDir = new File(destDir, src.getName());
        File movedChildDir = new File(movedDir, testChildDir.getName());
        File movedFile = new File(movedChildDir, testFile.getName());
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check dir moved");
        Assertions.assertTrue((boolean)movedChildDir.exists(), (String)"Check child dir moved");
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check file moved");
    }

    @Test
    public void testMoveDirectoryToDirectory_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectoryToDirectory(null, new File("foo"), true));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectoryToDirectory(new File("foo"), null, true));
        File testFile1 = new File(this.tempDirFile, "testMoveFileFile1");
        File testFile2 = new File(this.tempDirFile, "testMoveFileFile2");
        if (!testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 0L);
        }
        if (!testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile2 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile2.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 0L);
        }
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveDirectoryToDirectory(testFile1, testFile2, true));
        File nonExistent = new File(this.tempDirFile, "testMoveFileNonExistent");
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveDirectoryToDirectory(testFile1, nonExistent, false));
    }

    @Test
    public void testMoveFile_CopyDelete() throws Exception {
        File destination = new File(this.tempDirFile, "move2.txt");
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        FileUtils.moveFile(src, destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
    }

    @Test
    public void testMoveFile_CopyDelete_Failed() {
        File destination = new File(this.tempDirFile, "move3.txt");
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean delete() {
                return false;
            }

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveFile(src, destination));
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check Rollback");
        Assertions.assertTrue((boolean)src.exists(), (String)"Original exists");
    }

    @Test
    public void testMoveFile_CopyDelete_WithFileDatePreservation() throws Exception {
        File destination = new File(this.tempDirFile, "move2.txt");
        this.backDateFile10Minutes(this.testFile1);
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        long expected = this.getLastModifiedMillis(this.testFile1);
        FileUtils.moveFile(src, destination, StandardCopyOption.COPY_ATTRIBUTES);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        long destLastMod = this.getLastModifiedMillis(destination);
        long delta = destLastMod - expected;
        Assertions.assertEquals((long)expected, (long)destLastMod, (String)("Check last modified date same as input, delta " + delta));
    }

    @Test
    public void testMoveFile_CopyDelete_WithoutFileDatePreservation() throws Exception {
        File destination = new File(this.tempDirFile, "move2.txt");
        this.backDateFile10Minutes(this.testFile1);
        long nowMillis = System.currentTimeMillis() - 1000L;
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        long unexpectedMillis = this.getLastModifiedMillis(this.testFile1);
        FileUtils.moveFile(src, destination, PathUtils.EMPTY_COPY_OPTIONS);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        if (!SystemUtils.IS_OS_WINDOWS) {
            long destLastModMillis = this.getLastModifiedMillis(destination);
            long deltaMillis = destLastModMillis - unexpectedMillis;
            Assertions.assertNotEquals((long)unexpectedMillis, (long)destLastModMillis, (String)("Check last modified date not same as input, delta " + deltaMillis));
            Assertions.assertTrue((destLastModMillis > nowMillis ? 1 : 0) != 0, (String)(destLastModMillis + " > " + nowMillis + " (delta " + deltaMillis + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveFile_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFile(null, new File("foo")));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFile(new File("foo"), null));
        Assertions.assertThrows(FileNotFoundException.class, () -> FileUtils.moveFile(new File("non-existent"), new File("foo")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.moveFile(this.tempDirFile, new File("foo")));
        File testSourceFile = new File(this.tempDirFile, "testMoveFileSource");
        File testDestFile = new File(this.tempDirFile, "testMoveFileSource");
        if (!testSourceFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testSourceFile + " as the parent directory does not exist"));
        }
        BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(testSourceFile.toPath(), new OpenOption[0]));
        try {
            TestUtils.generateTestData(output1, 0L);
        }
        finally {
            IOUtils.closeQuietly(output1);
        }
        Assertions.assertTrue((boolean)testDestFile.getParentFile().exists(), () -> "Cannot create file " + testDestFile + " as the parent directory does not exist");
        BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testDestFile.toPath(), new OpenOption[0]));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly(output);
        }
        Assertions.assertThrows(FileExistsException.class, () -> FileUtils.moveFile(testSourceFile, testDestFile), (String)"Expected FileExistsException when dest already exists");
    }

    @Test
    public void testMoveFile_Rename() throws Exception {
        File destination = new File(this.tempDirFile, "move1.txt");
        FileUtils.moveFile(this.testFile1, destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)this.testFile1.exists(), (String)"Original deleted");
    }

    @Test
    public void testMoveFileToDirectory() throws Exception {
        File destDir = new File(this.tempDirFile, "moveFileDestDir");
        File movedFile = new File(destDir, this.testFile1.getName());
        Assertions.assertFalse((boolean)destDir.exists(), (String)"Check Exist before");
        Assertions.assertFalse((boolean)movedFile.exists(), (String)"Check Exist before");
        FileUtils.moveFileToDirectory(this.testFile1, destDir, true);
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check Exist after");
        Assertions.assertFalse((boolean)this.testFile1.exists(), (String)"Original deleted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveFileToDirectory_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFileToDirectory(null, new File("foo"), true));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFileToDirectory(new File("foo"), null, true));
        File testFile1 = new File(this.tempDirFile, "testMoveFileFile1");
        File testFile2 = new File(this.tempDirFile, "testMoveFileFile2");
        if (!testFile1.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile1 + " as the parent directory does not exist"));
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(testFile1.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output1, 0L);
        }
        if (!testFile2.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile2 + " as the parent directory does not exist"));
        }
        BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile2.toPath(), new OpenOption[0]));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly(output);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.moveFileToDirectory(testFile1, testFile2, true));
        File nonExistent = new File(this.tempDirFile, "testMoveFileNonExistent");
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveFileToDirectory(testFile1, nonExistent, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveToDirectory() throws Exception {
        File destDir = new File(this.tempDirFile, "testMoveToDirectoryDestDir");
        File testDir = new File(this.tempDirFile, "testMoveToDirectoryTestDir");
        File testFile = new File(this.tempDirFile, "testMoveToDirectoryTestFile");
        testDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            Assertions.fail((String)("Cannot create file " + testFile + " as the parent directory does not exist"));
        }
        BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(testFile.toPath(), new OpenOption[0]));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly(output);
        }
        File movedFile = new File(destDir, testFile.getName());
        File movedDir = new File(destDir, testFile.getName());
        Assertions.assertFalse((boolean)movedFile.exists(), (String)"Check File Doesnt exist");
        Assertions.assertFalse((boolean)movedDir.exists(), (String)"Check Dir Doesnt exist");
        FileUtils.moveToDirectory(testFile, destDir, true);
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check File exists");
        Assertions.assertFalse((boolean)testFile.exists(), (String)"Check Original File doesn't exist");
        FileUtils.moveToDirectory(testDir, destDir, true);
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check Dir exists");
        Assertions.assertFalse((boolean)testDir.exists(), (String)"Check Original Dir doesn't exist");
    }

    @Test
    public void testMoveToDirectory_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectoryToDirectory(null, new File("foo"), true));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectoryToDirectory(new File("foo"), null, true));
        File nonExistent = new File(this.tempDirFile, "non-existent");
        File destDir = new File(this.tempDirFile, "MoveToDirectoryDestDir");
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveToDirectory(nonExistent, destDir, true), (String)"Expected IOException when source does not exist");
    }

    @Test
    public void testReadFileToByteArray() throws Exception {
        File file = new File(this.tempDirFile, "read.txt");
        Files.write(file.toPath(), new byte[]{11, 21, 31}, new OpenOption[0]);
        byte[] data = FileUtils.readFileToByteArray(file);
        Assertions.assertEquals((int)3, (int)data.length);
        Assertions.assertEquals((int)11, (int)data[0]);
        Assertions.assertEquals((int)21, (int)data[1]);
        Assertions.assertEquals((int)31, (int)data[2]);
    }

    @Test
    public void testReadFileToByteArray_Errors() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.readFileToByteArray(null));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToByteArray(new File("non-exsistent")));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToByteArray(this.tempDirFile));
    }

    @Test
    @EnabledIf(value="isPosixFilePermissionsSupported")
    public void testReadFileToByteArray_IOExceptionOnPosixFileSystem() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "cant-read.txt");
        TestUtils.createFile(file, 100L);
        Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString("---------"));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToByteArray(file));
    }

    @Test
    public void testReadFileToString_Errors() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.readFileToString(null));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToString(new File("non-exsistent")));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToString(this.tempDirFile));
        Assertions.assertThrows(UnsupportedCharsetException.class, () -> FileUtils.readFileToString(this.tempDirFile, "unsupported-charset"));
    }

    @Test
    @EnabledIf(value="isPosixFilePermissionsSupported")
    public void testReadFileToString_IOExceptionOnPosixFileSystem() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "cant-read.txt");
        TestUtils.createFile(file, 100L);
        Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString("---------"));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readFileToString(file));
    }

    @Test
    public void testReadFileToStringWithDefaultEncoding() throws Exception {
        File file = new File(this.tempDirFile, "read.obj");
        String fixture = "Hello /u1234";
        Files.write(file.toPath(), "Hello /u1234".getBytes(), new OpenOption[0]);
        Assertions.assertEquals((Object)"Hello /u1234", (Object)FileUtils.readFileToString(file));
    }

    @Test
    public void testReadFileToStringWithEncoding() throws Exception {
        File file = new File(this.tempDirFile, "read.obj");
        byte[] text = "Hello /u1234".getBytes(StandardCharsets.UTF_8);
        Files.write(file.toPath(), text, new OpenOption[0]);
        String data = FileUtils.readFileToString(file, "UTF8");
        Assertions.assertEquals((Object)"Hello /u1234", (Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        try {
            String[] data = new String[]{"hello", "/u1234", "", "this is", "some text"};
            TestUtils.createLineBasedFile(file, data);
            List<String> lines = FileUtils.readLines(file, UTF_8);
            Assertions.assertEquals(Arrays.asList(data), lines);
        }
        finally {
            TestUtils.deleteFile(file);
        }
    }

    @Test
    public void testReadLines_Errors() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.readLines(null));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readLines(new File("non-exsistent")));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readLines(this.tempDirFile));
        Assertions.assertThrows(UnsupportedCharsetException.class, () -> FileUtils.readLines(this.tempDirFile, "unsupported-charset"));
    }

    @Test
    @EnabledIf(value="isPosixFilePermissionsSupported")
    public void testReadLines_IOExceptionOnPosixFileSystem() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "cant-read.txt");
        TestUtils.createFile(file, 100L);
        Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString("---------"));
        Assertions.assertThrows(IOException.class, () -> FileUtils.readLines(file));
    }

    @Test
    public void testSizeOf() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.sizeOf(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.sizeOf(file));
        file.createNewFile();
        Assertions.assertEquals((long)0L, (long)FileUtils.sizeOf(file));
        file.delete();
        Assertions.assertEquals((long)this.testFile1Size, (long)FileUtils.sizeOf(this.testFile1), (String)"Unexpected files size");
        Assertions.assertEquals((long)0L, (long)FileUtils.sizeOf(this.tempDirFile), (String)"Unexpected directory size");
    }

    @Test
    public void testSizeOfAsBigInteger() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.sizeOfAsBigInteger(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.sizeOfAsBigInteger(file));
        file.createNewFile();
        Assertions.assertEquals((Object)BigInteger.ZERO, (Object)FileUtils.sizeOfAsBigInteger(file));
        file.delete();
        Assertions.assertEquals((Object)BigInteger.valueOf(this.testFile1Size), (Object)FileUtils.sizeOfAsBigInteger(this.testFile1), (String)"Unexpected files size");
        Assertions.assertEquals((Object)TEST_DIRECTORY_SIZE_BI, (Object)FileUtils.sizeOfAsBigInteger(this.tempDirFile), (String)"Unexpected directory size");
    }

    @Test
    public void testSizeOfDirectory() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.sizeOfDirectory(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.sizeOfAsBigInteger(file));
        file.createNewFile();
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.sizeOfDirectory(file));
        file.delete();
        file.mkdir();
        this.createCircularSymbolicLink(file);
        Assertions.assertEquals((long)0L, (long)FileUtils.sizeOfDirectory(file), (String)"Unexpected directory size");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSizeOfDirectoryAsBigInteger() throws Exception {
        File file = new File(this.tempDirFile, this.getName());
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.sizeOfDirectoryAsBigInteger(null));
        Assertions.assertThrows(UncheckedIOException.class, () -> FileUtils.sizeOfDirectoryAsBigInteger(file));
        file.createNewFile();
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.sizeOfDirectoryAsBigInteger(file));
        file.delete();
        file.mkdir();
        this.createCircularSymbolicLink(file);
        Assertions.assertEquals((Object)TEST_DIRECTORY_SIZE_BI, (Object)FileUtils.sizeOfDirectoryAsBigInteger(file), (String)"Unexpected directory size");
        file.delete();
        file.mkdir();
        File nonEmptyFile = new File(file, "non-emptyFile" + System.nanoTime());
        Assertions.assertTrue((boolean)nonEmptyFile.getParentFile().exists(), () -> "Cannot create file " + nonEmptyFile + " as the parent directory does not exist");
        BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(nonEmptyFile.toPath(), new OpenOption[0]));
        try {
            TestUtils.generateTestData(output, TEST_DIRECTORY_SIZE_GT_ZERO_BI.longValue());
        }
        finally {
            IOUtils.closeQuietly(output);
        }
        Assertions.assertEquals((Object)TEST_DIRECTORY_SIZE_GT_ZERO_BI, (Object)FileUtils.sizeOfDirectoryAsBigInteger(file), (String)"Unexpected directory size");
        nonEmptyFile.delete();
        file.delete();
    }

    @Test
    public void testToFile1() throws Exception {
        URL url = new URL("file", null, "a/b/c/file.txt");
        File file = FileUtils.toFile(url);
        Assertions.assertTrue((boolean)file.toString().contains("file.txt"));
    }

    @Test
    public void testToFile2() throws Exception {
        URL url = new URL("file", null, "a/b/c/file%20n%61me%2520.tx%74");
        File file = FileUtils.toFile(url);
        Assertions.assertTrue((boolean)file.toString().contains("file name%20.txt"));
    }

    @Test
    public void testToFile3() throws Exception {
        Assertions.assertNull((Object)FileUtils.toFile(null));
        Assertions.assertNull((Object)FileUtils.toFile(new URL("http://jakarta.apache.org")));
    }

    @Test
    public void testToFile4() throws Exception {
        URL url = new URL("file", null, "a/b/c/file%%20%me.txt%");
        File file = FileUtils.toFile(url);
        Assertions.assertTrue((boolean)file.toString().contains("file% %me.txt%"));
    }

    @Test
    public void testToFile5() throws Exception {
        URL url = new URL("file", null, "both%20are%20100%20%25%20true");
        File file = FileUtils.toFile(url);
        Assertions.assertEquals((Object)"both are 100 % true", (Object)file.toString());
    }

    @Test
    public void testToFiles1() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), new URL("file", null, "file2.txt")};
        File[] files = FileUtils.toFiles(urls);
        Assertions.assertEquals((int)urls.length, (int)files.length);
        Assertions.assertTrue((boolean)files[0].toString().contains("file1.txt"), (String)("File: " + files[0]));
        Assertions.assertTrue((boolean)files[1].toString().contains("file2.txt"), (String)("File: " + files[1]));
    }

    @Test
    public void testToFiles2() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), null};
        File[] files = FileUtils.toFiles(urls);
        Assertions.assertEquals((int)urls.length, (int)files.length);
        Assertions.assertTrue((boolean)files[0].toString().contains("file1.txt"), (String)("File: " + files[0]));
        Assertions.assertNull((Object)files[1], (String)("File: " + files[1]));
    }

    @Test
    public void testToFiles3() throws Exception {
        URL[] urls = null;
        File[] files = FileUtils.toFiles(urls);
        Assertions.assertEquals((int)0, (int)files.length);
    }

    @Test
    public void testToFiles3a() throws Exception {
        URL[] urls = new URL[]{};
        File[] files = FileUtils.toFiles(urls);
        Assertions.assertEquals((int)0, (int)files.length);
    }

    @Test
    public void testToFiles4() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), new URL("http", "jakarta.apache.org", "file1.txt")};
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.toFiles(urls));
    }

    @Test
    public void testToFileUtf8() throws Exception {
        URL url = new URL("file", null, "/home/%C3%A4%C3%B6%C3%BC%C3%9F");
        File file = FileUtils.toFile(url);
        Assertions.assertTrue((boolean)file.toString().contains("\u00e4\u00f6\u00fc\u00df"));
    }

    @Test
    public void testTouch() throws IOException {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.touch(null));
        File file = new File(this.tempDirFile, "touch.txt");
        if (file.exists()) {
            file.delete();
        }
        Assertions.assertFalse((boolean)file.exists(), (String)"Bad test: test file still exists");
        FileUtils.touch(file);
        Assertions.assertTrue((boolean)file.exists(), (String)"FileUtils.touch() created file");
        try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            Assertions.assertEquals((long)0L, (long)file.length(), (String)"Created empty file.");
            out.write(0);
        }
        Assertions.assertEquals((long)1L, (long)file.length(), (String)"Wrote one byte to file");
        long y2k = new GregorianCalendar(2000, 0, 1).getTime().getTime();
        boolean res = this.setLastModifiedMillis(file, y2k);
        Assertions.assertTrue((boolean)res, (String)"Bad test: set lastModified failed");
        Assertions.assertEquals((long)y2k, (long)this.getLastModifiedMillis(file), (String)"Bad test: set lastModified set incorrect value");
        long nowMillis = System.currentTimeMillis();
        FileUtils.touch(file);
        Assertions.assertEquals((long)1L, (long)file.length(), (String)"FileUtils.touch() didn't empty the file.");
        Assertions.assertNotEquals((long)y2k, (long)this.getLastModifiedMillis(file), (String)"FileUtils.touch() changed lastModified");
        int delta = 3000;
        Assertions.assertTrue((this.getLastModifiedMillis(file) >= nowMillis - 3000L ? 1 : 0) != 0, (String)"FileUtils.touch() changed lastModified to more than now-3s");
        Assertions.assertTrue((this.getLastModifiedMillis(file) <= nowMillis + 3000L ? 1 : 0) != 0, (String)"FileUtils.touch() changed lastModified to less than now+3s");
    }

    @Test
    public void testTouchDirDoesNotExist() throws Exception {
        File file = new File("target/does-not-exist", "touchme.txt");
        File parentDir = file.getParentFile();
        file.delete();
        parentDir.delete();
        Assertions.assertFalse((boolean)parentDir.exists());
        Assertions.assertFalse((boolean)file.exists());
        FileUtils.touch(file);
        Assertions.assertTrue((boolean)parentDir.exists());
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    public void testToURLs1() throws Exception {
        File[] files = new File[]{new File(this.tempDirFile, "file1.txt"), new File(this.tempDirFile, "file2.txt"), new File(this.tempDirFile, "test file.txt")};
        URL[] urls = FileUtils.toURLs(files);
        Assertions.assertEquals((int)files.length, (int)urls.length);
        Assertions.assertTrue((boolean)urls[0].toExternalForm().startsWith("file:"));
        Assertions.assertTrue((boolean)urls[0].toExternalForm().contains("file1.txt"));
        Assertions.assertTrue((boolean)urls[1].toExternalForm().startsWith("file:"));
        Assertions.assertTrue((boolean)urls[1].toExternalForm().contains("file2.txt"));
        Assertions.assertTrue((boolean)urls[2].toExternalForm().startsWith("file:"));
        Assertions.assertTrue((boolean)urls[2].toExternalForm().contains("test%20file.txt"));
    }

    @Test
    public void testToURLs2() {
        File[] files = new File[]{new File(this.tempDirFile, "file1.txt"), null};
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.toURLs(files), (String)"Can't convert null URL");
    }

    @Test
    public void testToURLs3() {
        File[] files = null;
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.toURLs(files), (String)"Can't convert null list");
    }

    @Test
    public void testToURLs3a() throws Exception {
        File[] files = new File[]{};
        URL[] urls = FileUtils.toURLs(files);
        Assertions.assertEquals((int)0, (int)urls.length);
    }

    @Test
    public void testWrite_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        FileUtils.write(file, (CharSequence)"this is brand new data", false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWrite_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        FileUtils.write(file, (CharSequence)"this is brand new data", true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteByteArrayToFile() throws Exception {
        File file = new File(this.tempDirFile, "write.obj");
        byte[] data = new byte[]{11, 21, 31};
        FileUtils.writeByteArrayToFile(file, data);
        TestUtils.assertEqualContent(data, file);
    }

    @Test
    public void testWriteByteArrayToFile_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        FileUtils.writeByteArrayToFile(file, "this is brand new data".getBytes(), false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteByteArrayToFile_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        FileUtils.writeByteArrayToFile(file, "this is brand new data".getBytes(), true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteByteArrayToFile_WithOffsetAndLength() throws Exception {
        File file = new File(this.tempDirFile, "write.obj");
        byte[] data = new byte[]{11, 21, 32, 41, 51};
        byte[] writtenData = new byte[3];
        System.arraycopy(data, 1, writtenData, 0, 3);
        FileUtils.writeByteArrayToFile(file, data, 1, 3);
        TestUtils.assertEqualContent(writtenData, file);
    }

    @Test
    public void testWriteByteArrayToFile_WithOffsetAndLength_WithAppendOptionTrue_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        byte[] data = "SKIP_THIS_this is brand new data_AND_SKIP_THIS".getBytes(StandardCharsets.UTF_8);
        FileUtils.writeByteArrayToFile(file, data, 10, 22, false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteByteArrayToFile_WithOffsetAndLength_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        byte[] data = "SKIP_THIS_this is brand new data_AND_SKIP_THIS".getBytes(StandardCharsets.UTF_8);
        FileUtils.writeByteArrayToFile(file, data, 10, 22, true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteCharSequence1() throws Exception {
        File file = new File(this.tempDirFile, "write.txt");
        FileUtils.write(file, (CharSequence)"Hello /u1234", "UTF8");
        byte[] text = "Hello /u1234".getBytes(StandardCharsets.UTF_8);
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteCharSequence2() throws Exception {
        File file = new File(this.tempDirFile, "write.txt");
        FileUtils.write(file, (CharSequence)"Hello /u1234", (String)null);
        byte[] text = "Hello /u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteLines_3arg_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeLines(file, StandardCharsets.US_ASCII.name(), list);
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator() + System.lineSeparator() + "this is" + System.lineSeparator() + System.lineSeparator() + "some text" + System.lineSeparator();
        String actual = FileUtils.readFileToString(file, StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_3argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...", StandardCharsets.UTF_8);
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines(file, linesToAppend, false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_3argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...", StandardCharsets.UTF_8);
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines(file, linesToAppend, true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_4arg() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeLines(file, StandardCharsets.US_ASCII.name(), list, "*");
        String expected = "hello*world**this is**some text*";
        String actual = FileUtils.readFileToString(file, StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((Object)"hello*world**this is**some text*", (Object)actual);
    }

    @Test
    public void testWriteLines_4arg_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeLines(file, StandardCharsets.US_ASCII.name(), list, null);
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator() + System.lineSeparator() + "this is" + System.lineSeparator() + System.lineSeparator() + "some text" + System.lineSeparator();
        String actual = FileUtils.readFileToString(file, StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_4arg_Writer_nullData() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeLines(file, StandardCharsets.US_ASCII.name(), null, "*");
        Assertions.assertEquals((long)0L, (long)file.length(), (String)"Sizes differ");
    }

    @Test
    public void testWriteLines_4argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines(file, linesToAppend, null, false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_4argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines(file, linesToAppend, null, true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_5argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines(file, null, linesToAppend, null, false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_5argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines(file, null, linesToAppend, null, true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLinesEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines(file, null, linesToAppend, false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLinesEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines(file, null, linesToAppend, true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteStringToFile_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        FileUtils.writeStringToFile(file, "this is brand new data", false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteStringToFile_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        FileUtils.writeStringToFile(file, "this is brand new data", true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteStringToFileIntoNonExistentSubdir() throws Exception {
        File file = new File(this.tempDirFile, "subdir/write.txt");
        FileUtils.writeStringToFile(file, "Hello /u1234", (Charset)null);
        byte[] text = "Hello /u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteStringToFileIntoSymlinkedDir() throws Exception {
        Path symlinkDir = (Path)this.createTempSymbolicLinkedRelativeDir().getLeft();
        File file = symlinkDir.resolve("file").toFile();
        FileUtils.writeStringToFile(file, "Hello /u1234", StandardCharsets.UTF_8);
        byte[] text = "Hello /u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteStringToFileWithCharset() throws Exception {
        File file = new File(this.tempDirFile, "write.txt");
        FileUtils.writeStringToFile(file, "Hello /u1234", "UTF8");
        byte[] text = "Hello /u1234".getBytes(StandardCharsets.UTF_8);
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteStringToFileWithEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        FileUtils.writeStringToFile(file, "this is brand new data", (String)null, false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteStringToFileWithEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...");
        FileUtils.writeStringToFile(file, "this is brand new data", (String)null, true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteStringToFileWithNullCharset() throws Exception {
        File file = new File(this.tempDirFile, "write.txt");
        FileUtils.writeStringToFile(file, "Hello /u1234", (Charset)null);
        byte[] text = "Hello /u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteStringToFileWithNullStringCharset() throws Exception {
        File file = new File(this.tempDirFile, "write.txt");
        FileUtils.writeStringToFile(file, "Hello /u1234", (String)null);
        byte[] text = "Hello /u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteWithEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...", StandardCharsets.UTF_8);
        FileUtils.write(file, (CharSequence)"this is brand new data", (String)null, false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteWithEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.tempDirFile, "lines.txt");
        FileUtils.writeStringToFile(file, "This line was there before you...", StandardCharsets.UTF_8);
        FileUtils.write(file, (CharSequence)"this is brand new data", (String)null, true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString(file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    static class ListDirectoryWalker
    extends DirectoryWalker<File> {
        ListDirectoryWalker() {
        }

        @Override
        protected void handleDirectoryStart(File directory, int depth, Collection<File> results) throws IOException {
            if (depth > 0) {
                results.add(directory);
            }
        }

        @Override
        protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
            results.add(file);
        }

        List<File> list(File startDirectory) throws IOException {
            ArrayList<File> files = new ArrayList<File>();
            this.walk(startDirectory, files);
            return files;
        }
    }
}

