/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FilenameUtilsTest {
    private static final String SEP = "" + File.separatorChar;
    private static final boolean WINDOWS = File.separatorChar == '\\';
    @TempDir
    public Path temporaryFolder;
    private Path testFile1;
    private Path testFile2;
    private int testFile1Size;
    private int testFile2Size;

    @BeforeEach
    public void setUp() throws Exception {
        this.testFile1 = Files.createTempFile(this.temporaryFolder, "test", "1", new FileAttribute[0]);
        this.testFile2 = Files.createTempFile(this.temporaryFolder, "test", "2", new FileAttribute[0]);
        this.testFile1Size = (int)Files.size(this.testFile1);
        this.testFile2Size = (int)Files.size(this.testFile2);
        if (!Files.exists(this.testFile1.getParent(), new LinkOption[0])) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output3 = new BufferedOutputStream(Files.newOutputStream(this.testFile1, new OpenOption[0]));){
            TestUtils.generateTestData(output3, (long)this.testFile1Size);
        }
        if (!Files.exists(this.testFile2.getParent(), new LinkOption[0])) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output2 = new BufferedOutputStream(Files.newOutputStream(this.testFile2, new OpenOption[0]));){
            TestUtils.generateTestData(output2, (long)this.testFile2Size);
        }
        if (!Files.exists(this.testFile1.getParent(), new LinkOption[0])) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(Files.newOutputStream(this.testFile1, new OpenOption[0]));){
            TestUtils.generateTestData(output1, (long)this.testFile1Size);
        }
        if (!Files.exists(this.testFile2.getParent(), new LinkOption[0])) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFile2, new OpenOption[0]));){
            TestUtils.generateTestData(output, (long)this.testFile2Size);
        }
    }

    @Test
    public void testConcat() {
        Assertions.assertNull((Object)FilenameUtils.concat("", null));
        Assertions.assertNull((Object)FilenameUtils.concat(null, null));
        Assertions.assertNull((Object)FilenameUtils.concat(null, ""));
        Assertions.assertNull((Object)FilenameUtils.concat(null, "a"));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.concat(null, "/a"));
        Assertions.assertNull((Object)FilenameUtils.concat("", ":"));
        Assertions.assertNull((Object)FilenameUtils.concat(":", ""));
        Assertions.assertEquals((Object)("f" + SEP), (Object)FilenameUtils.concat("", "f/"));
        Assertions.assertEquals((Object)"f", (Object)FilenameUtils.concat("", "f"));
        Assertions.assertEquals((Object)("a" + SEP + "f" + SEP), (Object)FilenameUtils.concat("a/", "f/"));
        Assertions.assertEquals((Object)("a" + SEP + "f"), (Object)FilenameUtils.concat("a", "f"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "f" + SEP), (Object)FilenameUtils.concat("a/b/", "f/"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "f"), (Object)FilenameUtils.concat("a/b", "f"));
        Assertions.assertEquals((Object)("a" + SEP + "f" + SEP), (Object)FilenameUtils.concat("a/b/", "../f/"));
        Assertions.assertEquals((Object)("a" + SEP + "f"), (Object)FilenameUtils.concat("a/b", "../f"));
        Assertions.assertEquals((Object)("a" + SEP + "c" + SEP + "g" + SEP), (Object)FilenameUtils.concat("a/b/../c/", "f/../g/"));
        Assertions.assertEquals((Object)("a" + SEP + "c" + SEP + "g"), (Object)FilenameUtils.concat("a/b/../c", "f/../g"));
        Assertions.assertEquals((Object)("a" + SEP + "c.txt" + SEP + "f"), (Object)FilenameUtils.concat("a/c.txt", "f"));
        Assertions.assertEquals((Object)(SEP + "f" + SEP), (Object)FilenameUtils.concat("", "/f/"));
        Assertions.assertEquals((Object)(SEP + "f"), (Object)FilenameUtils.concat("", "/f"));
        Assertions.assertEquals((Object)(SEP + "f" + SEP), (Object)FilenameUtils.concat("a/", "/f/"));
        Assertions.assertEquals((Object)(SEP + "f"), (Object)FilenameUtils.concat("a", "/f"));
        Assertions.assertEquals((Object)(SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat("a/b/", "/c/d"));
        Assertions.assertEquals((Object)("C:c" + SEP + "d"), (Object)FilenameUtils.concat("a/b/", "C:c/d"));
        Assertions.assertEquals((Object)("C:" + SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat("a/b/", "C:/c/d"));
        Assertions.assertEquals((Object)("~" + SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat("a/b/", "~/c/d"));
        Assertions.assertEquals((Object)("~user" + SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat("a/b/", "~user/c/d"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.concat("a/b/", "~"));
        Assertions.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.concat("a/b/", "~user"));
    }

    @Test
    public void testDirectoryContains() {
        Assertions.assertTrue((boolean)FilenameUtils.directoryContains("/foo", "/foo/bar"));
        Assertions.assertTrue((boolean)FilenameUtils.directoryContains("/foo/", "/foo/bar"));
        Assertions.assertTrue((boolean)FilenameUtils.directoryContains("C:\\foo", "C:\\foo\\bar"));
        Assertions.assertTrue((boolean)FilenameUtils.directoryContains("C:\\foo\\", "C:\\foo\\bar"));
        Assertions.assertFalse((boolean)FilenameUtils.directoryContains("/foo", "/foo"));
        Assertions.assertFalse((boolean)FilenameUtils.directoryContains("/foo", "/foobar"));
        Assertions.assertFalse((boolean)FilenameUtils.directoryContains("C:\\foo", "C:\\foobar"));
        Assertions.assertFalse((boolean)FilenameUtils.directoryContains("/foo", null));
        Assertions.assertFalse((boolean)FilenameUtils.directoryContains("", ""));
        Assertions.assertFalse((boolean)FilenameUtils.directoryContains("", "/foo"));
        Assertions.assertFalse((boolean)FilenameUtils.directoryContains("/foo", ""));
    }

    @Test
    public void testEquals() {
        Assertions.assertTrue((boolean)FilenameUtils.equals(null, null));
        Assertions.assertFalse((boolean)FilenameUtils.equals(null, ""));
        Assertions.assertFalse((boolean)FilenameUtils.equals("", null));
        Assertions.assertTrue((boolean)FilenameUtils.equals("", ""));
        Assertions.assertTrue((boolean)FilenameUtils.equals("file.txt", "file.txt"));
        Assertions.assertFalse((boolean)FilenameUtils.equals("file.txt", "FILE.TXT"));
        Assertions.assertFalse((boolean)FilenameUtils.equals("a\\b\\file.txt", "a/b/file.txt"));
    }

    @Test
    public void testEquals_fullControl() {
        Assertions.assertFalse((boolean)FilenameUtils.equals("file.txt", "FILE.TXT", true, IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.equals("file.txt", "FILE.TXT", true, IOCase.INSENSITIVE));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.equals("file.txt", "FILE.TXT", true, IOCase.SYSTEM));
        Assertions.assertFalse((boolean)FilenameUtils.equals("file.txt", "FILE.TXT", true, null));
    }

    @Test
    public void testEqualsNormalized() {
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalized(null, null));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalized(null, ""));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalized("", null));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalized("", ""));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalized("file.txt", "file.txt"));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalized("file.txt", "FILE.TXT"));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalized("a\\b\\file.txt", "a/b/file.txt"));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalized("a/b/", "a/b"));
    }

    @Test
    public void testEqualsNormalizedError_IO_128() {
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem("//file.txt", "file.txt"));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem("file.txt", "//file.txt"));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem("//file.txt", "//file.txt"));
    }

    @Test
    public void testEqualsNormalizedOnSystem() {
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem(null, null));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem(null, ""));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem("", null));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem("", ""));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem("file.txt", "file.txt"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.equalsNormalizedOnSystem("file.txt", "FILE.TXT"));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem("a\\b\\file.txt", "a/b/file.txt"));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem("a/b/", "a/b"));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem("//a.html", "//ab.html"));
    }

    @Test
    public void testEqualsOnSystem() {
        Assertions.assertTrue((boolean)FilenameUtils.equalsOnSystem(null, null));
        Assertions.assertFalse((boolean)FilenameUtils.equalsOnSystem(null, ""));
        Assertions.assertFalse((boolean)FilenameUtils.equalsOnSystem("", null));
        Assertions.assertTrue((boolean)FilenameUtils.equalsOnSystem("", ""));
        Assertions.assertTrue((boolean)FilenameUtils.equalsOnSystem("file.txt", "file.txt"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.equalsOnSystem("file.txt", "FILE.TXT"));
        Assertions.assertFalse((boolean)FilenameUtils.equalsOnSystem("a\\b\\file.txt", "a/b/file.txt"));
    }

    @Test
    public void testGetBaseName() {
        Assertions.assertNull((Object)FilenameUtils.getBaseName(null));
        Assertions.assertEquals((Object)"noseparator", (Object)FilenameUtils.getBaseName("noseparator.inthispath"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.getBaseName("a/b/c.txt"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.getBaseName("a/b/c"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getBaseName("a/b/c/"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.getBaseName("a\\b\\c"));
        Assertions.assertEquals((Object)"file.txt", (Object)FilenameUtils.getBaseName("file.txt.bak"));
    }

    @Test
    public void testGetBaseName_with_null_character() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FilenameUtils.getBaseName("fil\u0000e.txt.bak"));
    }

    @Test
    public void testGetExtension() {
        Assertions.assertNull((Object)FilenameUtils.getExtension(null));
        Assertions.assertEquals((Object)"ext", (Object)FilenameUtils.getExtension("file.ext"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension("README"));
        Assertions.assertEquals((Object)"com", (Object)FilenameUtils.getExtension("domain.dot.com"));
        Assertions.assertEquals((Object)"jpeg", (Object)FilenameUtils.getExtension("image.jpeg"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension("a.b/c"));
        Assertions.assertEquals((Object)"txt", (Object)FilenameUtils.getExtension("a.b/c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension("a/b/c"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension("a.b\\c"));
        Assertions.assertEquals((Object)"txt", (Object)FilenameUtils.getExtension("a.b\\c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension("a\\b\\c"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension("C:\\temp\\foo.bar\\README"));
        Assertions.assertEquals((Object)"ext", (Object)FilenameUtils.getExtension("../filename.ext"));
        if (FilenameUtils.isSystemWindows()) {
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> FilenameUtils.getExtension("foo.exe:bar.txt"));
            Assertions.assertEquals((Object)"NTFS ADS separator (':') in file name is forbidden.", (Object)e.getMessage());
        } else {
            Assertions.assertEquals((Object)"txt", (Object)FilenameUtils.getExtension("foo.exe:bar.txt"));
        }
    }

    @Test
    public void testGetFullPath() {
        Assertions.assertNull((Object)FilenameUtils.getFullPath(null));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getFullPath("noseparator.inthispath"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getFullPath("a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getFullPath("a/b/c"));
        Assertions.assertEquals((Object)"a/b/c/", (Object)FilenameUtils.getFullPath("a/b/c/"));
        Assertions.assertEquals((Object)"a\\b\\", (Object)FilenameUtils.getFullPath("a\\b\\c"));
        Assertions.assertNull((Object)FilenameUtils.getFullPath(":"));
        Assertions.assertNull((Object)FilenameUtils.getFullPath("1:/a/b/c.txt"));
        Assertions.assertNull((Object)FilenameUtils.getFullPath("1:"));
        Assertions.assertNull((Object)FilenameUtils.getFullPath("1:a"));
        Assertions.assertNull((Object)FilenameUtils.getFullPath("///a/b/c.txt"));
        Assertions.assertNull((Object)FilenameUtils.getFullPath("//a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getFullPath(""));
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPath("C:"));
        }
        if (SystemUtils.IS_OS_LINUX) {
            Assertions.assertEquals((Object)"", (Object)FilenameUtils.getFullPath("C:"));
        }
        Assertions.assertEquals((Object)"C:/", (Object)FilenameUtils.getFullPath("C:/"));
        Assertions.assertEquals((Object)"//server/", (Object)FilenameUtils.getFullPath("//server/"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getFullPath("~"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getFullPath("~/"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getFullPath("~user"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getFullPath("~user/"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getFullPath("a/b/c.txt"));
        Assertions.assertEquals((Object)"/a/b/", (Object)FilenameUtils.getFullPath("/a/b/c.txt"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPath("C:a"));
        Assertions.assertEquals((Object)"C:a/b/", (Object)FilenameUtils.getFullPath("C:a/b/c.txt"));
        Assertions.assertEquals((Object)"C:/a/b/", (Object)FilenameUtils.getFullPath("C:/a/b/c.txt"));
        Assertions.assertEquals((Object)"//server/a/b/", (Object)FilenameUtils.getFullPath("//server/a/b/c.txt"));
        Assertions.assertEquals((Object)"~/a/b/", (Object)FilenameUtils.getFullPath("~/a/b/c.txt"));
        Assertions.assertEquals((Object)"~user/a/b/", (Object)FilenameUtils.getFullPath("~user/a/b/c.txt"));
    }

    @Test
    public void testGetFullPathNoEndSeparator() {
        Assertions.assertNull((Object)FilenameUtils.getFullPathNoEndSeparator(null));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getFullPathNoEndSeparator("noseparator.inthispath"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getFullPathNoEndSeparator("a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getFullPathNoEndSeparator("a/b/c"));
        Assertions.assertEquals((Object)"a/b/c", (Object)FilenameUtils.getFullPathNoEndSeparator("a/b/c/"));
        Assertions.assertEquals((Object)"a\\b", (Object)FilenameUtils.getFullPathNoEndSeparator("a\\b\\c"));
        Assertions.assertNull((Object)FilenameUtils.getFullPathNoEndSeparator(":"));
        Assertions.assertNull((Object)FilenameUtils.getFullPathNoEndSeparator("1:/a/b/c.txt"));
        Assertions.assertNull((Object)FilenameUtils.getFullPathNoEndSeparator("1:"));
        Assertions.assertNull((Object)FilenameUtils.getFullPathNoEndSeparator("1:a"));
        Assertions.assertNull((Object)FilenameUtils.getFullPathNoEndSeparator("///a/b/c.txt"));
        Assertions.assertNull((Object)FilenameUtils.getFullPathNoEndSeparator("//a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getFullPathNoEndSeparator(""));
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPathNoEndSeparator("C:"));
        }
        if (SystemUtils.IS_OS_LINUX) {
            Assertions.assertEquals((Object)"", (Object)FilenameUtils.getFullPathNoEndSeparator("C:"));
        }
        Assertions.assertEquals((Object)"C:/", (Object)FilenameUtils.getFullPathNoEndSeparator("C:/"));
        Assertions.assertEquals((Object)"//server/", (Object)FilenameUtils.getFullPathNoEndSeparator("//server/"));
        Assertions.assertEquals((Object)"~", (Object)FilenameUtils.getFullPathNoEndSeparator("~"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getFullPathNoEndSeparator("~/"));
        Assertions.assertEquals((Object)"~user", (Object)FilenameUtils.getFullPathNoEndSeparator("~user"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getFullPathNoEndSeparator("~user/"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getFullPathNoEndSeparator("a/b/c.txt"));
        Assertions.assertEquals((Object)"/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator("/a/b/c.txt"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPathNoEndSeparator("C:a"));
        Assertions.assertEquals((Object)"C:a/b", (Object)FilenameUtils.getFullPathNoEndSeparator("C:a/b/c.txt"));
        Assertions.assertEquals((Object)"C:/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator("C:/a/b/c.txt"));
        Assertions.assertEquals((Object)"//server/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator("//server/a/b/c.txt"));
        Assertions.assertEquals((Object)"~/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator("~/a/b/c.txt"));
        Assertions.assertEquals((Object)"~user/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator("~user/a/b/c.txt"));
    }

    @Test
    public void testGetFullPathNoEndSeparator_IO_248() {
        Assertions.assertEquals((Object)"/", (Object)FilenameUtils.getFullPathNoEndSeparator("/"));
        Assertions.assertEquals((Object)"\\", (Object)FilenameUtils.getFullPathNoEndSeparator("\\"));
        Assertions.assertEquals((Object)"/", (Object)FilenameUtils.getFullPathNoEndSeparator("/abc"));
        Assertions.assertEquals((Object)"\\", (Object)FilenameUtils.getFullPathNoEndSeparator("\\abc"));
        Assertions.assertEquals((Object)"/abc", (Object)FilenameUtils.getFullPathNoEndSeparator("/abc/xyz"));
        Assertions.assertEquals((Object)"\\abc", (Object)FilenameUtils.getFullPathNoEndSeparator("\\abc\\xyz"));
    }

    @Test
    public void testGetName() {
        Assertions.assertNull((Object)FilenameUtils.getName(null));
        Assertions.assertEquals((Object)"noseparator.inthispath", (Object)FilenameUtils.getName("noseparator.inthispath"));
        Assertions.assertEquals((Object)"c.txt", (Object)FilenameUtils.getName("a/b/c.txt"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.getName("a/b/c"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getName("a/b/c/"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.getName("a\\b\\c"));
    }

    @Test
    public void testGetPath() {
        Assertions.assertNull((Object)FilenameUtils.getPath(null));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("noseparator.inthispath"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("/noseparator.inthispath"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("\\noseparator.inthispath"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath("a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath("a/b/c"));
        Assertions.assertEquals((Object)"a/b/c/", (Object)FilenameUtils.getPath("a/b/c/"));
        Assertions.assertEquals((Object)"a\\b\\", (Object)FilenameUtils.getPath("a\\b\\c"));
        Assertions.assertNull((Object)FilenameUtils.getPath(":"));
        Assertions.assertNull((Object)FilenameUtils.getPath("1:/a/b/c.txt"));
        Assertions.assertNull((Object)FilenameUtils.getPath("1:"));
        Assertions.assertNull((Object)FilenameUtils.getPath("1:a"));
        Assertions.assertNull((Object)FilenameUtils.getPath("///a/b/c.txt"));
        Assertions.assertNull((Object)FilenameUtils.getPath("//a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath(""));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("C:"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("C:/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("//server/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("~"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("~/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("~user"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("~user/"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath("a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath("/a/b/c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("C:a"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath("C:a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath("C:/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath("//server/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath("~/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath("~user/a/b/c.txt"));
    }

    @Test
    public void testGetPath_with_null_character() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FilenameUtils.getPath("~user/a/\u0000b/c.txt"));
    }

    @Test
    public void testGetPathNoEndSeparator() {
        Assertions.assertNull((Object)FilenameUtils.getPath(null));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath("noseparator.inthispath"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator("/noseparator.inthispath"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator("\\noseparator.inthispath"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator("a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator("a/b/c"));
        Assertions.assertEquals((Object)"a/b/c", (Object)FilenameUtils.getPathNoEndSeparator("a/b/c/"));
        Assertions.assertEquals((Object)"a\\b", (Object)FilenameUtils.getPathNoEndSeparator("a\\b\\c"));
        Assertions.assertNull((Object)FilenameUtils.getPathNoEndSeparator(":"));
        Assertions.assertNull((Object)FilenameUtils.getPathNoEndSeparator("1:/a/b/c.txt"));
        Assertions.assertNull((Object)FilenameUtils.getPathNoEndSeparator("1:"));
        Assertions.assertNull((Object)FilenameUtils.getPathNoEndSeparator("1:a"));
        Assertions.assertNull((Object)FilenameUtils.getPathNoEndSeparator("///a/b/c.txt"));
        Assertions.assertNull((Object)FilenameUtils.getPathNoEndSeparator("//a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator(""));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator("C:"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator("C:/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator("//server/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator("~"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator("~/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator("~user"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator("~user/"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator("a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator("/a/b/c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator("C:a"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator("C:a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator("C:/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator("//server/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator("~/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator("~user/a/b/c.txt"));
    }

    @Test
    public void testGetPathNoEndSeparator_with_null_character() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FilenameUtils.getPathNoEndSeparator("~user/a\u0000/b/c.txt"));
    }

    @Test
    public void testGetPrefix() {
        Assertions.assertNull((Object)FilenameUtils.getPrefix(null));
        Assertions.assertNull((Object)FilenameUtils.getPrefix(":"));
        Assertions.assertNull((Object)FilenameUtils.getPrefix("1:\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.getPrefix("1:"));
        Assertions.assertNull((Object)FilenameUtils.getPrefix("1:a"));
        Assertions.assertNull((Object)FilenameUtils.getPrefix("\\\\\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.getPrefix("\\\\a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPrefix(""));
        Assertions.assertEquals((Object)"\\", (Object)FilenameUtils.getPrefix("\\"));
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.getPrefix("C:"));
        }
        if (SystemUtils.IS_OS_LINUX) {
            Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPrefix("C:"));
        }
        Assertions.assertEquals((Object)"C:\\", (Object)FilenameUtils.getPrefix("C:\\"));
        Assertions.assertEquals((Object)"//server/", (Object)FilenameUtils.getPrefix("//server/"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getPrefix("~"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getPrefix("~/"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getPrefix("~user"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getPrefix("~user/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPrefix("a\\b\\c.txt"));
        Assertions.assertEquals((Object)"\\", (Object)FilenameUtils.getPrefix("\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"C:\\", (Object)FilenameUtils.getPrefix("C:\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"\\\\server\\", (Object)FilenameUtils.getPrefix("\\\\server\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPrefix("a/b/c.txt"));
        Assertions.assertEquals((Object)"/", (Object)FilenameUtils.getPrefix("/a/b/c.txt"));
        Assertions.assertEquals((Object)"C:/", (Object)FilenameUtils.getPrefix("C:/a/b/c.txt"));
        Assertions.assertEquals((Object)"//server/", (Object)FilenameUtils.getPrefix("//server/a/b/c.txt"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getPrefix("~/a/b/c.txt"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getPrefix("~user/a/b/c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPrefix("a\\b\\c.txt"));
        Assertions.assertEquals((Object)"\\", (Object)FilenameUtils.getPrefix("\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"~\\", (Object)FilenameUtils.getPrefix("~\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"~user\\", (Object)FilenameUtils.getPrefix("~user\\a\\b\\c.txt"));
    }

    @Test
    public void testGetPrefix_with_null_character() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FilenameUtils.getPrefix("~u\u0000ser\\a\\b\\c.txt"));
    }

    @Test
    public void testGetPrefixLength() {
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength(null));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength(":"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength("1:\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength("1:"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength("1:a"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength("\\\\\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength("\\\\a"));
        Assertions.assertEquals((int)0, (int)FilenameUtils.getPrefixLength(""));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength("\\"));
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength("C:"));
        }
        if (SystemUtils.IS_OS_LINUX) {
            Assertions.assertEquals((int)0, (int)FilenameUtils.getPrefixLength("C:"));
        }
        Assertions.assertEquals((int)3, (int)FilenameUtils.getPrefixLength("C:\\"));
        Assertions.assertEquals((int)9, (int)FilenameUtils.getPrefixLength("//server/"));
        Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength("~"));
        Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength("~/"));
        Assertions.assertEquals((int)6, (int)FilenameUtils.getPrefixLength("~user"));
        Assertions.assertEquals((int)6, (int)FilenameUtils.getPrefixLength("~user/"));
        Assertions.assertEquals((int)0, (int)FilenameUtils.getPrefixLength("a\\b\\c.txt"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength("\\a\\b\\c.txt"));
        Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength("C:a\\b\\c.txt"));
        Assertions.assertEquals((int)3, (int)FilenameUtils.getPrefixLength("C:\\a\\b\\c.txt"));
        Assertions.assertEquals((int)9, (int)FilenameUtils.getPrefixLength("\\\\server\\a\\b\\c.txt"));
        Assertions.assertEquals((int)0, (int)FilenameUtils.getPrefixLength("a/b/c.txt"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength("/a/b/c.txt"));
        Assertions.assertEquals((int)3, (int)FilenameUtils.getPrefixLength("C:/a/b/c.txt"));
        Assertions.assertEquals((int)9, (int)FilenameUtils.getPrefixLength("//server/a/b/c.txt"));
        Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength("~/a/b/c.txt"));
        Assertions.assertEquals((int)6, (int)FilenameUtils.getPrefixLength("~user/a/b/c.txt"));
        Assertions.assertEquals((int)0, (int)FilenameUtils.getPrefixLength("a\\b\\c.txt"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength("\\a\\b\\c.txt"));
        Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength("~\\a\\b\\c.txt"));
        Assertions.assertEquals((int)6, (int)FilenameUtils.getPrefixLength("~user\\a\\b\\c.txt"));
        Assertions.assertEquals((int)9, (int)FilenameUtils.getPrefixLength("//server/a/b/c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength("\\\\\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength("///a/b/c.txt"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength("/:foo"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength("/:/"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength("/:::::::.txt"));
        Assertions.assertEquals((int)12, (int)FilenameUtils.getPrefixLength("\\\\127.0.0.1\\a\\b\\c.txt"));
        Assertions.assertEquals((int)6, (int)FilenameUtils.getPrefixLength("\\\\::1\\a\\b\\c.txt"));
        Assertions.assertEquals((int)21, (int)FilenameUtils.getPrefixLength("\\\\server.example.org\\a\\b\\c.txt"));
        Assertions.assertEquals((int)10, (int)FilenameUtils.getPrefixLength("\\\\server.\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength("\\\\-server\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength("\\\\.\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength("\\\\..\\a\\b\\c.txt"));
    }

    @Test
    public void testIndexOfExtension() {
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension(null));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension("file"));
        Assertions.assertEquals((int)4, (int)FilenameUtils.indexOfExtension("file.txt"));
        Assertions.assertEquals((int)13, (int)FilenameUtils.indexOfExtension("a.txt/b.txt/c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension("a/b/c"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension("a\\b\\c"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension("a/b.notextension/c"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension("a\\b.notextension\\c"));
        if (FilenameUtils.isSystemWindows()) {
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> FilenameUtils.indexOfExtension("foo.exe:bar.txt"));
            Assertions.assertEquals((Object)"NTFS ADS separator (':') in file name is forbidden.", (Object)e.getMessage());
        } else {
            Assertions.assertEquals((int)11, (int)FilenameUtils.indexOfExtension("foo.exe:bar.txt"));
        }
    }

    @Test
    public void testIndexOfLastSeparator() {
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfLastSeparator(null));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfLastSeparator("noseparator.inthispath"));
        Assertions.assertEquals((int)3, (int)FilenameUtils.indexOfLastSeparator("a/b/c"));
        Assertions.assertEquals((int)3, (int)FilenameUtils.indexOfLastSeparator("a\\b\\c"));
    }

    @Test
    public void testInjectionFailure() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FilenameUtils.getName("a\\b\\\u0000c"));
    }

    @Test
    public void testIsExtension() {
        Assertions.assertFalse((boolean)FilenameUtils.isExtension(null, (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("file.txt", (String)null));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file", (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("file.txt", ""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file", ""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file.txt", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("file.txt", "rtf"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a/b/file.txt", (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a/b/file.txt", ""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a/b/file.txt", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a/b/file.txt", "rtf"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b/file.txt", (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b/file.txt", ""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b/file.txt", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b/file.txt", "rtf"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a\\b\\file.txt", (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a\\b\\file.txt", ""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a\\b\\file.txt", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a\\b\\file.txt", "rtf"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", ""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b\\file.txt", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", "rtf"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", "TXT"));
    }

    @Test
    public void testIsExtension_injection() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FilenameUtils.isExtension("a.b\\fi\u0000le.txt", "TXT"));
    }

    @Test
    public void testIsExtensionArray() {
        Assertions.assertFalse((boolean)FilenameUtils.isExtension(null, (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("file.txt", (String[])null));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file", (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("file.txt", new String[0]));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file.txt", new String[]{"txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("file.txt", new String[]{"rtf"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file", "rtf", ""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file.txt", "rtf", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a/b/file.txt", (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a/b/file.txt", new String[0]));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a/b/file.txt", new String[]{"txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a/b/file.txt", new String[]{"rtf"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a/b/file.txt", "rtf", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b/file.txt", (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b/file.txt", new String[0]));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b/file.txt", new String[]{"txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b/file.txt", new String[]{"rtf"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b/file.txt", "rtf", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a\\b\\file.txt", (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a\\b\\file.txt", new String[0]));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a\\b\\file.txt", new String[]{"txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a\\b\\file.txt", new String[]{"rtf"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a\\b\\file.txt", "rtf", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", new String[0]));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b\\file.txt", new String[]{"txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", new String[]{"rtf"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b\\file.txt", "rtf", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", new String[]{"TXT"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", "TXT", "RTF"));
    }

    @Test
    public void testIsExtensionCollection() {
        Assertions.assertFalse((boolean)FilenameUtils.isExtension(null, (Collection<String>)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("file.txt", (Collection<String>)null));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file", (Collection<String>)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("file.txt", new ArrayList<String>()));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file", new ArrayList<String>(Arrays.asList("rtf", ""))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a/b/file.txt", (Collection<String>)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a/b/file.txt", new ArrayList<String>()));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a/b/file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a/b/file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a/b/file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b/file.txt", (Collection<String>)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b/file.txt", new ArrayList<String>()));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b/file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b/file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b/file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a\\b\\file.txt", (Collection<String>)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a\\b\\file.txt", new ArrayList<String>()));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a\\b\\file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a\\b\\file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a\\b\\file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", (Collection<String>)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", new ArrayList<String>()));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b\\file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b\\file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", new ArrayList<String>(Arrays.asList("TXT"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", new ArrayList<String>(Arrays.asList("TXT", "RTF"))));
    }

    @Test
    public void testIsExtensionVarArgs() {
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file.txt", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("file.txt", "rtf"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file", "rtf", ""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("file.txt", "rtf", "txt"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a/b/file.txt", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a/b/file.txt", "rtf"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a/b/file.txt", "rtf", "txt"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b/file.txt", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b/file.txt", "rtf"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b/file.txt", "rtf", "txt"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a\\b\\file.txt", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a\\b\\file.txt", "rtf"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a\\b\\file.txt", "rtf", "txt"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b\\file.txt", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", "rtf"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension("a.b\\file.txt", "rtf", "txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", "TXT"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension("a.b\\file.txt", "TXT", "RTF"));
    }

    @Test
    public void testNormalize() {
        Assertions.assertNull((Object)FilenameUtils.normalize(null));
        Assertions.assertNull((Object)FilenameUtils.normalize(":"));
        Assertions.assertNull((Object)FilenameUtils.normalize("1:\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("1:"));
        Assertions.assertNull((Object)FilenameUtils.normalize("1:a"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\a"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("a\\b/c.txt"));
        Assertions.assertEquals((Object)("" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("C:\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("" + SEP + "" + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("\\\\server\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("~\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("~user\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("a" + SEP + "c"), (Object)FilenameUtils.normalize("a/b/../c"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.normalize("a/b/../../c"));
        Assertions.assertEquals((Object)("c" + SEP), (Object)FilenameUtils.normalize("a/b/../../c/"));
        Assertions.assertNull((Object)FilenameUtils.normalize("a/b/../../../c"));
        Assertions.assertEquals((Object)("a" + SEP), (Object)FilenameUtils.normalize("a/b/.."));
        Assertions.assertEquals((Object)("a" + SEP), (Object)FilenameUtils.normalize("a/b/../"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalize("a/b/../.."));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalize("a/b/../../"));
        Assertions.assertNull((Object)FilenameUtils.normalize("a/b/../../.."));
        Assertions.assertEquals((Object)("a" + SEP + "d"), (Object)FilenameUtils.normalize("a/b/../c/../d"));
        Assertions.assertEquals((Object)("a" + SEP + "d" + SEP), (Object)FilenameUtils.normalize("a/b/../c/../d/"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize("a/b//d"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize("a/b/././."));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize("a/b/./././"));
        Assertions.assertEquals((Object)("a" + SEP), (Object)FilenameUtils.normalize("./a/"));
        Assertions.assertEquals((Object)"a", (Object)FilenameUtils.normalize("./a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalize("./"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalize("."));
        Assertions.assertNull((Object)FilenameUtils.normalize("../a"));
        Assertions.assertNull((Object)FilenameUtils.normalize(".."));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalize(""));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalize("/a"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP), (Object)FilenameUtils.normalize("/a/"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize("/a/b/../c"));
        Assertions.assertEquals((Object)(SEP + "c"), (Object)FilenameUtils.normalize("/a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalize("/a/b/../../../c"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP), (Object)FilenameUtils.normalize("/a/b/.."));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize("/a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalize("/a/b/../../.."));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize("/a/b/../c/../d"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize("/a/b//d"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize("/a/b/././."));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalize("/./a"));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize("/./"));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize("/."));
        Assertions.assertNull((Object)FilenameUtils.normalize("/../a"));
        Assertions.assertNull((Object)FilenameUtils.normalize("/.."));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize("/"));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalize("~/a"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP), (Object)FilenameUtils.normalize("~/a/"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize("~/a/b/../c"));
        Assertions.assertEquals((Object)("~" + SEP + "c"), (Object)FilenameUtils.normalize("~/a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalize("~/a/b/../../../c"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP), (Object)FilenameUtils.normalize("~/a/b/.."));
        Assertions.assertEquals((Object)("~" + SEP + ""), (Object)FilenameUtils.normalize("~/a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalize("~/a/b/../../.."));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize("~/a/b/../c/../d"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize("~/a/b//d"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize("~/a/b/././."));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalize("~/./a"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize("~/./"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize("~/."));
        Assertions.assertNull((Object)FilenameUtils.normalize("~/../a"));
        Assertions.assertNull((Object)FilenameUtils.normalize("~/.."));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize("~/"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize("~"));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalize("~user/a"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP), (Object)FilenameUtils.normalize("~user/a/"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize("~user/a/b/../c"));
        Assertions.assertEquals((Object)("~user" + SEP + "c"), (Object)FilenameUtils.normalize("~user/a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalize("~user/a/b/../../../c"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP), (Object)FilenameUtils.normalize("~user/a/b/.."));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalize("~user/a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalize("~user/a/b/../../.."));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize("~user/a/b/../c/../d"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize("~user/a/b//d"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize("~user/a/b/././."));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalize("~user/./a"));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalize("~user/./"));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalize("~user/."));
        Assertions.assertNull((Object)FilenameUtils.normalize("~user/../a"));
        Assertions.assertNull((Object)FilenameUtils.normalize("~user/.."));
        Assertions.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalize("~user/"));
        Assertions.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalize("~user"));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalize("C:/a"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP), (Object)FilenameUtils.normalize("C:/a/"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize("C:/a/b/../c"));
        Assertions.assertEquals((Object)("C:" + SEP + "c"), (Object)FilenameUtils.normalize("C:/a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalize("C:/a/b/../../../c"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP), (Object)FilenameUtils.normalize("C:/a/b/.."));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize("C:/a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalize("C:/a/b/../../.."));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize("C:/a/b/../c/../d"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize("C:/a/b//d"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize("C:/a/b/././."));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalize("C:/./a"));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize("C:/./"));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize("C:/."));
        Assertions.assertNull((Object)FilenameUtils.normalize("C:/../a"));
        Assertions.assertNull((Object)FilenameUtils.normalize("C:/.."));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize("C:/"));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalize("C:a"));
        Assertions.assertEquals((Object)("C:a" + SEP), (Object)FilenameUtils.normalize("C:a/"));
        Assertions.assertEquals((Object)("C:a" + SEP + "c"), (Object)FilenameUtils.normalize("C:a/b/../c"));
        Assertions.assertEquals((Object)"C:c", (Object)FilenameUtils.normalize("C:a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalize("C:a/b/../../../c"));
        Assertions.assertEquals((Object)("C:a" + SEP), (Object)FilenameUtils.normalize("C:a/b/.."));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalize("C:a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalize("C:a/b/../../.."));
        Assertions.assertEquals((Object)("C:a" + SEP + "d"), (Object)FilenameUtils.normalize("C:a/b/../c/../d"));
        Assertions.assertEquals((Object)("C:a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize("C:a/b//d"));
        Assertions.assertEquals((Object)("C:a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize("C:a/b/././."));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalize("C:./a"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalize("C:./"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalize("C:."));
        Assertions.assertNull((Object)FilenameUtils.normalize("C:../a"));
        Assertions.assertNull((Object)FilenameUtils.normalize("C:.."));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalize("C:"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalize("//server/a"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP), (Object)FilenameUtils.normalize("//server/a/"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize("//server/a/b/../c"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "c"), (Object)FilenameUtils.normalize("//server/a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalize("//server/a/b/../../../c"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP), (Object)FilenameUtils.normalize("//server/a/b/.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize("//server/a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalize("//server/a/b/../../.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize("//server/a/b/../c/../d"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize("//server/a/b//d"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize("//server/a/b/././."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalize("//server/./a"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize("//server/./"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize("//server/."));
        Assertions.assertNull((Object)FilenameUtils.normalize("//server/../a"));
        Assertions.assertNull((Object)FilenameUtils.normalize("//server/.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize("//server/"));
        Assertions.assertEquals((Object)(SEP + SEP + "127.0.0.1" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("\\\\127.0.0.1\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "::1" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("\\\\::1\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "1::" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("\\\\1::\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "server.example.org" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("\\\\server.example.org\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "server.sub.example.org" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("\\\\server.sub.example.org\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "server." + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("\\\\server.\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "1::127.0.0.1" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("\\\\1::127.0.0.1\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "127.0.0.256" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("\\\\127.0.0.256\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "127.0.0.01" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize("\\\\127.0.0.01\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\-server\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\.\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\..\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\127.0..1\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\::1::2\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\:1\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\1:\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\1:2:3:4:5:6:7:8:9\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\g:2:3:4:5:6:7:8\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\1ffff:2:3:4:5:6:7:8\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\1:2\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalize("//../foo"));
        Assertions.assertNull((Object)FilenameUtils.normalize("\\\\..\\foo"));
    }

    @Test
    public void testNormalize_with_null_character() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FilenameUtils.normalize("a\\b/c\u0000.txt"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FilenameUtils.normalize("\u0000a\\b/c.txt"));
    }

    @Test
    public void testNormalizeFromJavaDoc() {
        Assertions.assertEquals((Object)(SEP + "foo" + SEP), (Object)FilenameUtils.normalize("/foo//"));
        Assertions.assertEquals((Object)(SEP + "foo" + SEP), (Object)FilenameUtils.normalize(SEP + "foo" + SEP + "." + SEP));
        Assertions.assertEquals((Object)(SEP + "bar"), (Object)FilenameUtils.normalize(SEP + "foo" + SEP + ".." + SEP + "bar"));
        Assertions.assertEquals((Object)(SEP + "bar" + SEP), (Object)FilenameUtils.normalize(SEP + "foo" + SEP + ".." + SEP + "bar" + SEP));
        Assertions.assertEquals((Object)(SEP + "baz"), (Object)FilenameUtils.normalize(SEP + "foo" + SEP + ".." + SEP + "bar" + SEP + ".." + SEP + "baz"));
        Assertions.assertEquals((Object)(SEP + SEP + "foo" + SEP + "bar"), (Object)FilenameUtils.normalize("//foo//./bar"));
        Assertions.assertNull((Object)FilenameUtils.normalize(SEP + ".." + SEP));
        Assertions.assertNull((Object)FilenameUtils.normalize(".." + SEP + "foo"));
        Assertions.assertEquals((Object)("foo" + SEP), (Object)FilenameUtils.normalize("foo" + SEP + "bar" + SEP + ".."));
        Assertions.assertNull((Object)FilenameUtils.normalize("foo" + SEP + ".." + SEP + ".." + SEP + "bar"));
        Assertions.assertEquals((Object)"bar", (Object)FilenameUtils.normalize("foo" + SEP + ".." + SEP + "bar"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "bar"), (Object)FilenameUtils.normalize(SEP + SEP + "server" + SEP + "foo" + SEP + ".." + SEP + "bar"));
        Assertions.assertNull((Object)FilenameUtils.normalize(SEP + SEP + "server" + SEP + ".." + SEP + "bar"));
        Assertions.assertEquals((Object)("C:" + SEP + "bar"), (Object)FilenameUtils.normalize("C:" + SEP + "foo" + SEP + ".." + SEP + "bar"));
        Assertions.assertNull((Object)FilenameUtils.normalize("C:" + SEP + ".." + SEP + "bar"));
        Assertions.assertEquals((Object)("~" + SEP + "bar" + SEP), (Object)FilenameUtils.normalize("~" + SEP + "foo" + SEP + ".." + SEP + "bar" + SEP));
        Assertions.assertNull((Object)FilenameUtils.normalize("~" + SEP + ".." + SEP + "bar"));
        Assertions.assertEquals((Object)(SEP + SEP + "foo" + SEP + "bar"), (Object)FilenameUtils.normalize("//foo//./bar"));
        Assertions.assertEquals((Object)(SEP + SEP + "foo" + SEP + "bar"), (Object)FilenameUtils.normalize("\\\\foo\\\\.\\bar"));
    }

    @Test
    public void testNormalizeNoEndSeparator() {
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator(null));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator(":"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("1:\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("1:"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("1:a"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("\\\\\\a\\b\\c.txt"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("\\\\a"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator("a\\b/c.txt"));
        Assertions.assertEquals((Object)("" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator("\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator("C:\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("" + SEP + "" + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator("\\\\server\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator("~\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator("~user\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator("C:\\\\a\\\\b\\\\c.txt"));
        Assertions.assertEquals((Object)("a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("a/b/../c"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.normalizeNoEndSeparator("a/b/../../c"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.normalizeNoEndSeparator("a/b/../../c/"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("a/b/../../../c"));
        Assertions.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator("a/b/.."));
        Assertions.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator("a/b/../"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator("a/b/../.."));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator("a/b/../../"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("a/b/../../.."));
        Assertions.assertEquals((Object)("a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("a/b/../c/../d"));
        Assertions.assertEquals((Object)("a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("a/b/../c/../d/"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("a/b//d"));
        Assertions.assertEquals((Object)("a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator("a/b/././."));
        Assertions.assertEquals((Object)("a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator("a/b/./././"));
        Assertions.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator("./a/"));
        Assertions.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator("./a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator("./"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator("."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("../a"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator(".."));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator(""));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("/a"));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("/a/"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("/a/b/../c"));
        Assertions.assertEquals((Object)(SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("/a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("/a/b/../../../c"));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("/a/b/.."));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("/a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("/a/b/../../.."));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("/a/b/../c/../d"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("/a/b//d"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator("/a/b/././."));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("/./a"));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("/./"));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("/."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("/../a"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("/.."));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("/"));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("~/a"));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("~/a/"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("~/a/b/../c"));
        Assertions.assertEquals((Object)("~" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("~/a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("~/a/b/../../../c"));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("~/a/b/.."));
        Assertions.assertEquals((Object)("~" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("~/a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("~/a/b/../../.."));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("~/a/b/../c/../d"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("~/a/b//d"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator("~/a/b/././."));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("~/./a"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator("~/./"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator("~/."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("~/../a"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("~/.."));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator("~/"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator("~"));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("~user/a"));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("~user/a/"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("~user/a/b/../c"));
        Assertions.assertEquals((Object)("~user" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("~user/a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("~user/a/b/../../../c"));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("~user/a/b/.."));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("~user/a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("~user/a/b/../../.."));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("~user/a/b/../c/../d"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("~user/a/b//d"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator("~user/a/b/././."));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("~user/./a"));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("~user/./"));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("~user/."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("~user/../a"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("~user/.."));
        Assertions.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator("~user/"));
        Assertions.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator("~user"));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("C:/a"));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("C:/a/"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("C:/a/b/../c"));
        Assertions.assertEquals((Object)("C:" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("C:/a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("C:/a/b/../../../c"));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("C:/a/b/.."));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("C:/a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("C:/a/b/../../.."));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("C:/a/b/../c/../d"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("C:/a/b//d"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator("C:/a/b/././."));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("C:/./a"));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("C:/./"));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("C:/."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("C:/../a"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("C:/.."));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("C:/"));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator("C:a"));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator("C:a/"));
        Assertions.assertEquals((Object)("C:a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("C:a/b/../c"));
        Assertions.assertEquals((Object)"C:c", (Object)FilenameUtils.normalizeNoEndSeparator("C:a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("C:a/b/../../../c"));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator("C:a/b/.."));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator("C:a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("C:a/b/../../.."));
        Assertions.assertEquals((Object)("C:a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("C:a/b/../c/../d"));
        Assertions.assertEquals((Object)("C:a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("C:a/b//d"));
        Assertions.assertEquals((Object)("C:a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator("C:a/b/././."));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator("C:./a"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator("C:./"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator("C:."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("C:../a"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("C:.."));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator("C:"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("//server/a"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("//server/a/"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("//server/a/b/../c"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator("//server/a/b/../../c"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("//server/a/b/../../../c"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("//server/a/b/.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("//server/a/b/../.."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("//server/a/b/../../.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("//server/a/b/../c/../d"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator("//server/a/b//d"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator("//server/a/b/././."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator("//server/./a"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("//server/./"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("//server/."));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("//server/../a"));
        Assertions.assertNull((Object)FilenameUtils.normalizeNoEndSeparator("//server/.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator("//server/"));
    }

    @Test
    public void testNormalizeNoEndSeparatorUnixWin() {
        Assertions.assertEquals((Object)"/a/c", (Object)FilenameUtils.normalizeNoEndSeparator("/a/b/../c/", true));
        Assertions.assertEquals((Object)"/a/c", (Object)FilenameUtils.normalizeNoEndSeparator("\\a\\b\\..\\c\\", true));
        Assertions.assertEquals((Object)"\\a\\c", (Object)FilenameUtils.normalizeNoEndSeparator("/a/b/../c/", false));
        Assertions.assertEquals((Object)"\\a\\c", (Object)FilenameUtils.normalizeNoEndSeparator("\\a\\b\\..\\c\\", false));
    }

    @Test
    public void testNormalizeUnixWin() {
        Assertions.assertEquals((Object)"/a/c/", (Object)FilenameUtils.normalize("/a/b/../c/", true));
        Assertions.assertEquals((Object)"/a/c/", (Object)FilenameUtils.normalize("\\a\\b\\..\\c\\", true));
        Assertions.assertEquals((Object)"\\a\\c\\", (Object)FilenameUtils.normalize("/a/b/../c/", false));
        Assertions.assertEquals((Object)"\\a\\c\\", (Object)FilenameUtils.normalize("\\a\\b\\..\\c\\", false));
    }

    @Test
    public void testRemoveExtension() {
        Assertions.assertNull((Object)FilenameUtils.removeExtension(null));
        Assertions.assertEquals((Object)"file", (Object)FilenameUtils.removeExtension("file.ext"));
        Assertions.assertEquals((Object)"README", (Object)FilenameUtils.removeExtension("README"));
        Assertions.assertEquals((Object)"domain.dot", (Object)FilenameUtils.removeExtension("domain.dot.com"));
        Assertions.assertEquals((Object)"image", (Object)FilenameUtils.removeExtension("image.jpeg"));
        Assertions.assertEquals((Object)"a.b/c", (Object)FilenameUtils.removeExtension("a.b/c"));
        Assertions.assertEquals((Object)"a.b/c", (Object)FilenameUtils.removeExtension("a.b/c.txt"));
        Assertions.assertEquals((Object)"a/b/c", (Object)FilenameUtils.removeExtension("a/b/c"));
        Assertions.assertEquals((Object)"a.b\\c", (Object)FilenameUtils.removeExtension("a.b\\c"));
        Assertions.assertEquals((Object)"a.b\\c", (Object)FilenameUtils.removeExtension("a.b\\c.txt"));
        Assertions.assertEquals((Object)"a\\b\\c", (Object)FilenameUtils.removeExtension("a\\b\\c"));
        Assertions.assertEquals((Object)"C:\\temp\\foo.bar\\README", (Object)FilenameUtils.removeExtension("C:\\temp\\foo.bar\\README"));
        Assertions.assertEquals((Object)"../filename", (Object)FilenameUtils.removeExtension("../filename.ext"));
    }

    @Test
    public void testSeparatorsToSystem() {
        if (WINDOWS) {
            Assertions.assertNull((Object)FilenameUtils.separatorsToSystem(null));
            Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem("\\a\\b\\c"));
            Assertions.assertEquals((Object)"\\a\\b\\c.txt", (Object)FilenameUtils.separatorsToSystem("\\a\\b\\c.txt"));
            Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem("\\a\\b/c"));
            Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem("/a/b/c"));
            Assertions.assertEquals((Object)"D:\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem("D:/a/b/c"));
        } else {
            Assertions.assertNull((Object)FilenameUtils.separatorsToSystem(null));
            Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToSystem("/a/b/c"));
            Assertions.assertEquals((Object)"/a/b/c.txt", (Object)FilenameUtils.separatorsToSystem("/a/b/c.txt"));
            Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToSystem("/a/b\\c"));
            Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToSystem("\\a\\b\\c"));
            Assertions.assertEquals((Object)"D:/a/b/c", (Object)FilenameUtils.separatorsToSystem("D:\\a\\b\\c"));
        }
    }

    @Test
    public void testSeparatorsToUnix() {
        Assertions.assertNull((Object)FilenameUtils.separatorsToUnix(null));
        Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToUnix("/a/b/c"));
        Assertions.assertEquals((Object)"/a/b/c.txt", (Object)FilenameUtils.separatorsToUnix("/a/b/c.txt"));
        Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToUnix("/a/b\\c"));
        Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToUnix("\\a\\b\\c"));
        Assertions.assertEquals((Object)"D:/a/b/c", (Object)FilenameUtils.separatorsToUnix("D:\\a\\b\\c"));
    }

    @Test
    public void testSeparatorsToWindows() {
        Assertions.assertNull((Object)FilenameUtils.separatorsToWindows(null));
        Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows("\\a\\b\\c"));
        Assertions.assertEquals((Object)"\\a\\b\\c.txt", (Object)FilenameUtils.separatorsToWindows("\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows("\\a\\b/c"));
        Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows("/a/b/c"));
        Assertions.assertEquals((Object)"D:\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows("D:/a/b/c"));
    }
}

