/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.util.Arrays;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractStreamBuilderTest {
    private void assertResult(char[] arr, int size) {
        Assertions.assertNotNull((Object)arr);
        Assertions.assertEquals((int)size, (int)arr.length);
        for (char c : arr) {
            Assertions.assertEquals((char)'a', (char)c);
        }
    }

    protected Builder builder() {
        return new Builder();
    }

    @Test
    public void testBufferSizeChecker() {
        Builder builder = this.builder();
        this.assertResult(builder.get(), builder.getBufferSize());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((Builder)this.builder().setBufferSizeMax(2)).setBufferSize(3));
        this.assertResult(((Builder)((Builder)((Builder)builder.setBufferSizeMax(2)).setBufferSizeMax(0)).setBufferSize(3)).get(), 3);
        this.assertResult(((Builder)((Builder)((Builder)this.builder().setBufferSizeMax(2)).setBufferSizeChecker(i -> 100)).setBufferSize(3)).get(), 100);
    }

    public static class Builder
    extends AbstractStreamBuilder<char[], Builder> {
        @Override
        public char[] get() {
            char[] arr = new char[this.getBufferSize()];
            Arrays.fill(arr, 'a');
            return arr;
        }
    }
}

