/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.commons.io.input.ClosedReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClosedReaderTest {
    private void assertEof(Reader reader) throws IOException {
        Assertions.assertEquals((int)-1, (int)reader.read(), (String)"read()");
    }

    @Test
    public void testRead() throws IOException {
        try (ClosedReader reader = new ClosedReader();){
            this.assertEof(reader);
        }
    }

    @Test
    public void testReadArray() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            Assertions.assertEquals((int)-1, (int)reader.read(new char[4096]));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[1]));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[0]));
        }
    }

    @Test
    public void testReadArrayIndex() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            Assertions.assertEquals((int)-1, (int)reader.read(CharBuffer.wrap(new char[4096])));
            Assertions.assertEquals((int)-1, (int)reader.read(CharBuffer.wrap(new char[1])));
            Assertions.assertEquals((int)-1, (int)reader.read(CharBuffer.wrap(new char[0])));
        }
    }

    @Test
    public void testReadCharBuffer() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            Assertions.assertEquals((int)-1, (int)reader.read(new char[4096]));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[1]));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[0]));
        }
    }

    @Test
    public void testSingleton() throws Exception {
        try (ClosedReader reader = ClosedReader.CLOSED_READER;){
            this.assertEof(reader);
        }
        reader = ClosedReader.INSTANCE;
        try {
            this.assertEof(reader);
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
    }

    @Test
    public void testSkip() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            Assertions.assertEquals((long)0L, (long)reader.skip(4096L));
            Assertions.assertEquals((long)0L, (long)reader.skip(1L));
            Assertions.assertEquals((long)0L, (long)reader.skip(0L));
        }
    }
}

