/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.MessageDigestCalculatingInputStream;
import org.apache.commons.io.input.MessageDigestInputStreamTest;
import org.apache.commons.io.input.ProxyInputStreamTest;
import org.apache.commons.io.test.CustomIOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MessageDigestCalculatingInputStreamTest {
    private InputStream createInputStream() throws IOException {
        ByteArrayInputStream origin = new ByteArrayInputStream(MessageDigestInputStreamTest.generateRandomByteStream(256));
        return this.createInputStream(origin);
    }

    private MessageDigestCalculatingInputStream createInputStream(InputStream origin) throws IOException {
        return ((MessageDigestCalculatingInputStream.Builder)MessageDigestCalculatingInputStream.builder().setInputStream(origin)).get();
    }

    @Test
    public void testAfterReadConsumer() throws Exception {
        AtomicBoolean boolRef = new AtomicBoolean();
        try (MessageDigestCalculatingInputStream bounded = ((MessageDigestCalculatingInputStream.Builder)((MessageDigestCalculatingInputStream.Builder)MessageDigestCalculatingInputStream.builder().setCharSequence("Hi")).setAfterRead(i -> boolRef.set(true))).get();){
            IOUtils.consume(bounded);
        }
        Assertions.assertTrue((boolean)boolRef.get());
        String message = "test exception message";
        try (MessageDigestCalculatingInputStream bounded = ((MessageDigestCalculatingInputStream.Builder)((MessageDigestCalculatingInputStream.Builder)MessageDigestCalculatingInputStream.builder().setCharSequence("Hi")).setAfterRead(i -> {
            throw new CustomIOException("test exception message");
        })).get();){
            Assertions.assertTrue((boolean)((IOExceptionList)Assertions.assertThrowsExactly(IOExceptionList.class, () -> IOUtils.consume(bounded))).getMessage().contains("test exception message"));
        }
    }

    @Test
    public void testAvailableAfterClose() throws Exception {
        InputStream shadow;
        try (InputStream in = this.createInputStream();){
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)shadow.available());
    }

    @Test
    public void testAvailableAfterOpen() throws Exception {
        try (InputStream in = this.createInputStream();){
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
            Assertions.assertNotEquals((int)-1, (int)in.read());
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCloseHandleIOException() throws IOException {
        ProxyInputStreamTest.testCloseHandleIOException(MessageDigestCalculatingInputStream.builder());
    }

    @Test
    public void testNormalUse() throws Exception {
        for (int i = 256; i < 8192; i *= 2) {
            byte[] buffer = MessageDigestInputStreamTest.generateRandomByteStream(i);
            MessageDigest defaultMessageDigest = MessageDigestCalculatingInputStream.getDefaultMessageDigest();
            byte[] defaultExpect = defaultMessageDigest.digest(buffer);
            try (MessageDigestCalculatingInputStream messageDigestInputStream = new MessageDigestCalculatingInputStream(new ByteArrayInputStream(buffer));){
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])defaultExpect, (byte[])messageDigestInputStream.getMessageDigest().digest());
            }
            messageDigestInputStream = ((MessageDigestCalculatingInputStream.Builder)MessageDigestCalculatingInputStream.builder().setInputStream(new ByteArrayInputStream(buffer))).get();
            try {
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])defaultExpect, (byte[])messageDigestInputStream.getMessageDigest().digest());
            }
            finally {
                if (messageDigestInputStream != null) {
                    messageDigestInputStream.close();
                }
            }
            messageDigestInputStream = ((MessageDigestCalculatingInputStream.Builder)MessageDigestCalculatingInputStream.builder().setByteArray(buffer)).get();
            try {
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])defaultExpect, (byte[])messageDigestInputStream.getMessageDigest().digest());
            }
            finally {
                if (messageDigestInputStream != null) {
                    messageDigestInputStream.close();
                }
            }
            byte[] sha512Expect = DigestUtils.sha512((byte[])buffer);
            MessageDigestCalculatingInputStream.Builder builder = MessageDigestCalculatingInputStream.builder();
            builder.setMessageDigest("SHA-512");
            builder.setInputStream(new ByteArrayInputStream(buffer));
            try (MessageDigestCalculatingInputStream messageDigestInputStream = builder.get();){
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])sha512Expect, (byte[])messageDigestInputStream.getMessageDigest().digest());
            }
            builder = MessageDigestCalculatingInputStream.builder();
            builder.setMessageDigest("SHA-512");
            builder.setInputStream(new ByteArrayInputStream(buffer));
            messageDigestInputStream = builder.get();
            try {
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])sha512Expect, (byte[])messageDigestInputStream.getMessageDigest().digest());
                continue;
            }
            finally {
                if (messageDigestInputStream != null) {
                    messageDigestInputStream.close();
                }
            }
        }
    }

    @Test
    public void testReadAfterClose_ByteArrayInputStream() throws Exception {
        try (InputStream in = this.createInputStream();){
            in.close();
            Assertions.assertNotEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testReadAfterClose_ChannelInputStream() throws Exception {
        try (MessageDigestCalculatingInputStream in = this.createInputStream(Files.newInputStream(Paths.get("src/test/resources/org/apache/commons/io/abitmorethan16k.txt", new String[0]), new OpenOption[0]));){
            ((InputStream)in).close();
            Assertions.assertThrows(IOException.class, in::read);
        }
    }
}

