/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ChunkedWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChunkedWriterTest {
    private OutputStreamWriter getOutputStreamWriter(final AtomicInteger numWrites) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return new OutputStreamWriter(baos){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                numWrites.incrementAndGet();
                super.write(cbuf, off, len);
            }
        };
    }

    @Test
    public void testNegative_chunkSize_not_permitted() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ChunkedWriter(new OutputStreamWriter(new ByteArrayOutputStream()), 0));
    }

    @Test
    public void testWrite_four_chunks() throws Exception {
        AtomicInteger numWrites = new AtomicInteger();
        try (OutputStreamWriter osw = this.getOutputStreamWriter(numWrites);
             ChunkedWriter chunked = new ChunkedWriter(osw, 10);){
            chunked.write("0123456789012345678901234567891".toCharArray());
            chunked.flush();
            Assertions.assertEquals((int)4, (int)numWrites.get());
        }
    }

    @Test
    public void testWrite_two_chunks_default_constructor() throws Exception {
        AtomicInteger numWrites = new AtomicInteger();
        try (OutputStreamWriter osw = this.getOutputStreamWriter(numWrites);
             ChunkedWriter chunked = new ChunkedWriter(osw);){
            chunked.write(new char[8193]);
            chunked.flush();
            Assertions.assertEquals((int)2, (int)numWrites.get());
        }
    }
}

