/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.indexeddb.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v131.indexeddb.model.KeyPath;
import org.openqa.selenium.json.JsonInput;

public class ObjectStoreIndex {
    private final String name;
    private final KeyPath keyPath;
    private final Boolean unique;
    private final Boolean multiEntry;

    public ObjectStoreIndex(String name, KeyPath keyPath, Boolean unique, Boolean multiEntry) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.keyPath = Objects.requireNonNull(keyPath, "keyPath is required");
        this.unique = Objects.requireNonNull(unique, "unique is required");
        this.multiEntry = Objects.requireNonNull(multiEntry, "multiEntry is required");
    }

    public String getName() {
        return this.name;
    }

    public KeyPath getKeyPath() {
        return this.keyPath;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public Boolean getMultiEntry() {
        return this.multiEntry;
    }

    private static ObjectStoreIndex fromJson(JsonInput input) {
        String name = null;
        KeyPath keyPath = null;
        Boolean unique = false;
        Boolean multiEntry = false;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block12;
                }
                case "keyPath": {
                    keyPath = (KeyPath)input.read((Type)((Object)KeyPath.class));
                    continue block12;
                }
                case "unique": {
                    unique = input.nextBoolean();
                    continue block12;
                }
                case "multiEntry": {
                    multiEntry = input.nextBoolean();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ObjectStoreIndex(name, keyPath, unique, multiEntry);
    }
}

