/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v132.cast;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v132.cast.model.Sink;

@Beta
public class Cast {
    public static Command<Void> enable(Optional<String> presentationUrl) {
        LinkedHashMap params = new LinkedHashMap();
        presentationUrl.ifPresent(p -> params.put("presentationUrl", p));
        return new Command<Void>("Cast.enable", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Cast.disable", Map.copyOf(params));
    }

    public static Command<Void> setSinkToUse(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("sinkName", sinkName);
        return new Command<Void>("Cast.setSinkToUse", Map.copyOf(params));
    }

    public static Command<Void> startDesktopMirroring(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("sinkName", sinkName);
        return new Command<Void>("Cast.startDesktopMirroring", Map.copyOf(params));
    }

    public static Command<Void> startTabMirroring(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("sinkName", sinkName);
        return new Command<Void>("Cast.startTabMirroring", Map.copyOf(params));
    }

    public static Command<Void> stopCasting(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("sinkName", sinkName);
        return new Command<Void>("Cast.stopCasting", Map.copyOf(params));
    }

    public static Event<List<Sink>> sinksUpdated() {
        return new Event<List<Sink>>("Cast.sinksUpdated", ConverterFunctions.map("sinks", input -> input.readArray((Type)((Object)Sink.class))));
    }

    public static Event<String> issueUpdated() {
        return new Event<String>("Cast.issueUpdated", ConverterFunctions.map("issueMessage", String.class));
    }
}

